/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.shields;

import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.query.condition.Condition;
import io.yawp.repository.shields.RuleConditions;
import java.util.List;

public class Rule<T> {
    private final Repository r;
    private final Class<?> endpointClazz;
    private final IdRef<?> id;
    private final List<T> objects;
    private RuleConditions conditions;
    private Class<? super T> facade;

    public Rule(Repository r, Class<?> endpointClazz, IdRef<?> id, List<T> objects) {
        this.r = r;
        this.endpointClazz = endpointClazz;
        this.id = id;
        this.objects = objects;
    }

    public boolean hasConditions() {
        return this.conditions != null;
    }

    public Class<? super T> getFacade() {
        return this.facade;
    }

    public boolean hasFacade() {
        return this.facade != null;
    }

    public Rule<T> where(String field, String operator, Object value) {
        return this.or(Condition.c(field, operator, value));
    }

    public Rule<T> where(BaseCondition condition) {
        return this.or(condition);
    }

    public Rule<T> or(String field, String operator, Object value) {
        return this.or(Condition.c(field, operator, value));
    }

    public Rule<T> or(BaseCondition condition) {
        this.getConditions().or(condition);
        return this;
    }

    public Rule<T> and(String field, String operator, Object value) {
        return this.and(Condition.c(field, operator, value));
    }

    public Rule<T> and(BaseCondition condition) {
        this.getConditions().and(condition);
        return this;
    }

    public Rule<T> facade(Class<? super T> facade) {
        this.facade = facade;
        return this;
    }

    public RuleConditions getConditions() {
        if (this.conditions != null) {
            return this.conditions;
        }
        this.conditions = new RuleConditions(this.r, this.endpointClazz, this.id, this.objects);
        return this.conditions;
    }
}

