/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.shields;

import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.models.ObjectHolder;
import io.yawp.repository.query.NoResultException;
import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.query.condition.Condition;
import java.util.List;

public class RuleConditions {
    private BaseCondition condition;
    private Repository r;
    private Class<?> endpointClazz;
    private IdRef<?> id;
    private List<?> objects;

    public RuleConditions(Repository r, Class<?> endpointClazz, IdRef<?> id, List<?> objects) {
        this.r = r;
        this.endpointClazz = endpointClazz;
        this.id = id;
        this.objects = objects;
    }

    public void where(BaseCondition condition) {
        this.or(condition);
    }

    public void or(BaseCondition condition) {
        if (this.condition != null) {
            this.condition = Condition.or(this.condition, condition);
            return;
        }
        this.condition = condition;
    }

    public void and(BaseCondition condition) {
        if (this.condition != null) {
            this.condition = Condition.and(this.condition, condition);
            return;
        }
        this.condition = condition;
    }

    public BaseCondition getWhere() {
        return this.condition;
    }

    private void initConditions() {
        if (this.condition == null) {
            return;
        }
        this.condition.init(this.r, this.endpointClazz);
    }

    public boolean evaluate() {
        this.initConditions();
        return this.evaluateIncoming() && this.evaluateExisting();
    }

    private boolean evaluateIncoming() {
        if (this.condition == null) {
            return true;
        }
        if (this.objects == null) {
            return true;
        }
        return this.evaluateObjects(new EvaluateIncoming());
    }

    private boolean evaluateExisting() {
        if (this.condition == null) {
            return true;
        }
        if (this.objects == null) {
            return this.condition.evaluate(this.id.fetch());
        }
        return this.evaluateObjects(new EvaluateExisting());
    }

    private boolean evaluateObjects(Evaluate e) {
        boolean result = true;
        for (Object object : this.objects) {
            if (result = result && e.evaluate(object)) continue;
            return false;
        }
        return true;
    }

    private class EvaluateExisting
    implements Evaluate {
        private EvaluateExisting() {
        }

        @Override
        public boolean evaluate(Object object) {
            Object existingObject;
            ObjectHolder objectHolder = new ObjectHolder(object);
            IdRef<?> id = objectHolder.getId();
            if (id == null) {
                return true;
            }
            try {
                existingObject = id.fetch();
            }
            catch (NoResultException e) {
                return true;
            }
            return RuleConditions.this.condition.evaluate(existingObject);
        }
    }

    private class EvaluateIncoming
    implements Evaluate {
        private EvaluateIncoming() {
        }

        @Override
        public boolean evaluate(Object object) {
            return RuleConditions.this.condition.evaluate(object);
        }
    }

    private static interface Evaluate {
        public boolean evaluate(Object var1);
    }
}

