/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.shields;

import io.yawp.commons.http.HttpException;
import io.yawp.commons.utils.FacadeUtils;
import io.yawp.repository.Feature;
import io.yawp.repository.IdRef;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.actions.ActionMethod;
import io.yawp.repository.actions.InvalidActionMethodException;
import io.yawp.repository.models.ObjectHolder;
import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.shields.Rule;
import io.yawp.repository.shields.ShieldRules;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class ShieldBase<T>
extends Feature {
    private ShieldRules<T> rules = new ShieldRules();
    private boolean allow = false;
    private Class<?> endpointClazz;
    private ActionKey actionKey;
    private Map<ActionKey, Method> actionMethods;
    protected IdRef<?> id;
    protected List<T> objects;
    protected String requestJson;
    protected Map<String, String> params;

    public abstract void always();

    public abstract void defaults();

    public abstract void index(IdRef<?> var1);

    public abstract void show(IdRef<T> var1);

    public abstract void create(List<T> var1);

    public abstract void update(IdRef<T> var1, T var2);

    public abstract void destroy(IdRef<T> var1);

    public void setEndpointClazz(Class<?> endpointClazz) {
        this.endpointClazz = endpointClazz;
    }

    public final void setId(IdRef<?> id) {
        this.id = id;
    }

    public void setRequestJson(String requestJson) {
        this.requestJson = requestJson;
    }

    public final void setParams(Map<String, String> params) {
        this.params = params;
    }

    public final void setActionKey(ActionKey actionKey) {
        this.actionKey = actionKey;
    }

    public final void setActionMethods(Map<ActionKey, Method> actionMethods) {
        this.actionMethods = actionMethods;
    }

    public final Rule<T> allow() {
        return this.allow(true);
    }

    public final Rule<T> allow(boolean allow) {
        Rule<T> rule = new Rule<T>(this.yawp, this.endpointClazz, this.id, this.objects);
        if (allow) {
            this.rules.add(rule);
            this.allow = true;
        }
        return rule;
    }

    public final boolean isAction(Class<?> ... actionClazzes) {
        return this.isActionRoute() && Arrays.asList(actionClazzes).contains(this.currentActionClazz());
    }

    private boolean isActionRoute() {
        return this.actionKey != null;
    }

    private Class<?> currentActionClazz() {
        return this.yawp.getFeatures().getByClazz(this.endpointClazz).getActionClazz(this.actionKey);
    }

    public final boolean requestHasAnyObject() {
        return this.objects != null;
    }

    public final void protectIndex() {
        this.always();
        this.index(this.id);
        this.throwNotFoundIfNotAllowed();
    }

    public final void protectShow() {
        this.always();
        this.show(this.id);
        this.throwNotFoundIfNotAllowed();
    }

    public final void protectCreate() {
        this.always();
        this.create(this.objects);
        this.throwNotFoundIfNotAllowed();
        this.applySetFacade();
        this.verifyConditions();
        this.throwForbiddenIfNotAllowed();
    }

    public final void protectUpdate() {
        this.always();
        this.update(this.id, this.objects == null ? null : (T)this.objects.get(0));
        this.throwNotFoundIfNotAllowed();
        this.applySetFacade();
        this.verifyConditions();
        this.throwForbiddenIfNotAllowed();
    }

    public final void protectDestroy() {
        this.always();
        this.destroy(this.id);
        this.throwNotFoundIfNotAllowed();
        this.verifyConditions();
        this.throwForbiddenIfNotAllowed();
    }

    public final void protectCustom() {
        this.always();
        this.protectEachCustomAction();
        this.throwNotFoundIfNotAllowed();
        this.verifyConditions();
        this.throwForbiddenIfNotAllowed();
    }

    private void throwNotFoundIfNotAllowed() {
        if (!this.allow) {
            throw new HttpException(404, "The resquest was not allowed by the endpoint shield " + this.getClass().getName());
        }
    }

    private void throwForbiddenIfNotAllowed() {
        if (!this.allow) {
            throw new HttpException(403, "The resquest was not allowed by the endpoint shield " + this.getClass().getName());
        }
    }

    private void applySetFacade() {
        Class<T> facade = this.rules.getFacade();
        if (facade == null) {
            return;
        }
        for (T object : this.objects) {
            ObjectHolder objectHolder = new ObjectHolder(object);
            IdRef<?> existingObjectId = objectHolder.getId();
            if (existingObjectId == null) {
                FacadeUtils.set(object, facade);
                continue;
            }
            FacadeUtils.set(object, existingObjectId.fetch(), facade);
        }
    }

    public void applyGetFacade(Object object) {
        Class<T> facade = this.rules.getFacade();
        if (facade == null) {
            return;
        }
        FacadeUtils.get(object, facade);
    }

    public final void setObjects(List<?> objects) {
        this.objects = objects;
    }

    public BaseCondition getWhere() {
        return this.rules.getWhere();
    }

    public boolean hasCondition() {
        return this.rules.hasCondition();
    }

    public boolean hasFacade() {
        return this.rules.hasFacade();
    }

    private void verifyConditions() {
        this.allow = this.rules.evaluateConditions();
    }

    private void protectEachCustomAction() {
        if (!this.actionMethods.containsKey(this.actionKey)) {
            this.defaults();
            return;
        }
        Method method = this.actionMethods.get(this.actionKey);
        this.invokeCustomActionShield(method);
    }

    private void invokeCustomActionShield(Method method) {
        try {
            method.invoke((Object)this, this.createArguments(method));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object[] createArguments(Method method) {
        try {
            ActionMethod actionMethod = new ActionMethod(method);
            return actionMethod.createArguments(this.yawp, this.id, this.requestJson, this.params);
        }
        catch (InvalidActionMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

