/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.shields;

import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.actions.ActionMethod;
import io.yawp.repository.actions.InvalidActionMethodException;
import io.yawp.repository.shields.Shield;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShieldInfo<T> {
    private Class<? extends Shield<? super T>> shieldClazz;
    private Map<ActionKey, Method> actionMethods;

    public ShieldInfo(Class<? extends Shield<? super T>> shieldClazz) {
        this.shieldClazz = shieldClazz;
        this.parseActionMethods();
    }

    public Class<? extends Shield<? super T>> getShieldClazz() {
        return this.shieldClazz;
    }

    public Map<ActionKey, Method> getActionMethods() {
        return this.actionMethods;
    }

    private void parseActionMethods() {
        Method[] methods;
        this.actionMethods = new HashMap<ActionKey, Method>();
        for (Method method : methods = this.shieldClazz.getDeclaredMethods()) {
            if (!ActionMethod.isAction(method)) continue;
            List<ActionKey> actionKeys = this.getActionKeysFor(method);
            for (ActionKey actionKey : actionKeys) {
                this.actionMethods.put(actionKey, method);
            }
        }
    }

    private List<ActionKey> getActionKeysFor(Method method) {
        try {
            return ActionMethod.getActionKeysFor(method);
        }
        catch (InvalidActionMethodException e) {
            throw new RuntimeException("Invalid action method in shield: " + this.shieldClazz.getName() + "." + method.getName(), e);
        }
    }
}

