/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.repository.shields;

import io.yawp.repository.query.condition.BaseCondition;
import io.yawp.repository.shields.Rule;
import io.yawp.repository.shields.RuleConditions;
import java.util.ArrayList;
import java.util.List;

public class ShieldRules<T> {
    private List<Rule<T>> rules = new ArrayList<Rule<T>>();
    private boolean merged;
    private RuleConditions conditions;
    private Class<? super T> facade;

    public void add(Rule<T> rule) {
        this.rules.add(rule);
    }

    public boolean hasCondition() {
        this.merge();
        return this.conditions != null;
    }

    public boolean evaluateConditions() {
        this.merge();
        if (this.conditions == null) {
            return true;
        }
        return this.conditions.evaluate();
    }

    public BaseCondition getWhere() {
        this.merge();
        return this.conditions.getWhere();
    }

    public boolean hasFacade() {
        this.merge();
        return this.facade != null;
    }

    public Class<? super T> getFacade() {
        this.merge();
        return this.facade;
    }

    private void merge() {
        if (this.merged) {
            return;
        }
        boolean emptyCondition = false;
        for (Rule<T> rule : this.rules) {
            if (!emptyCondition) {
                if (rule.hasConditions()) {
                    this.mergeConditions(rule);
                } else {
                    this.conditions = null;
                    emptyCondition = true;
                }
            }
            this.facade = rule.getFacade();
        }
        this.merged = true;
    }

    private void mergeConditions(Rule<T> rule) {
        if (this.conditions == null) {
            this.conditions = rule.getConditions();
        } else {
            this.conditions.or(rule.getConditions().getWhere());
        }
    }
}

