/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.servlet;

import io.yawp.commons.http.HttpException;
import io.yawp.commons.http.HttpResponse;
import io.yawp.commons.http.HttpVerb;
import io.yawp.commons.http.RequestContext;
import io.yawp.commons.utils.Environment;
import io.yawp.commons.utils.JsonUtils;
import io.yawp.repository.EndpointNotFoundException;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.RepositoryFeatures;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.models.ObjectHolder;
import io.yawp.servlet.Welcome;
import io.yawp.servlet.rest.RestAction;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class EndpointRouter {
    private Repository r;
    private RepositoryFeatures features;
    private String uri;
    private boolean overCollection;
    private ActionKey customActionKey;
    private HttpVerb verb;
    private IdRef<?> id;
    private Class<?> endpointClazz;
    private String requestJson;
    private Map<String, String> params;
    private List<?> objects;

    private EndpointRouter(Repository r, RequestContext ctx) {
        if (this.isWelcome(ctx.getUri())) {
            this.welcome(r);
        }
        this.r = r;
        this.verb = ctx.getHttpVerb();
        this.uri = ctx.getUri();
        this.requestJson = ctx.getJson();
        this.params = ctx.getParams();
        this.features = r.getFeatures();
        try {
            this.parseAll();
        }
        catch (EndpointNotFoundException e) {
            throw new HttpException(404, "Endpoint not found: " + e.getEndpointPath());
        }
    }

    private boolean isWelcome(String uri) {
        return uri.equals("") || uri.equals("/");
    }

    private void welcome(Repository r) {
        Welcome welcome = new Welcome();
        welcome.setMessage("Welcome to YAWP!");
        welcome.setVersion(Environment.version());
        welcome.setDriver(r.driver().name());
        throw new HttpException(200, JsonUtils.to(welcome));
    }

    public static EndpointRouter parse(Repository r, RequestContext ctx) {
        return new EndpointRouter(r, ctx);
    }

    private void parseAll() {
        this.id = IdRef.parse(this.r, this.verb, this.uri);
        this.customActionKey = this.parseCustomActionKey();
        this.overCollection = this.parseOverCollection();
        this.endpointClazz = this.parseEndpointClazz();
        if (!this.isCustomAction()) {
            this.objects = this.parseRequestJson();
        }
    }

    private Class<?> parseEndpointClazz() {
        String[] parts = this.uri.substring(1).split("/");
        if (this.isOverCollection()) {
            if (this.isCustomAction()) {
                return this.features.getByPath("/" + parts[parts.length - 2]).getClazz();
            }
            return this.features.getByPath("/" + parts[parts.length - 1]).getClazz();
        }
        return this.id.getClazz();
    }

    private ActionKey parseCustomActionKey() {
        if (this.id == null) {
            return this.rootCollectionCustomActionKey();
        }
        if (this.id.getUri().length() == this.uri.length()) {
            return null;
        }
        String lastToken = this.uri.substring(this.id.getUri().length() + 1);
        if (this.hasTwoParts(lastToken)) {
            return this.nestedCollectionCustomActionKey(lastToken);
        }
        return this.singleObjectCustomActionKey(lastToken);
    }

    private ActionKey singleObjectCustomActionKey(String lastToken) {
        ActionKey actionKey = new ActionKey(this.verb, lastToken, false);
        if (this.features.hasCustomAction(this.id.getClazz(), actionKey)) {
            return actionKey;
        }
        return null;
    }

    private ActionKey nestedCollectionCustomActionKey(String lastToken) {
        String[] tokens = lastToken.split("/");
        ActionKey actionKey = new ActionKey(this.verb, tokens[1], true);
        if (this.features.hasCustomAction("/" + tokens[0], actionKey)) {
            return actionKey;
        }
        return null;
    }

    private ActionKey rootCollectionCustomActionKey() {
        String[] tokens = this.uri.substring(1).split("/");
        if (tokens.length == 1) {
            return null;
        }
        ActionKey actionKey = new ActionKey(this.verb, tokens[1], true);
        if (this.features.hasCustomAction("/" + tokens[0], actionKey)) {
            return actionKey;
        }
        return null;
    }

    private boolean parseOverCollection() {
        if (this.id == null) {
            return true;
        }
        if (this.id.getUri().length() == this.uri.length()) {
            return false;
        }
        String lastToken = this.uri.substring(this.id.getUri().length() + 1);
        if (this.hasTwoParts(lastToken)) {
            return true;
        }
        ActionKey actionKey = new ActionKey(this.verb, lastToken, false);
        return !this.features.hasCustomAction(this.id.getClazz(), actionKey);
    }

    private boolean hasTwoParts(String lastToken) {
        return lastToken.contains("/");
    }

    public boolean isOverCollection() {
        return this.overCollection;
    }

    public boolean isCustomAction() {
        return this.customActionKey != null;
    }

    public String getCustomActionName() {
        if (!this.isCustomAction()) {
            return null;
        }
        return this.customActionKey.getActionName();
    }

    private RestAction createRestAction(boolean enableHooks) {
        try {
            Class<? extends RestAction> restActionClazz = RestAction.getRestActionClazz(this.verb, this.isOverCollection(), this.isCustomAction());
            RestAction action = restActionClazz.newInstance();
            action.setRepository(this.r);
            action.setEnableHooks(enableHooks);
            action.setEndpointClazz(this.endpointClazz);
            action.setId(this.id);
            action.setParams(this.params);
            action.setCustomActionKey(this.customActionKey);
            action.setRequestJson(this.requestJson);
            action.setObjects(this.objects);
            action.defineTrasnformer();
            action.defineShield();
            return action;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private List<?> parseRequestJson() {
        if (StringUtils.isBlank((CharSequence)this.requestJson)) {
            return null;
        }
        if (JsonUtils.isJsonArray(this.requestJson)) {
            return JsonUtils.fromList(this.r, this.requestJson, this.endpointClazz);
        }
        return Collections.singletonList(JsonUtils.from(this.r, this.requestJson, this.endpointClazz));
    }

    public HttpResponse executeRestAction(boolean enableHooks) {
        return this.createRestAction(enableHooks).execute();
    }

    public boolean isValid() {
        return this.tryToAdjustIds();
    }

    public boolean tryToAdjustIds() {
        if (this.objects == null) {
            return true;
        }
        for (Object object : this.objects) {
            IdRef<?> idInObject = this.forceIdInObjectIfNecessary(object);
            IdRef<?> parentIdInObject = this.forceParentIdInObjectIfNecessary(object, idInObject);
            if (idInObject == null) {
                if (parentIdInObject == null || this.id == null || parentIdInObject.equals(this.id)) continue;
                return false;
            }
            if (parentIdInObject != null && !parentIdInObject.equals(idInObject.getParentId())) {
                return false;
            }
            if (!idInObject.getClazz().equals(this.endpointClazz)) {
                return false;
            }
            if (this.id == null || this.id.equals(idInObject)) continue;
            if (this.verb != HttpVerb.POST) {
                return false;
            }
            if (this.id.isAncestorId(idInObject)) continue;
            return false;
        }
        return true;
    }

    private IdRef<?> forceParentIdInObjectIfNecessary(Object object, IdRef<?> idInObject) {
        ObjectHolder objectHolder = new ObjectHolder(object);
        if (objectHolder.getModel().getParentClazz() == null) {
            return null;
        }
        IdRef<?> parentId = objectHolder.getParentId();
        if (parentId != null) {
            return parentId;
        }
        if (idInObject != null) {
            objectHolder.setParentId(idInObject.getParentId());
            return idInObject.getParentId();
        }
        if (this.id != null) {
            objectHolder.setParentId(this.id);
            return this.id;
        }
        return null;
    }

    private IdRef<?> forceIdInObjectIfNecessary(Object object) {
        ObjectHolder objectHolder = new ObjectHolder(object);
        IdRef<?> idInObject = objectHolder.getId();
        if (idInObject != null) {
            return idInObject;
        }
        if (this.id != null && this.id.getClazz().equals(this.endpointClazz)) {
            objectHolder.setId(this.id);
            return this.id;
        }
        return null;
    }
}

