/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.servlet;

import io.yawp.commons.http.HttpException;
import io.yawp.commons.http.HttpResponse;
import io.yawp.commons.http.JsonResponse;
import io.yawp.commons.http.RequestContext;
import io.yawp.driver.api.DriverFactory;
import io.yawp.repository.Repository;
import io.yawp.repository.Yawp;
import io.yawp.servlet.EndpointRouter;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EndpointServlet
extends HttpServlet {
    private static final long serialVersionUID = 8155293897299089610L;
    private boolean enableHooks = true;
    private boolean enableCrossDomain = false;

    public EndpointServlet() {
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setWithHooks(config.getInitParameter("enableHooks"));
        this.setCrossDomain(config.getInitParameter("enableCrossDomain"));
        this.initYawp(config.getInitParameter("packagePrefix"));
    }

    public void destroy() {
        super.destroy();
        Yawp.destroyFeatures();
    }

    private void setWithHooks(String enableHooksParameter) {
        if (!this.enableHooks) {
            return;
        }
        boolean enableHooks = enableHooksParameter == null || Boolean.valueOf(enableHooksParameter) != false;
        this.setWithHooks(enableHooks);
    }

    private void setCrossDomain(String enableCrossDomainParameter) {
        this.enableCrossDomain = enableCrossDomainParameter != null ? Boolean.valueOf(enableCrossDomainParameter) : !DriverFactory.getDriver().environment().isProduction();
    }

    protected void setWithHooks(boolean enableHooks) {
        this.enableHooks = enableHooks;
    }

    protected EndpointServlet(String packagePrefix) {
        this.initYawp(packagePrefix);
    }

    @Deprecated
    private void initYawp(String packagePrefix) {
        if (packagePrefix == null) {
            return;
        }
        Yawp.init(packagePrefix);
    }

    protected void response(HttpServletResponse resp, HttpResponse httpResponse) throws IOException {
        if (httpResponse == null) {
            new JsonResponse().execute(resp);
        } else {
            httpResponse.execute(resp);
        }
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpResponse httpResponse;
        try {
            httpResponse = this.execute(new RequestContext(req, resp));
        }
        catch (HttpException e) {
            httpResponse = e.createResponse();
        }
        if (this.enableCrossDomain) {
            resp.setHeader("Access-Control-Allow-Origin", "*");
            resp.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
            resp.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, OPTIONS, DELETE");
        }
        this.response(resp, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(RequestContext ctx) {
        try {
            Repository r = this.getRepository(ctx);
            EndpointRouter router = EndpointRouter.parse(r, ctx);
            if (!router.isValid()) {
                throw new HttpException(400, "Invalid route. Please check uri, json format, object ids and parent structure, etc.");
            }
            HttpResponse httpResponse = router.executeRestAction(this.enableHooks);
            return httpResponse;
        }
        finally {
            Yawp.dispose();
        }
    }

    protected Repository getRepository(RequestContext ctx) {
        return Yawp.yawp().setRequestContext(ctx);
    }
}

