/*
 * Decompiled with CFR 0.152.
 */
package io.yawp.servlet.rest;

import io.yawp.commons.http.HttpException;
import io.yawp.commons.http.HttpResponse;
import io.yawp.commons.http.HttpVerb;
import io.yawp.commons.http.JsonResponse;
import io.yawp.commons.utils.JsonUtils;
import io.yawp.repository.EndpointFeatures;
import io.yawp.repository.FutureObject;
import io.yawp.repository.IdRef;
import io.yawp.repository.Repository;
import io.yawp.repository.actions.ActionKey;
import io.yawp.repository.hooks.RepositoryHooks;
import io.yawp.repository.query.QueryBuilder;
import io.yawp.repository.shields.Shield;
import io.yawp.repository.shields.ShieldInfo;
import io.yawp.repository.transformers.RepositoryTransformers;
import io.yawp.servlet.rest.CreateRestAction;
import io.yawp.servlet.rest.CustomRestAction;
import io.yawp.servlet.rest.DestroyRestAction;
import io.yawp.servlet.rest.IndexRestAction;
import io.yawp.servlet.rest.PatchRestAction;
import io.yawp.servlet.rest.RoutesRestAction;
import io.yawp.servlet.rest.ShowRestAction;
import io.yawp.servlet.rest.UpdateRestAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class RestAction {
    private static final String DEFAULT_TRANSFORMER_NAME = "defaults";
    protected static final String QUERY_OPTIONS = "q";
    protected static final String TRANSFORMER = "t";
    protected Repository r;
    protected boolean enableHooks;
    protected Class<?> endpointClazz;
    protected IdRef<?> id;
    protected Map<String, String> params;
    protected ActionKey customActionKey;
    protected String actionName;
    protected String transformerName;
    protected Shield<?> shield;
    private List<?> objects;
    protected String requestJson;
    private boolean requestBodyJsonArray;

    public RestAction(String actionName) {
        this.actionName = actionName;
    }

    public void setRepository(Repository r) {
        this.r = r;
    }

    public void setEnableHooks(boolean enableHooks) {
        this.enableHooks = enableHooks;
    }

    public void setEndpointClazz(Class<?> clazz) {
        this.endpointClazz = clazz;
    }

    public void setId(IdRef<?> id) {
        this.id = id;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setCustomActionKey(ActionKey customActionKey) {
        this.customActionKey = customActionKey;
    }

    public boolean isRequestBodyJsonArray() {
        return this.requestBodyJsonArray;
    }

    public void setRequestJson(String requestJson) {
        this.requestJson = requestJson;
        this.requestBodyJsonArray = JsonUtils.isJsonArray(requestJson);
    }

    public void setRequestBodyJsonArray(boolean requestBodyJsonArray) {
        this.requestBodyJsonArray = requestBodyJsonArray;
    }

    protected void beforeShieldHooks() {
        if (this.objects == null) {
            return;
        }
        for (Object object : this.objects) {
            RepositoryHooks.beforeShield(this.r, object);
        }
    }

    public abstract void shield();

    public abstract Object action();

    public HttpResponse execute() {
        this.executeShield();
        Object object = this.action();
        if (HttpResponse.class.isInstance(object)) {
            return (HttpResponse)object;
        }
        return new JsonResponse(JsonUtils.to(object));
    }

    private void executeShield() {
        if (!this.enableHooks) {
            return;
        }
        this.beforeShieldHooks();
        if (this.hasShield()) {
            this.shield();
        }
    }

    protected QueryBuilder<?> query() {
        if (this.enableHooks) {
            return this.r.queryWithHooks(this.endpointClazz);
        }
        return this.r.query(this.endpointClazz);
    }

    protected void save(Object object) {
        if (this.enableHooks) {
            this.r.saveWithHooks(object);
        } else {
            this.r.save(object);
        }
    }

    protected FutureObject<Object> saveAsync(Object object) {
        if (this.enableHooks) {
            return this.r.async().saveWithHooks(object);
        }
        return this.r.async().save(object);
    }

    protected Object transform(Object object) {
        if (this.isList(object)) {
            return this.transform((List)object);
        }
        if (!this.hasTransformer() || !object.getClass().equals(this.endpointClazz)) {
            return object;
        }
        return RepositoryTransformers.execute(this.r, object, this.getTransformerName());
    }

    protected Object transform(List<?> objects) {
        if (!this.hasTransformer()) {
            return objects;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object object : objects) {
            if (!this.hasTransformer() || !object.getClass().equals(this.endpointClazz)) {
                result.add(object);
                continue;
            }
            result.add(RepositoryTransformers.execute(this.r, object, this.getTransformerName()));
        }
        return result;
    }

    protected void applyGetFacade(Object object) {
        if (this.isList(object)) {
            this.applyGetFacade((List)object);
        }
        if (!this.hasFacade()) {
            return;
        }
        this.shield.applyGetFacade(object);
    }

    protected void applyGetFacade(List<?> objects) {
        if (!this.hasFacade()) {
            return;
        }
        for (Object object : objects) {
            this.shield.applyGetFacade(object);
        }
    }

    protected String getTransformerName() {
        return this.transformerName;
    }

    protected boolean hasTransformer() {
        return this.transformerName != null;
    }

    public void defineTrasnformer() {
        if (this.params.containsKey(TRANSFORMER)) {
            this.transformerName = this.params.get(TRANSFORMER);
            return;
        }
        if (this.r.getEndpointFeatures(this.endpointClazz).hasTranformer(this.actionName)) {
            this.transformerName = this.actionName;
            return;
        }
        if (this.r.getEndpointFeatures(this.endpointClazz).hasTranformer(DEFAULT_TRANSFORMER_NAME)) {
            this.transformerName = DEFAULT_TRANSFORMER_NAME;
            return;
        }
    }

    protected boolean hasShield() {
        return this.shield != null;
    }

    protected boolean hasFacade() {
        return this.shield != null && this.shield.hasFacade();
    }

    protected boolean hasShieldCondition() {
        return this.hasShield() && this.shield.hasCondition();
    }

    public void defineShield() {
        EndpointFeatures<?> endpointFeatures = this.r.getEndpointFeatures(this.endpointClazz);
        if (endpointFeatures.hasShield()) {
            this.shield = this.createShield(endpointFeatures);
        }
    }

    private Shield<?> createShield(EndpointFeatures<?> endpointFeatures) {
        try {
            ShieldInfo<?> shieldInfo = endpointFeatures.getShieldInfo();
            Shield<?> shield = shieldInfo.getShieldClazz().newInstance();
            shield.setRepository(this.r);
            shield.setEndpointClazz(this.endpointClazz);
            shield.setId(this.id);
            shield.setObjects(this.objects);
            shield.setRequestJson(this.requestJson);
            shield.setParams(this.params);
            shield.setActionKey(this.customActionKey);
            shield.setActionMethods(shieldInfo.getActionMethods());
            return shield;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setObjects(List<?> objects) {
        this.objects = objects;
    }

    public List<?> getObjects() {
        return this.requestBodyJsonArray ? this.objects : null;
    }

    public Object getObject() {
        return this.objects == null || this.requestBodyJsonArray ? null : this.objects.get(0);
    }

    public static Class<? extends RestAction> getRestActionClazz(HttpVerb verb, boolean overCollection, boolean isCustomAction) {
        if (isCustomAction) {
            return CustomRestAction.class;
        }
        switch (verb) {
            case GET: {
                return overCollection ? IndexRestAction.class : ShowRestAction.class;
            }
            case POST: {
                return CreateRestAction.class;
            }
            case PUT: {
                RestAction.assertNotOverCollection(overCollection);
                return UpdateRestAction.class;
            }
            case PATCH: {
                RestAction.assertNotOverCollection(overCollection);
                return PatchRestAction.class;
            }
            case DELETE: {
                RestAction.assertNotOverCollection(overCollection);
                return DestroyRestAction.class;
            }
            case OPTIONS: {
                return RoutesRestAction.class;
            }
        }
        throw new HttpException(501, "Unsuported http verb " + (Object)((Object)verb));
    }

    private static void assertNotOverCollection(boolean overCollection) {
        if (overCollection) {
            throw new HttpException(501);
        }
    }

    private boolean isList(Object object) {
        return List.class.isAssignableFrom(object.getClass());
    }
}

