/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="setup", defaultPhase=LifecyclePhase.INITIALIZE)
public class SetupMojo
extends AbstractMojo {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final String SHEBANG = "#!/bin/sh" + LINE_SEPARATOR;
    private static final String PRE_COMMIT_SCRIPT = ".githooks/pre-commit" + LINE_SEPARATOR;
    @Parameter(defaultValue="${maven.multiModuleProjectDirectory}", property="rootDir", required=true)
    private File rootDir;

    public void execute() throws MojoExecutionException {
        this.ensureGitHooksDirExists();
        this.ensurePreCommitFileExists();
        this.ensurePreCommitFilePermissions();
        this.ensurePreCommitScript();
    }

    private void ensureGitHooksDirExists() throws MojoExecutionException {
        Path gitHooksDir = this.getGitHooksDir();
        File file = gitHooksDir.toFile();
        if (file.isDirectory()) {
            this.getLog().debug((CharSequence)("Git hooks directory " + file.getAbsolutePath() + " exist"));
        } else {
            if (file.exists()) {
                throw new MojoExecutionException("Git hooks directory " + file.getAbsolutePath() + " exists but is not directory");
            }
            if (file.mkdirs()) {
                this.getLog().info((CharSequence)("Created git hooks directory " + file.getAbsolutePath()));
            } else {
                throw new MojoExecutionException("Failed to create git hooks directory " + file.getAbsolutePath());
            }
        }
    }

    private void ensurePreCommitFileExists() throws MojoExecutionException {
        Path preCommitFile = this.getPreCommitFile();
        File file = preCommitFile.toFile();
        if (file.isFile()) {
            this.getLog().debug((CharSequence)("Pre-commit hook " + file.getAbsolutePath() + " file exist"));
        } else {
            if (file.exists()) {
                throw new MojoExecutionException("Pre-commit hook file " + file.getAbsolutePath() + " exists but is not a file");
            }
            try {
                Files.write(preCommitFile, SHEBANG.getBytes(CHARSET), StandardOpenOption.CREATE);
                this.getLog().info((CharSequence)("Created pre-commit hook file " + file.getAbsolutePath()));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create pre-commit hook file " + file.getAbsolutePath(), (Exception)e);
            }
        }
    }

    private void ensurePreCommitFilePermissions() throws MojoExecutionException {
        Path preCommitFile = this.getPreCommitFile();
        try {
            Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxrwxrwx");
            if (!Files.getPosixFilePermissions(preCommitFile, new LinkOption[0]).equals(permissions)) {
                Files.setPosixFilePermissions(preCommitFile, permissions);
                this.getLog().info((CharSequence)("Set file permissions for pre-commit hook file " + preCommitFile.toAbsolutePath()));
            }
        }
        catch (UnsupportedOperationException e) {
            this.getLog().debug((CharSequence)"Skip setting file permissions as it is not supported on this system", (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to set file permissions for pre-commit hook file " + preCommitFile.toAbsolutePath(), (Exception)e);
        }
    }

    private void ensurePreCommitScript() throws MojoExecutionException {
        Path preCommitFile = this.getPreCommitFile();
        try {
            String preCommitFileContent = new String(Files.readAllBytes(preCommitFile), CHARSET);
            if (!preCommitFileContent.contains(PRE_COMMIT_SCRIPT)) {
                Files.write(preCommitFile, PRE_COMMIT_SCRIPT.getBytes(CHARSET), StandardOpenOption.APPEND);
                this.getLog().info((CharSequence)("Added pre-commit script to file " + preCommitFile.toAbsolutePath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read content of pre-commit file " + preCommitFile.toAbsolutePath());
        }
    }

    private Path getGitHooksDir() {
        return Paths.get(this.rootDir.getAbsolutePath(), ".git", "hooks");
    }

    private Path getPreCommitFile() {
        return this.getGitHooksDir().resolve("pre-commit");
    }
}

