/*
 * Decompiled with CFR 0.152.
 */
package brave.instrumentation.awsv2;

import brave.Span;
import brave.Tracer;
import brave.http.HttpClientAdapter;
import brave.http.HttpClientHandler;
import brave.http.HttpTracing;
import brave.instrumentation.awsv2.HttpAdapter;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;

final class TracingExecutionInterceptor
implements ExecutionInterceptor {
    static final ExecutionAttribute<TraceContext> DEFERRED_ROOT_CONTEXT = new ExecutionAttribute("DEFERRED_ROOT_CONTEXT");
    static final ExecutionAttribute<Span> APPLICATION_SPAN = new ExecutionAttribute("APPLICATION_SPAN");
    static final ExecutionAttribute<Span> CLIENT_SPAN = new ExecutionAttribute(Span.class.getCanonicalName());
    static final HttpClientAdapter<SdkHttpRequest.Builder, SdkHttpResponse> ADAPTER = new HttpAdapter();
    static final Propagation.Setter<SdkHttpRequest.Builder, String> SETTER = SdkHttpRequest.Builder::appendHeader;
    final Tracer tracer;
    final HttpTracing httpTracing;
    final HttpClientHandler<SdkHttpRequest.Builder, SdkHttpResponse> handler;
    final TraceContext.Injector<SdkHttpRequest.Builder> injector;

    TracingExecutionInterceptor(HttpTracing httpTracing) {
        this.httpTracing = httpTracing;
        this.tracer = httpTracing.tracing().tracer();
        this.injector = httpTracing.tracing().propagation().injector(SETTER);
        this.handler = HttpClientHandler.create((HttpTracing)httpTracing, ADAPTER);
    }

    public void beforeExecution(Context.BeforeExecution context, ExecutionAttributes executionAttributes) {
        Span maybeDeferredRootSpan = this.tracer.nextSpan();
        if (maybeDeferredRootSpan.context().parentIdAsLong() == 0L) {
            executionAttributes.putAttribute(DEFERRED_ROOT_CONTEXT, (Object)maybeDeferredRootSpan.context());
        } else {
            executionAttributes.putAttribute(APPLICATION_SPAN, (Object)maybeDeferredRootSpan.start());
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Span applicationSpan;
        TraceContext maybeDeferredRootSpan = (TraceContext)executionAttributes.getAttribute(DEFERRED_ROOT_CONTEXT);
        if (maybeDeferredRootSpan != null) {
            Boolean sampled = this.httpTracing.clientSampler().trySample(ADAPTER, (Object)((SdkHttpRequest.Builder)context.httpRequest().toBuilder()));
            if (sampled == null) {
                sampled = this.httpTracing.tracing().sampler().isSampled(maybeDeferredRootSpan.traceId());
            }
            applicationSpan = this.tracer.toSpan(maybeDeferredRootSpan.toBuilder().sampled(sampled).build());
            executionAttributes.putAttribute(APPLICATION_SPAN, (Object)applicationSpan.start());
        } else {
            applicationSpan = (Span)executionAttributes.getAttribute(APPLICATION_SPAN);
        }
        String serviceName = (String)executionAttributes.getAttribute(SdkExecutionAttribute.SERVICE_NAME);
        String operation = this.getAwsOperationNameFromRequestClass(context.request());
        applicationSpan.name("aws-sdk").tag("aws.service_name", serviceName).tag("aws.operation", operation);
        return (SdkHttpRequest)context.httpRequest().copy(builder -> {
            Span clientSpan = this.nextClientSpan(applicationSpan, serviceName, operation, (SdkHttpRequest.Builder)builder);
            executionAttributes.putAttribute(CLIENT_SPAN, (Object)clientSpan);
        });
    }

    public void beforeUnmarshalling(Context.BeforeUnmarshalling context, ExecutionAttributes executionAttributes) {
        Span clientSpan = (Span)executionAttributes.getAttribute(CLIENT_SPAN);
        if (!context.httpResponse().isSuccessful()) {
            clientSpan.tag("error", context.httpResponse().statusText().orElse("Unknown AWS service error"));
        }
        this.handler.handleReceive((Object)context.httpResponse(), null, clientSpan);
        executionAttributes.putAttribute(CLIENT_SPAN, null);
    }

    public void afterExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes) {
        Span applicationSpan = (Span)executionAttributes.getAttribute(APPLICATION_SPAN);
        applicationSpan.finish();
    }

    public void onExecutionFailure(Context.FailedExecution context, ExecutionAttributes executionAttributes) {
        Span clientSpan = (Span)executionAttributes.getAttribute(CLIENT_SPAN);
        if (clientSpan != null) {
            this.handler.handleReceive(null, context.exception(), clientSpan);
            executionAttributes.putAttribute(CLIENT_SPAN, null);
        }
        Span applicationSpan = (Span)executionAttributes.getAttribute(APPLICATION_SPAN);
        applicationSpan.error(context.exception());
        applicationSpan.finish();
    }

    private Span nextClientSpan(Span applicationSpan, String serviceName, String operation, SdkHttpRequest.Builder sdkHttpRequestBuilder) {
        Span span = this.tracer.newChild(applicationSpan.context());
        this.handler.handleSend(this.injector, (Object)sdkHttpRequestBuilder, span);
        return span.name(operation).remoteServiceName(serviceName);
    }

    private String getAwsOperationNameFromRequestClass(SdkRequest request) {
        String operation = request.getClass().getSimpleName();
        if (operation.endsWith("Request")) {
            return operation.substring(0, operation.length() - 7);
        }
        return operation;
    }
}

