/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation.aws;

import brave.Tracing;
import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.TraceIdContext;
import java.util.Collections;
import java.util.List;

public final class AWSPropagation<K>
implements Propagation<K> {
    public static final Propagation.Factory FACTORY = new Propagation.Factory(){

        public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
            return new AWSPropagation<K>(keyFactory);
        }

        public boolean requires128BitTraceId() {
            return true;
        }

        public String toString() {
            return "AWSPropagationFactory";
        }
    };
    static final String TRACE_ID_NAME = "x-amzn-trace-id";
    static final char[] ROOT = "Root=".toCharArray();
    static final char[] PARENT = ";Parent=".toCharArray();
    static final char[] SAMPLED = ";Sampled=".toCharArray();
    public static final int ROOT_LENGTH = 35;
    final K traceIdKey;
    final List<K> fields;
    static final AWSExtractor<String, String> STRING_EXTRACTOR = new AWSExtractor<String, String>(new AWSPropagation(Propagation.KeyFactory.STRING), new Propagation.Getter<String, String>(){

        public String get(String carrier, String key) {
            return carrier;
        }
    });
    static final Extra MARKER = new Extra();
    static final List<Object> DEFAULT_EXTRA = Collections.singletonList(MARKER);
    static final TraceContextOrSamplingFlags EMPTY = TraceContextOrSamplingFlags.EMPTY.toBuilder().extra(DEFAULT_EXTRA).build();

    AWSPropagation(Propagation.KeyFactory<K> keyFactory) {
        this.traceIdKey = keyFactory.create(TRACE_ID_NAME);
        this.fields = Collections.singletonList(this.traceIdKey);
    }

    public List<K> keys() {
        return this.fields;
    }

    public <C> TraceContext.Injector<C> injector(Propagation.Setter<C, K> setter) {
        if (setter == null) {
            throw new NullPointerException("setter == null");
        }
        return new AWSInjector<C, K>(this, setter);
    }

    @Nullable
    public static String currentTraceId() {
        Tracing tracing = Tracing.current();
        if (tracing == null) {
            return null;
        }
        TraceContext context = tracing.currentTraceContext().get();
        if (context == null) {
            return null;
        }
        return AWSPropagation.traceId(context);
    }

    @Nullable
    public static String traceId(TraceContext context) {
        int length = context.extra().size();
        for (int i = 0; i < length; ++i) {
            Object next = context.extra().get(i);
            if (!(next instanceof Extra)) continue;
            char[] result = new char[35];
            AWSPropagation.writeRoot(context, result, 0);
            return new String(result);
        }
        String maybeHeader = ExtraFieldPropagation.get((TraceContext)context, (String)TRACE_ID_NAME);
        if (maybeHeader == null) {
            return null;
        }
        int i = maybeHeader.indexOf("Root=");
        if (i == -1) {
            return null;
        }
        if (maybeHeader.length() < (i += 5) + 35) {
            return null;
        }
        return maybeHeader.substring(i, i + 35);
    }

    static void writeRoot(TraceContext context, char[] result, int offset) {
        result[offset] = 49;
        result[offset + 1] = 45;
        long high = context.traceIdHigh();
        HexCodec.writeHexByte((char[])result, (int)(offset + 2), (byte)((byte)(high >>> 56 & 0xFFL)));
        HexCodec.writeHexByte((char[])result, (int)(offset + 4), (byte)((byte)(high >>> 48 & 0xFFL)));
        HexCodec.writeHexByte((char[])result, (int)(offset + 6), (byte)((byte)(high >>> 40 & 0xFFL)));
        HexCodec.writeHexByte((char[])result, (int)(offset + 8), (byte)((byte)(high >>> 32 & 0xFFL)));
        result[offset + 10] = 45;
        HexCodec.writeHexByte((char[])result, (int)(offset + 11), (byte)((byte)(high >>> 24 & 0xFFL)));
        HexCodec.writeHexByte((char[])result, (int)(offset + 13), (byte)((byte)(high >>> 16 & 0xFFL)));
        HexCodec.writeHexByte((char[])result, (int)(offset + 15), (byte)((byte)(high >>> 8 & 0xFFL)));
        HexCodec.writeHexByte((char[])result, (int)(offset + 17), (byte)((byte)(high & 0xFFL)));
        HexCodec.writeHexLong((char[])result, (int)(offset + 19), (long)context.traceId());
    }

    public <C> TraceContext.Extractor<C> extractor(Propagation.Getter<C, K> getter) {
        if (getter == null) {
            throw new NullPointerException("getter == null");
        }
        return new AWSExtractor<C, K>(this, getter);
    }

    public static TraceContextOrSamplingFlags extractLambda() {
        return STRING_EXTRACTOR.extract(System.getenv("_X_AMZN_TRACE_ID"));
    }

    public static TraceContextOrSamplingFlags extract(String amznTraceId) {
        if (amznTraceId == null) {
            return EMPTY;
        }
        return STRING_EXTRACTOR.extract(amznTraceId);
    }

    static final class Extra {
        CharSequence fields;

        Extra() {
        }

        public String toString() {
            return "AWSPropagation{" + (this.fields != null ? "fields=" + this.fields.toString() : "") + "}";
        }
    }

    static final class AWSExtractor<C, K>
    implements TraceContext.Extractor<C> {
        final AWSPropagation<K> propagation;
        final Propagation.Getter<C, K> getter;

        AWSExtractor(AWSPropagation<K> propagation, Propagation.Getter<C, K> getter) {
            this.propagation = propagation;
            this.getter = getter;
        }

        /*
         * Enabled aggressive block sorting
         */
        public TraceContextOrSamplingFlags extract(C carrier) {
            List<Object> extra;
            if (carrier == null) {
                throw new NullPointerException("carrier == null");
            }
            String traceIdString = this.getter.get(carrier, this.propagation.traceIdKey);
            if (traceIdString == null) {
                return EMPTY;
            }
            Boolean sampled = null;
            long traceIdHigh = 0L;
            long traceId = 0L;
            Long parent = null;
            StringBuilder currentString = new StringBuilder(7);
            StringBuilder extraFields = null;
            Enum op = null;
            int length = traceIdString.length();
            block7: for (int i = 0; i < length; ++i) {
                char c = traceIdString.charAt(i);
                if (c == ' ') continue;
                if (c == '=') {
                    if (++i == length) break;
                    if (currentString.indexOf("Root") == 0) {
                        op = Op.ROOT;
                    } else if (currentString.indexOf("Parent") == 0) {
                        op = Op.PARENT;
                    } else if (currentString.indexOf("Sampled") == 0) {
                        op = Op.SAMPLED;
                    } else if (currentString.indexOf("Self") == 0) {
                        op = Op.SKIP;
                    } else {
                        op = Op.EXTRA;
                        if (extraFields == null) {
                            extraFields = new StringBuilder();
                        }
                        extraFields.append(';').append((CharSequence)currentString);
                    }
                    currentString.setLength(0);
                } else if (op == null) {
                    currentString.append(c);
                    continue;
                }
                switch (3.$SwitchMap$brave$propagation$aws$AWSPropagation$AWSExtractor$Op[op.ordinal()]) {
                    case 1: {
                        extraFields.append(c);
                        while (i < length && (c = traceIdString.charAt(i)) != ';') {
                            extraFields.append(c);
                            ++i;
                        }
                        break;
                    }
                    case 2: {
                        while (++i < length && traceIdString.charAt(i) != ';') {
                        }
                        break;
                    }
                    case 3: {
                        if (i + 35 > length || traceIdString.charAt(i++) != '1' || traceIdString.charAt(i++) != '-') break block7;
                        int hyphenIndex = i + 8;
                        int endIndex = hyphenIndex + 1 + 8;
                        while (i < endIndex) {
                            c = traceIdString.charAt(i);
                            if (c != '-' || i != hyphenIndex) {
                                traceIdHigh <<= 4;
                                if (c >= '0' && c <= '9') {
                                    traceIdHigh |= (long)(c - 48);
                                } else {
                                    if (c < 'a' || c > 'f') break block7;
                                    traceIdHigh |= (long)(c - 97 + 10);
                                }
                            }
                            ++i;
                        }
                        int endIndex2 = i + 16;
                        while (i < endIndex2) {
                            c = traceIdString.charAt(i);
                            traceId <<= 4;
                            if (c >= '0' && c <= '9') {
                                traceId |= (long)(c - 48);
                            } else {
                                if (c < 'a' || c > 'f') break block7;
                                traceId |= (long)(c - 97 + 10);
                            }
                            ++i;
                        }
                        break;
                    }
                    case 4: {
                        long parentId = 0L;
                        int endIndex = i + 16;
                        while (i < endIndex) {
                            c = traceIdString.charAt(i);
                            parentId <<= 4;
                            if (c >= '0' && c <= '9') {
                                parentId |= (long)(c - 48);
                            } else {
                                if (c < 'a' || c > 'f') break block7;
                                parentId |= (long)(c - 97 + 10);
                            }
                            ++i;
                        }
                        parent = parentId;
                        break;
                    }
                    case 5: {
                        c = traceIdString.charAt(i++);
                        if (c == '1') {
                            sampled = true;
                            break;
                        }
                        if (c != '0') break;
                        sampled = false;
                    }
                }
                op = null;
            }
            if (extraFields == null) {
                extra = DEFAULT_EXTRA;
            } else {
                Extra e = new Extra();
                e.fields = extraFields;
                extra = Collections.singletonList(e);
            }
            if (traceIdHigh == 0L) {
                return TraceContextOrSamplingFlags.newBuilder().extra(extra).samplingFlags(SamplingFlags.Builder.build(sampled)).build();
            }
            if (parent == null) {
                return TraceContextOrSamplingFlags.newBuilder().extra(extra).traceIdContext(TraceIdContext.newBuilder().traceIdHigh(traceIdHigh).traceId(traceId).sampled(sampled).build()).build();
            }
            return TraceContextOrSamplingFlags.create((TraceContext)TraceContext.newBuilder().traceIdHigh(traceIdHigh).traceId(traceId).spanId(parent.longValue()).sampled(sampled).extra(extra).build());
        }

        static enum Op {
            SKIP,
            ROOT,
            PARENT,
            SAMPLED,
            EXTRA;

        }
    }

    static final class AWSInjector<C, K>
    implements TraceContext.Injector<C> {
        final AWSPropagation<K> propagation;
        final Propagation.Setter<C, K> setter;

        AWSInjector(AWSPropagation<K> propagation, Propagation.Setter<C, K> setter) {
            this.propagation = propagation;
            this.setter = setter;
        }

        public void inject(TraceContext traceContext, C carrier) {
            CharSequence extra = null;
            int length = traceContext.extra().size();
            for (int i = 0; i < length; ++i) {
                Object next = traceContext.extra().get(i);
                if (!(next instanceof Extra)) continue;
                extra = ((Extra)next).fields;
                break;
            }
            int extraLength = extra == null ? 0 : extra.length();
            char[] result = new char[74 + extraLength];
            System.arraycopy(ROOT, 0, result, 0, 5);
            AWSPropagation.writeRoot(traceContext, result, 5);
            System.arraycopy(PARENT, 0, result, 40, 8);
            HexCodec.writeHexLong((char[])result, (int)48, (long)traceContext.spanId());
            System.arraycopy(SAMPLED, 0, result, 64, 9);
            Boolean sampled = traceContext.sampled();
            result[73] = sampled == null ? 63 : (sampled != false ? 49 : 48);
            for (int i = 0; i < extraLength; ++i) {
                result[i + 74] = extra.charAt(i);
            }
            this.setter.put(carrier, this.propagation.traceIdKey, new String(result));
        }
    }
}

