/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.aws;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSource;
import zipkin2.elasticsearch.ElasticsearchStorage;
import zipkin2.elasticsearch.internal.JsonReaders;

final class ElasticsearchDomainEndpoint
implements ElasticsearchStorage.HostsSupplier {
    static final Logger log = Logger.getLogger(ElasticsearchDomainEndpoint.class.getName());
    final OkHttpClient client;
    final Request describeElasticsearchDomain;

    ElasticsearchDomainEndpoint(OkHttpClient client, HttpUrl baseUrl, String domain) {
        if (client == null) {
            throw new NullPointerException("client == null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl == null");
        }
        if (domain == null) {
            throw new NullPointerException("domain == null");
        }
        this.client = client;
        this.describeElasticsearchDomain = new Request.Builder().url(baseUrl.newBuilder("2015-01-01/es/domain").addPathSegment(domain).build()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> get() {
        try (Response response = this.client.newCall(this.describeElasticsearchDomain).execute();){
            String body = response.body().string();
            if (!response.isSuccessful()) {
                String message = this.describeElasticsearchDomain.url().encodedPath() + " failed with status " + response.code();
                if (body.isEmpty()) throw new IllegalStateException(message);
                message = message + ": " + body;
                throw new IllegalStateException(message);
            }
            JsonReader endpointReader = JsonReaders.enterPath((JsonReader)JsonReader.of((BufferedSource)new Buffer().writeUtf8(body)), (String)"DomainStatus", (String)"Endpoint");
            if (endpointReader == null) {
                throw new IllegalStateException("DomainStatus.Endpoint wasn't present in response: " + body);
            }
            String endpoint = endpointReader.nextString();
            if (!endpoint.startsWith("https://")) {
                endpoint = "https://" + endpoint;
            }
            log.fine("using endpoint " + endpoint);
            List<String> list = Collections.singletonList(endpoint);
            return list;
        }
        catch (IOException e) {
            throw new IllegalStateException("couldn't lookup domain endpoint", e);
        }
    }
}

