/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.aws;

import com.squareup.moshi.JsonReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;
import zipkin.autoconfigure.storage.elasticsearch.aws.AWSCredentials;
import zipkin2.elasticsearch.internal.JsonReaders;

final class AWSSignatureVersion4
implements Interceptor {
    static final String EMPTY_STRING_HASH = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    static final String HOST = "host";
    static final String X_AMZ_DATE = "x-amz-date";
    static final String X_AMZ_SECURITY_TOKEN = "x-amz-security-token";
    static final String[] CANONICAL_HEADERS = new String[]{"host", "x-amz-date", "x-amz-security-token"};
    static final String HOST_DATE = "host;x-amz-date";
    static final String HOST_DATE_TOKEN = "host;x-amz-date;x-amz-security-token";
    static final ThreadLocal<SimpleDateFormat> iso8601 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat result = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            result.setTimeZone(TimeZone.getTimeZone("UTC"));
            return result;
        }
    };
    final String region;
    final String service;
    final AWSCredentials.Provider credentials;

    AWSSignatureVersion4(String region, String service, AWSCredentials.Provider credentials) {
        if (region == null) {
            throw new NullPointerException("region == null");
        }
        if (service == null) {
            throw new NullPointerException("service == null");
        }
        if (credentials == null) {
            throw new NullPointerException("credentials == null");
        }
        this.region = region;
        this.service = service;
        this.credentials = credentials;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request input = chain.request();
        Request signed = this.sign(input);
        Response response = chain.proceed(signed);
        if (response.code() == 403) {
            try (ResponseBody body = response.body();){
                JsonReader message = JsonReaders.enterPath((JsonReader)JsonReader.of((BufferedSource)body.source()), (String)"message");
                if (message != null) {
                    throw new IllegalStateException(message.nextString());
                }
            }
            throw new IllegalStateException(response.toString());
        }
        return response;
    }

    static Buffer canonicalString(Request input) throws IOException {
        Buffer result = new Buffer();
        result.writeUtf8(input.method()).writeByte(10);
        result.writeUtf8(input.url().encodedPath().replace("*", "%2A").replace(",", "%2C").replace(":", "%3A")).writeByte(10);
        String query = input.url().encodedQuery();
        result.writeUtf8(query == null ? "" : query).writeByte(10);
        Buffer signedHeaders = new Buffer();
        for (String canonicalHeader : CANONICAL_HEADERS) {
            String value = input.header(canonicalHeader);
            if (value == null) continue;
            result.writeUtf8(canonicalHeader).writeByte(58).writeUtf8(value).writeByte(10);
            signedHeaders.writeByte(59).writeUtf8(canonicalHeader);
        }
        result.writeByte(10);
        signedHeaders.readByte();
        result.writeAll((Source)signedHeaders);
        result.writeByte(10);
        if (input.body() != null && input.body().contentLength() != 0L) {
            Buffer body = new Buffer();
            input.body().writeTo((BufferedSink)body);
            result.writeUtf8(body.sha256().hex());
        } else {
            result.writeUtf8(EMPTY_STRING_HASH);
        }
        return result;
    }

    static Buffer toSign(String timestamp, String credentialScope, Buffer canonicalRequest) {
        Buffer result = new Buffer();
        result.writeUtf8("AWS4-HMAC-SHA256\n");
        result.writeUtf8(timestamp).writeByte(10);
        result.writeUtf8(credentialScope).writeByte(10);
        result.writeUtf8(canonicalRequest.sha256().hex());
        return result;
    }

    Request sign(Request input) throws IOException {
        AWSCredentials credentials = this.credentials.get();
        if (credentials == null) {
            throw new NullPointerException("credentials == null");
        }
        String timestamp = iso8601.get().format(new Date());
        String yyyyMMdd = timestamp.substring(0, 8);
        String credentialScope = String.format("%s/%s/%s/%s", yyyyMMdd, this.region, this.service, "aws4_request");
        Request.Builder builder = input.newBuilder();
        builder.header(HOST, input.url().host());
        builder.header(X_AMZ_DATE, timestamp);
        if (credentials.sessionToken != null) {
            builder.header(X_AMZ_SECURITY_TOKEN, credentials.sessionToken);
        }
        Buffer canonicalString = AWSSignatureVersion4.canonicalString(builder.build());
        String signedHeaders = credentials.sessionToken == null ? HOST_DATE : HOST_DATE_TOKEN;
        Buffer toSign = AWSSignatureVersion4.toSign(timestamp, credentialScope, canonicalString);
        ByteString signatureKey = this.signatureKey(credentials.secretKey, yyyyMMdd);
        String signature = toSign.readByteString().hmacSha256(signatureKey).hex();
        String authorization = "AWS4-HMAC-SHA256 Credential=" + credentials.accessKey + '/' + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
        return builder.header("authorization", authorization).build();
    }

    ByteString signatureKey(String secretKey, String yyyyMMdd) {
        ByteString kSecret = ByteString.encodeUtf8((String)("AWS4" + secretKey));
        ByteString kDate = ByteString.encodeUtf8((String)yyyyMMdd).hmacSha256(kSecret);
        ByteString kRegion = ByteString.encodeUtf8((String)this.region).hmacSha256(kDate);
        ByteString kService = ByteString.encodeUtf8((String)this.service).hmacSha256(kRegion);
        ByteString kSigning = ByteString.encodeUtf8((String)"aws4_request").hmacSha256(kService);
        return kSigning;
    }
}

