/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.aws;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.autoconfigure.storage.elasticsearch.aws.AWSCredentials;
import zipkin.autoconfigure.storage.elasticsearch.aws.AWSSignatureVersion4;
import zipkin.autoconfigure.storage.elasticsearch.aws.ElasticsearchDomainEndpoint;
import zipkin.autoconfigure.storage.elasticsearch.aws.ZipkinElasticsearchAwsStorageProperties;
import zipkin2.elasticsearch.ElasticsearchStorage;

@Configuration
@EnableConfigurationProperties(value={ZipkinElasticsearchAwsStorageProperties.class})
@Conditional(value={AwsMagic.class})
class ZipkinElasticsearchAwsStorageAutoConfiguration {
    static final Pattern AWS_URL = Pattern.compile("^https://[^.]+\\.([^.]+)\\.es\\.amazonaws\\.com", 2);
    static final Logger log = Logger.getLogger(ZipkinElasticsearchAwsStorageAutoConfiguration.class.getName());

    ZipkinElasticsearchAwsStorageAutoConfiguration() {
    }

    @Bean
    @Qualifier(value="zipkinElasticsearchHttp")
    Interceptor awsSignatureVersion4(String region, ZipkinElasticsearchAwsStorageProperties aws, AWSCredentials.Provider credentials) {
        return new AWSSignatureVersion4(region, "es", credentials);
    }

    @Bean
    String region(@Value(value="${zipkin.storage.elasticsearch.hosts:}") String hosts, ZipkinElasticsearchAwsStorageProperties aws) {
        if ("".equals(hosts)) {
            hosts = null;
        }
        String domain = aws.getDomain();
        if (hosts != null && domain != null) {
            log.warning(String.format("Expected exactly one of hosts or domain: instead saw hosts '%s' and domain '%s'. Ignoring hosts and proceeding to look for domain. Either unset ES_HOSTS or ES_AWS_DOMAIN to suppress this message.", hosts, domain));
        }
        if (aws.getRegion() != null) {
            return aws.getRegion();
        }
        if (domain != null) {
            return new DefaultAwsRegionProviderChain().getRegion();
        }
        String awsRegion = ZipkinElasticsearchAwsStorageAutoConfiguration.regionFromAwsUrls(hosts);
        if (awsRegion == null) {
            throw new IllegalArgumentException("Couldn't find region in " + hosts);
        }
        return awsRegion;
    }

    @Bean
    @ConditionalOnMissingBean
    AWSCredentials.Provider credentials() {
        return new AWSCredentials.Provider(){
            AWSCredentialsProvider delegate = new DefaultAWSCredentialsProviderChain();

            @Override
            public AWSCredentials get() {
                com.amazonaws.auth.AWSCredentials result = this.delegate.getCredentials();
                String sessionToken = result instanceof AWSSessionCredentials ? ((AWSSessionCredentials)result).getSessionToken() : null;
                return new AWSCredentials(result.getAWSAccessKeyId(), result.getAWSSecretKey(), sessionToken);
            }
        };
    }

    @Bean
    @Conditional(value={AwsDomainSetCondition.class})
    ElasticsearchStorage.HostsSupplier hostsSupplier(String region, ZipkinElasticsearchAwsStorageProperties aws, OkHttpClient client) {
        return new ElasticsearchDomainEndpoint(client, HttpUrl.parse((String)("https://es." + region + ".amazonaws.com")), aws.getDomain());
    }

    static String regionFromAwsUrls(String hosts) {
        String awsRegion = null;
        for (String url : hosts.split(",", 100)) {
            Matcher matcher = AWS_URL.matcher(url);
            if (matcher.find()) {
                String matched = matcher.group(1);
                if (awsRegion != null) {
                    throw new IllegalArgumentException("too many regions: saw '" + awsRegion + "' and '" + matched + "'");
                }
                awsRegion = matcher.group(1);
                continue;
            }
            if (awsRegion == null) continue;
            throw new IllegalArgumentException("mismatched regions; saw '" + awsRegion + "' but none found in '" + url + "'");
        }
        return awsRegion;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static final class AwsMagic
    implements Condition {
        AwsMagic() {
        }

        public boolean matches(ConditionContext condition, AnnotatedTypeMetadata md) {
            Environment environment = condition.getEnvironment();
            String hosts = environment.getProperty("zipkin.storage.elasticsearch.hosts");
            String domain = environment.getProperty("zipkin.storage.elasticsearch.aws.domain");
            if (ZipkinElasticsearchAwsStorageAutoConfiguration.isEmpty(hosts) && ZipkinElasticsearchAwsStorageAutoConfiguration.isEmpty(domain)) {
                return false;
            }
            return !ZipkinElasticsearchAwsStorageAutoConfiguration.isEmpty(domain) || ZipkinElasticsearchAwsStorageAutoConfiguration.regionFromAwsUrls(hosts) != null;
        }
    }

    static final class AwsDomainSetCondition
    extends SpringBootCondition {
        static final String PROPERTY_NAME = "zipkin.storage.elasticsearch.aws.domain";

        AwsDomainSetCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata a) {
            String domain = context.getEnvironment().getProperty(PROPERTY_NAME);
            return domain == null || domain.isEmpty() ? ConditionOutcome.noMatch((String)"zipkin.storage.elasticsearch.aws.domain isn't set") : ConditionOutcome.match();
        }
    }
}

