/*
 * Decompiled with CFR 0.152.
 */
package zipkin.autoconfigure.storage.elasticsearch.aws;

import com.fasterxml.jackson.databind.JsonNode;
import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroup;
import com.linecorp.armeria.client.endpoint.dns.DnsAddressEndpointGroupBuilder;
import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.HttpStatusClass;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import zipkin.autoconfigure.storage.elasticsearch.aws.ZipkinElasticsearchAwsStorageAutoConfiguration;

final class ElasticsearchDomainEndpoint
implements Supplier<EndpointGroup> {
    static final AttributeKey<String> NAME = AttributeKey.valueOf((String)"name");
    final Function<Endpoint, HttpClient> clientFactory;
    final Endpoint endpoint;
    final String region;
    final String domain;

    ElasticsearchDomainEndpoint(Function<Endpoint, HttpClient> clientFactory, Endpoint endpoint, String region, String domain) {
        this.clientFactory = clientFactory;
        this.endpoint = endpoint;
        this.region = region;
        this.domain = domain;
    }

    @Override
    public DnsAddressEndpointGroup get() {
        String endpoint;
        String body;
        HttpStatus status;
        AggregatedHttpRequest req = AggregatedHttpRequest.of((HttpMethod)HttpMethod.GET, (String)("/2015-01-01/es/domain/" + this.domain));
        try (SafeCloseable sc = Clients.withContextCustomizer(ctx -> ctx.attr(NAME).set((Object)"es-get-domain"));){
            AggregatedHttpResponse res = (AggregatedHttpResponse)this.clientFactory.apply(this.endpoint).execute(req).aggregate().join();
            status = res.status();
            body = res.contentUtf8();
        }
        catch (Error | RuntimeException e) {
            Throwable cause;
            String message = "couldn't lookup AWS ES domain endpoint";
            Throwable throwable = cause = e instanceof CompletionException ? e.getCause() : e;
            if (cause.getMessage() != null) {
                message = message + ": " + cause.getMessage();
            }
            throw new RuntimeException(message, cause);
        }
        if (!status.codeClass().equals((Object)HttpStatusClass.SUCCESS)) {
            String message = req.path() + " failed with status " + status;
            if (!body.isEmpty()) {
                message = message + ": " + body;
            }
            throw new RuntimeException(message);
        }
        try {
            JsonNode root = ZipkinElasticsearchAwsStorageAutoConfiguration.JSON.readTree(body);
            endpoint = root.at("/DomainStatus/Endpoints/vpc").textValue();
            if (endpoint == null) {
                endpoint = root.at("/DomainStatus/Endpoint").textValue();
            }
        }
        catch (IOException e) {
            throw new AssertionError("Unexpected to have IOException reading a string", e);
        }
        if (endpoint == null) {
            throw new RuntimeException("Neither DomainStatus.Endpoints.vpc nor DomainStatus.Endpoint were present in response: " + body);
        }
        DnsAddressEndpointGroup result = new DnsAddressEndpointGroupBuilder(endpoint).port(443).build();
        try {
            result.awaitInitialEndpoints(1L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String toString() {
        return "aws://" + this.region + "/" + this.domain;
    }
}

