/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.junit.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSClientBuilder;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.util.Base64;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticmq.Limits;
import org.elasticmq.StrictSQSLimits$;
import org.elasticmq.rest.sqs.SQSRestServer;
import org.elasticmq.rest.sqs.SQSRestServerBuilder;
import org.junit.rules.ExternalResource;
import zipkin2.Span;
import zipkin2.codec.SpanBytesDecoder;

public class AmazonSQSRule
extends ExternalResource {
    SQSRestServer server;
    int serverPort;
    AmazonSQS client;
    String queueUrl;

    public AmazonSQSRule start() {
        if (this.server == null) {
            this.server = SQSRestServerBuilder.withDynamicPort().withSQSLimits((Limits)StrictSQSLimits$.MODULE$).start();
            this.serverPort = this.server.waitUntilStarted().localAddress().getPort();
        }
        if (this.client == null) {
            this.client = (AmazonSQS)((AmazonSQSClientBuilder)((AmazonSQSClientBuilder)AmazonSQSClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials("x", "x")))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(String.format("http://localhost:%d", this.serverPort), null))).build();
            this.queueUrl = this.client.createQueue("zipkin").getQueueUrl();
        }
        return this;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    protected void before() {
        if (this.client != null && this.queueUrl != null) {
            this.client.purgeQueue(new PurgeQueueRequest(this.queueUrl));
        }
    }

    protected void after() {
        if (this.server != null) {
            this.server.stopAndWait();
        }
    }

    public int queueCount() {
        String count = (String)this.client.getQueueAttributes(this.queueUrl, Collections.singletonList("ApproximateNumberOfMessages")).getAttributes().get("ApproximateNumberOfMessages");
        return Integer.parseInt(count);
    }

    public int notVisibleCount() {
        String count = (String)this.client.getQueueAttributes(this.queueUrl, Collections.singletonList("ApproximateNumberOfMessagesNotVisible")).getAttributes().get("ApproximateNumberOfMessagesNotVisible");
        return Integer.parseInt(count);
    }

    public List<Span> getSpans() {
        return this.getSpans(false);
    }

    public List<Span> getSpans(boolean delete) {
        Stream spans = Stream.empty();
        ReceiveMessageResult result = this.client.receiveMessage(this.queueUrl);
        while (result != null && result.getMessages().size() > 0) {
            spans = Stream.concat(spans, result.getMessages().stream().flatMap(AmazonSQSRule::decodeSpans));
            result = this.client.receiveMessage(this.queueUrl);
            if (!delete) continue;
            List<DeleteMessageRequest> deletes = result.getMessages().stream().map(m -> new DeleteMessageRequest(this.queueUrl, m.getReceiptHandle())).collect(Collectors.toList());
            deletes.forEach(d -> this.client.deleteMessage(d));
        }
        return spans.collect(Collectors.toList());
    }

    public void send(String body) {
        this.client.sendMessage(new SendMessageRequest(this.queueUrl, body));
    }

    static Stream<? extends Span> decodeSpans(Message m) {
        byte[] bytes;
        byte[] byArray = bytes = m.getBody().charAt(0) == '[' ? m.getBody().getBytes(StandardCharsets.UTF_8) : Base64.decode((String)m.getBody());
        if (bytes[0] == 91) {
            return SpanBytesDecoder.JSON_V2.decodeList(bytes).stream();
        }
        return SpanBytesDecoder.PROTO3.decodeList(bytes).stream();
    }
}

