/*
 * Decompiled with CFR 0.152.
 */
package zipkin.junit.aws;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.util.Base64;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticmq.rest.sqs.SQSLimits;
import org.elasticmq.rest.sqs.SQSRestServer;
import org.elasticmq.rest.sqs.SQSRestServerBuilder;
import org.junit.rules.ExternalResource;
import zipkin.junit.aws.AmazonSQSRule$$Lambda$1;
import zipkin.junit.aws.AmazonSQSRule$$Lambda$4;
import zipkin.junit.aws.AmazonSQSRule$$Lambda$5;
import zipkin2.Span;
import zipkin2.codec.SpanBytesDecoder;

public class AmazonSQSRule
extends ExternalResource {
    private SQSRestServer server;
    private AmazonSQSClient client;
    private String queueUrl;

    public AmazonSQSRule start(int httpPort) {
        if (this.server == null) {
            this.server = SQSRestServerBuilder.withPort((int)httpPort).withSQSLimits(SQSLimits.Strict()).start();
            this.server.waitUntilStarted();
        }
        if (this.client == null) {
            this.client = new AmazonSQSClient((AWSCredentials)new BasicAWSCredentials("x", "x"));
            this.client.setEndpoint(String.format("http://localhost:%d", httpPort));
            this.queueUrl = this.client.createQueue("zipkin").getQueueUrl();
        }
        return this;
    }

    public String queueUrl() {
        return this.queueUrl;
    }

    protected void before() {
        if (this.client != null && this.queueUrl != null) {
            this.client.purgeQueue(new PurgeQueueRequest(this.queueUrl));
        }
    }

    protected void after() {
        if (this.server != null) {
            this.server.stopAndWait();
        }
    }

    public int queueCount() {
        String count = (String)this.client.getQueueAttributes(this.queueUrl, Collections.singletonList("ApproximateNumberOfMessages")).getAttributes().get("ApproximateNumberOfMessages");
        return Integer.valueOf(count);
    }

    public List<Span> getSpans() {
        return this.getSpans(false);
    }

    public List<Span> getSpans(boolean delete) {
        Stream spans = Stream.empty();
        ReceiveMessageResult result = this.client.receiveMessage(this.queueUrl);
        while (result != null && result.getMessages().size() > 0) {
            spans = Stream.concat(spans, result.getMessages().stream().flatMap(AmazonSQSRule$$Lambda$1.lambdaFactory$()));
            result = this.client.receiveMessage(this.queueUrl);
            if (!delete) continue;
            List deletes = result.getMessages().stream().map(AmazonSQSRule$$Lambda$4.lambdaFactory$(this)).collect(Collectors.toList());
            deletes.forEach(AmazonSQSRule$$Lambda$5.lambdaFactory$(this));
        }
        return spans.collect(Collectors.toList());
    }

    public void send(String body) {
        this.client.sendMessage(new SendMessageRequest(this.queueUrl, body));
    }

    static Stream<? extends Span> decodeSpans(Message m) {
        byte[] bytes = m.getBody().charAt(0) == '[' ? m.getBody().getBytes(Charset.forName("UTF-8")) : Base64.decode((String)m.getBody());
        return SpanBytesDecoder.JSON_V2.decodeList(bytes).stream();
    }

    static /* synthetic */ void lambda$getSpans$1(AmazonSQSRule this_, DeleteMessageRequest d) {
        this_.client.deleteMessage(d);
    }

    static /* synthetic */ DeleteMessageRequest lambda$getSpans$0(AmazonSQSRule this_, Message m) {
        return new DeleteMessageRequest(this_.queueUrl, m.getReceiptHandle());
    }
}

