/*
 * Decompiled with CFR 0.152.
 */
package zipkin.sparkstreaming.autoconfigure.stream.kinesis;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import zipkin.sparkstreaming.StreamFactory;
import zipkin.sparkstreaming.autoconfigure.stream.kinesis.ZipkinKinesisStreamFactoryProperties;

@Configuration
@EnableConfigurationProperties(value={ZipkinKinesisStreamFactoryProperties.class})
@Conditional(value={KinesisStreamConfigurationCondition.class})
public class ZipkinKinesisStreamFactoryAutoConfiguration {
    @Bean
    StreamFactory kinesisStream(ZipkinKinesisStreamFactoryProperties properties) {
        return properties.toBuilder().build();
    }

    static final class KinesisStreamConfigurationCondition
    extends SpringBootCondition {
        static final String REGION = "zipkin.sparkstreaming.stream.kinesis.region";

        KinesisStreamConfigurationCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata a) {
            String region = context.getEnvironment().getProperty(REGION);
            return region != null ? ConditionOutcome.match() : ConditionOutcome.noMatch((String)"region for kinesis stream not set");
        }
    }
}

