/*
 * Decompiled with CFR 0.152.
 */
package zipkin.sparkstreaming.autoconfigure.stream.kinesis;

import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin.sparkstreaming.stream.kinesis.KinesisStreamFactory;

@ConfigurationProperties(value="zipkin.sparkstreaming.stream.kinesis")
public class ZipkinKinesisStreamFactoryProperties {
    public static final String PROPERTIES_ROOT = "zipkin.sparkstreaming.stream.kinesis";
    private String kinesisStream;
    private String app;
    private String region;
    private String kinesisEndpoint;
    private int checkpointIntervalMillis = 0;
    private String awsAccessKeyId;
    private String awsSecretKey;

    public String getKinesisStream() {
        return this.kinesisStream;
    }

    public void setKinesisStream(String kinesisStream) {
        this.kinesisStream = kinesisStream;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getKinesisEndpoint() {
        return this.kinesisEndpoint;
    }

    public void setKinesisEndpoint(String kinesisEndpoint) {
        this.kinesisEndpoint = kinesisEndpoint;
    }

    public int getCheckpointIntervalMillis() {
        return this.checkpointIntervalMillis;
    }

    public void setCheckpointIntervalMillis(int checkpointIntervalMillis) {
        this.checkpointIntervalMillis = checkpointIntervalMillis;
    }

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    KinesisStreamFactory.Builder toBuilder() {
        KinesisStreamFactory.Builder builder = KinesisStreamFactory.newBuilder().awsRegion(this.region);
        if (this.kinesisStream != null) {
            builder.stream(this.kinesisStream);
        }
        if (this.app != null) {
            builder.app(this.app);
        }
        if (this.kinesisEndpoint != null) {
            builder.awsEndpoint(this.kinesisEndpoint);
        }
        if (this.checkpointIntervalMillis > 0) {
            builder.checkpointIntervalMillis(this.checkpointIntervalMillis);
        }
        if (this.awsAccessKeyId != null && this.awsSecretKey != null) {
            builder.credentials(this.awsAccessKeyId, this.awsSecretKey);
        }
        return builder;
    }
}

