/*
 * Decompiled with CFR 0.152.
 */
package zipkin.sparkstreaming.stream.kinesis;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.kinesis.KinesisUtils;
import zipkin.sparkstreaming.StreamFactory;

public class KinesisStreamFactory
implements StreamFactory {
    private final String stream;
    private final String app;
    private final String regionName;
    private final String endpoint;
    private final Duration checkpointInterval;
    private final InitialPositionInStream initialPositionInStream;
    private final StorageLevel storageLevel;
    private String awsAccessKeyId;
    private String awsSecretKey;

    public static Builder newBuilder() {
        return new Builder().checkpointIntervalMillis(2000).initialPositionInStream(InitialPositionInStream.TRIM_HORIZON).storageLevel(StorageLevel.MEMORY_AND_DISK_2());
    }

    KinesisStreamFactory(Builder builder) {
        this.stream = builder.stream;
        this.app = builder.app;
        this.regionName = builder.awsRegion;
        this.endpoint = builder.awsEndpoint != null ? builder.awsEndpoint : Region.getRegion((Regions)Regions.fromName((String)this.regionName)).getServiceEndpoint("kinesis");
        this.checkpointInterval = builder.checkpointInterval;
        this.initialPositionInStream = builder.initialPositionInStream;
        this.storageLevel = builder.storageLevel;
        this.awsAccessKeyId = builder.awsAccessKeyId;
        this.awsSecretKey = builder.awsSecretKey;
    }

    public JavaDStream<byte[]> create(JavaStreamingContext jsc) {
        if (this.awsAccessKeyId != null) {
            return KinesisUtils.createStream((JavaStreamingContext)jsc, (String)this.stream, (String)this.app, (String)this.endpoint, (String)this.regionName, (InitialPositionInStream)this.initialPositionInStream, (Duration)this.checkpointInterval, (StorageLevel)this.storageLevel, (String)this.awsAccessKeyId, (String)this.awsSecretKey);
        }
        return KinesisUtils.createStream((JavaStreamingContext)jsc, (String)this.stream, (String)this.app, (String)this.endpoint, (String)this.regionName, (InitialPositionInStream)this.initialPositionInStream, (Duration)this.checkpointInterval, (StorageLevel)this.storageLevel);
    }

    public static final class Builder {
        String stream = "zipkin";
        String app = "zipkin-sparkstreaming";
        String awsRegion;
        String awsEndpoint;
        Duration checkpointInterval;
        InitialPositionInStream initialPositionInStream;
        StorageLevel storageLevel;
        String awsAccessKeyId;
        String awsSecretKey;

        public Builder stream(String stream) {
            this.stream = stream;
            return this;
        }

        public Builder app(String app) {
            this.app = app;
            return this;
        }

        public Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public Builder awsEndpoint(String awsEndpoint) {
            this.awsEndpoint = awsEndpoint;
            return this;
        }

        public Builder checkpointInterval(Duration checkpointInterval) {
            this.checkpointInterval = checkpointInterval;
            return this;
        }

        public Builder checkpointIntervalMillis(int checkpointIntervalMillis) {
            this.checkpointInterval = new Duration((long)checkpointIntervalMillis);
            return this;
        }

        public Builder initialPositionInStream(InitialPositionInStream initialPositionInStream) {
            this.initialPositionInStream = initialPositionInStream;
            return this;
        }

        public Builder storageLevel(StorageLevel storageLevel) {
            this.storageLevel = storageLevel;
            return this;
        }

        public Builder credentials(String awsAccessKeyId, String awsSecretKey) {
            if (awsAccessKeyId == null) {
                throw new NullPointerException("awsAccessKeyId == null");
            }
            if (awsSecretKey == null) {
                throw new NullPointerException("awsSecretKey == null");
            }
            this.awsAccessKeyId = awsAccessKeyId;
            this.awsSecretKey = awsSecretKey;
            return this;
        }

        public KinesisStreamFactory build() {
            return new KinesisStreamFactory(this);
        }
    }
}

