/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.module.storage.kafka;

import com.linecorp.armeria.spring.ArmeriaServerConfigurator;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import zipkin2.module.storage.kafka.ZipkinKafkaStorageProperties;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.kafka.KafkaStorage;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ZipkinKafkaStorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="kafka")
@ConditionalOnMissingBean(value={StorageComponent.class})
class ZipkinKafkaStorageModule {
    ZipkinKafkaStorageModule() {
    }

    @ConditionalOnMissingBean
    @Bean
    StorageComponent storage(@Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys, @Value(value="${server.port:9411}") int port, ZipkinKafkaStorageProperties properties) {
        return properties.toBuilder().searchEnabled(searchEnabled).autocompleteKeys(autocompleteKeys).serverPort(port).build();
    }

    @Bean
    public ArmeriaServerConfigurator storageHttpService(StorageComponent storage) {
        return sb -> sb.annotatedService("/storage/kafka", (Object)((KafkaStorage)storage).httpService());
    }
}

