/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.module.storage.kafka;

import java.io.Serializable;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import zipkin2.storage.kafka.KafkaStorage;
import zipkin2.storage.kafka.KafkaStorageBuilder;

@ConfigurationProperties(value="zipkin.storage.kafka")
public class ZipkinKafkaStorageProperties
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String hostname;
    private String storageDir;
    private String bootstrapServers;
    private Map<String, String> overrides = new LinkedHashMap<String, String>();
    private SpanPartitioningProperties spanPartitioning = new SpanPartitioningProperties();
    private SpanAggregationProperties spanAggregation = new SpanAggregationProperties();
    private TraceStorageProperties traceStorage = new TraceStorageProperties();
    private DependencyStorageProperties dependencyStorage = new DependencyStorageProperties();

    KafkaStorageBuilder toBuilder() {
        KafkaStorageBuilder builder = KafkaStorage.newBuilder();
        builder.spanPartitioningBuilder(this.spanPartitioning.toBuilder());
        builder.spanAggregationBuilder(this.spanAggregation.toBuilder());
        builder.traceStorageBuilder(this.traceStorage.toBuilder());
        builder.dependencyStorageBuilder(this.dependencyStorage.toBuilder());
        if (this.hostname != null) {
            builder.hostname(this.hostname);
        }
        if (this.storageDir != null) {
            builder.storageStateDir(this.storageDir);
        }
        if (this.bootstrapServers != null) {
            builder.bootstrapServers(this.bootstrapServers);
        }
        if (this.overrides != null) {
            builder.overrides(this.overrides);
        }
        return builder;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public String getStorageDir() {
        return this.storageDir;
    }

    public void setStorageDir(String storageDir) {
        this.storageDir = storageDir;
    }

    public Map<String, String> getOverrides() {
        return this.overrides;
    }

    public void setOverrides(Map<String, String> overrides) {
        this.overrides = overrides;
    }

    public SpanPartitioningProperties getSpanPartitioning() {
        return this.spanPartitioning;
    }

    public void setSpanPartitioning(SpanPartitioningProperties spanPartitioning) {
        this.spanPartitioning = spanPartitioning;
    }

    public SpanAggregationProperties getSpanAggregation() {
        return this.spanAggregation;
    }

    public void setSpanAggregation(SpanAggregationProperties spanAggregation) {
        this.spanAggregation = spanAggregation;
    }

    public TraceStorageProperties getTraceStorage() {
        return this.traceStorage;
    }

    public void setTraceStorage(TraceStorageProperties traceStorage) {
        this.traceStorage = traceStorage;
    }

    public DependencyStorageProperties getDependencyStorage() {
        return this.dependencyStorage;
    }

    public void setDependencyStorage(DependencyStorageProperties dependencyStorage) {
        this.dependencyStorage = dependencyStorage;
    }

    static class DependencyStorageProperties {
        private Boolean enabled;
        private String dependencyTopic;
        private Long ttl;
        private Map<String, String> overrides = new LinkedHashMap<String, String>();

        DependencyStorageProperties() {
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getDependencyTopic() {
            return this.dependencyTopic;
        }

        public void setDependencyTopic(String dependencyTopic) {
            this.dependencyTopic = dependencyTopic;
        }

        public Long getTtl() {
            return this.ttl;
        }

        public void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public Map<String, String> getOverrides() {
            return this.overrides;
        }

        public void setOverrides(Map<String, String> overrides) {
            this.overrides = overrides;
        }

        KafkaStorageBuilder.DependencyStorageBuilder toBuilder() {
            KafkaStorageBuilder.DependencyStorageBuilder builder = new KafkaStorageBuilder.DependencyStorageBuilder();
            if (this.enabled != null) {
                builder.enabled(this.enabled.booleanValue());
            }
            if (this.dependencyTopic != null) {
                builder.dependencyTopic(this.dependencyTopic);
            }
            if (this.ttl != null) {
                builder.ttl(Duration.ofMillis(this.ttl));
            }
            if (this.overrides != null) {
                builder.overrides(this.overrides);
            }
            return builder;
        }
    }

    static class TraceStorageProperties {
        private Boolean enabled;
        private String spansTopic;
        private Long ttlCheckInterval;
        private Long ttl;
        private Map<String, String> overrides = new LinkedHashMap<String, String>();

        TraceStorageProperties() {
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getSpansTopic() {
            return this.spansTopic;
        }

        public void setSpansTopic(String spansTopic) {
            this.spansTopic = spansTopic;
        }

        public Long getTtlCheckInterval() {
            return this.ttlCheckInterval;
        }

        public void setTtlCheckInterval(Long ttlCheckInterval) {
            this.ttlCheckInterval = ttlCheckInterval;
        }

        public Long getTtl() {
            return this.ttl;
        }

        public void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        public Map<String, String> getOverrides() {
            return this.overrides;
        }

        public void setOverrides(Map<String, String> overrides) {
            this.overrides = overrides;
        }

        KafkaStorageBuilder.TraceStorageBuilder toBuilder() {
            KafkaStorageBuilder.TraceStorageBuilder builder = new KafkaStorageBuilder.TraceStorageBuilder();
            if (this.enabled != null) {
                builder.enabled(this.enabled.booleanValue());
            }
            if (this.ttlCheckInterval != null) {
                builder.ttlCheckInterval(Duration.ofMillis(this.ttlCheckInterval));
            }
            if (this.ttl != null) {
                builder.ttl(Duration.ofMillis(this.ttl));
            }
            if (this.spansTopic != null) {
                builder.spansTopic(this.spansTopic);
            }
            if (this.overrides != null) {
                builder.overrides(this.overrides);
            }
            return builder;
        }
    }

    static class SpanAggregationProperties {
        private Boolean enabled;
        private String spansTopic;
        private String traceTopic;
        private String dependencyTopic;
        private Long traceTimeout;
        private Map<String, String> overrides = new LinkedHashMap<String, String>();

        SpanAggregationProperties() {
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getSpansTopic() {
            return this.spansTopic;
        }

        public void setSpansTopic(String spansTopic) {
            this.spansTopic = spansTopic;
        }

        public String getTraceTopic() {
            return this.traceTopic;
        }

        public void setTraceTopic(String traceTopic) {
            this.traceTopic = traceTopic;
        }

        public String getDependencyTopic() {
            return this.dependencyTopic;
        }

        public void setDependencyTopic(String dependencyTopic) {
            this.dependencyTopic = dependencyTopic;
        }

        public Long getTraceTimeout() {
            return this.traceTimeout;
        }

        public void setTraceTimeout(Long traceTimeout) {
            this.traceTimeout = traceTimeout;
        }

        public Map<String, String> getOverrides() {
            return this.overrides;
        }

        public void setOverrides(Map<String, String> overrides) {
            this.overrides = overrides;
        }

        KafkaStorageBuilder.SpanAggregationBuilder toBuilder() {
            KafkaStorageBuilder.SpanAggregationBuilder builder = new KafkaStorageBuilder.SpanAggregationBuilder();
            if (this.enabled != null) {
                builder.enabled(this.enabled.booleanValue());
            }
            if (this.traceTimeout != null) {
                builder.traceTimeout(Duration.ofMillis(this.traceTimeout));
            }
            if (this.spansTopic != null) {
                builder.spansTopic(this.spansTopic);
            }
            if (this.traceTopic != null) {
                builder.traceTopic(this.traceTopic);
            }
            if (this.dependencyTopic != null) {
                builder.dependencyTopic(this.dependencyTopic);
            }
            if (this.overrides != null) {
                builder.overrides(this.overrides);
            }
            return builder;
        }
    }

    static class SpanPartitioningProperties {
        private Boolean enabled;
        private String spansTopic;
        private Map<String, String> overrides = new LinkedHashMap<String, String>();

        SpanPartitioningProperties() {
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getSpansTopic() {
            return this.spansTopic;
        }

        public void setSpansTopic(String spansTopic) {
            this.spansTopic = spansTopic;
        }

        public Map<String, String> getOverrides() {
            return this.overrides;
        }

        public void setOverrides(Map<String, String> overrides) {
            this.overrides = overrides;
        }

        KafkaStorageBuilder.SpanPartitioningBuilder toBuilder() {
            KafkaStorageBuilder.SpanPartitioningBuilder builder = new KafkaStorageBuilder.SpanPartitioningBuilder();
            if (this.enabled != null) {
                builder.enabled(this.enabled.booleanValue());
            }
            if (this.spansTopic != null) {
                builder.spansTopic(this.spansTopic);
            }
            if (this.overrides != null) {
                builder.overrides(this.overrides);
            }
            return builder;
        }
    }
}

