/*
 * Decompiled with CFR 0.152.
 */
package zipkin.elasticsearch;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

final class IndexNameFormatter {
    private static final String DAILY_INDEX_FORMAT = "yyyy-MM-dd";
    private final String index;
    private final DateFormat dateFormat;

    IndexNameFormatter(String index) {
        this.index = index;
        this.dateFormat = new SimpleDateFormat(DAILY_INDEX_FORMAT);
    }

    String indexNameForTimestamp(long timestampMillis) {
        return this.index + "-" + this.dateFormat.format(new Date(timestampMillis));
    }

    String catchAll() {
        return this.index + "-*";
    }
}

