/*
 * Decompiled with CFR 0.152.
 */
package zipkin.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.nested.Nested;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import zipkin.Codec;
import zipkin.DependencyLink;
import zipkin.QueryRequest;
import zipkin.Span;
import zipkin.elasticsearch.ElasticFutures;
import zipkin.elasticsearch.ElasticsearchConfig;
import zipkin.elasticsearch.ElasticsearchSpanConsumer;
import zipkin.elasticsearch.IndexNameFormatter;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.spanstore.guava.GuavaSpanStore;
import zipkin.spanstore.guava.GuavaToAsyncSpanStoreAdapter;

public class ElasticsearchSpanStore
extends GuavaToAsyncSpanStoreAdapter
implements GuavaSpanStore,
AutoCloseable {
    static final long ONE_DAY_IN_MILLIS = TimeUnit.DAYS.toMillis(1L);
    private final Client client;
    private final IndexNameFormatter indexNameFormatter;
    private final ElasticsearchSpanConsumer spanConsumer;
    private final String indexTemplate;

    public ElasticsearchSpanStore(ElasticsearchConfig config) {
        this.client = ElasticsearchSpanStore.createClient(config.hosts, config.clusterName);
        this.indexNameFormatter = new IndexNameFormatter(config.index);
        this.spanConsumer = new ElasticsearchSpanConsumer(this.client, this.indexNameFormatter);
        this.indexTemplate = config.indexTemplate;
        this.checkForIndexTemplate();
    }

    protected GuavaSpanStore delegate() {
        return this;
    }

    public ListenableFuture<Void> accept(List<Span> spans) {
        return this.spanConsumer.accept(spans);
    }

    public ListenableFuture<List<List<Span>>> getTraces(QueryRequest request) {
        long endMillis = request.endTs;
        long beginMillis = endMillis - request.lookback;
        String serviceName = request.serviceName.toLowerCase();
        BoolQueryBuilder filter = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"annotations.endpoint.serviceName", (String)serviceName)).should((QueryBuilder)QueryBuilders.nestedQuery((String)"binaryAnnotations", (QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.endpoint.serviceName", (String)serviceName)))).must((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte(TimeUnit.MILLISECONDS.toMicros(beginMillis)).lte(TimeUnit.MILLISECONDS.toMicros(endMillis)));
        if (request.spanName != null) {
            filter.must((QueryBuilder)QueryBuilders.termQuery((String)"name", (String)request.spanName));
        }
        for (String string : request.annotations) {
            filter.must((QueryBuilder)QueryBuilders.termQuery((String)"annotations.value", (String)string));
        }
        for (Map.Entry entry : request.binaryAnnotations.entrySet()) {
            filter.must((QueryBuilder)QueryBuilders.nestedQuery((String)"binaryAnnotations", (QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.key", (String)((String)entry.getKey()))).must((QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.value", (String)((String)entry.getValue())))));
        }
        if (request.minDuration != null) {
            RangeQueryBuilder durationQuery = QueryBuilders.rangeQuery((String)"duration").gte((Object)request.minDuration);
            if (request.maxDuration != null) {
                durationQuery.lte((Object)request.maxDuration);
            }
            filter.must((QueryBuilder)durationQuery);
        }
        List<String> strings = this.computeIndices(beginMillis, endMillis);
        final String[] stringArray = strings.toArray(new String[strings.size()]);
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(stringArray).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTypes(new String[]{"span"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)filter)).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"traceId_agg").field("traceId")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.min((String)"timestamps_agg").field("timestamp"))).order(Terms.Order.aggregation((String)"timestamps_agg", (boolean)false)).size(request.limit));
        ListenableFuture traceIds = ElasticFutures.toGuava(elasticRequest.execute());
        return Futures.transform(traceIds, (AsyncFunction)new AsyncFunction<SearchResponse, List<List<Span>>>(){

            public ListenableFuture<List<List<Span>>> apply(SearchResponse input) {
                if (input.getAggregations() == null || input.getAggregations().get("traceId_agg") == null) {
                    return Futures.immediateFuture(Collections.emptyList());
                }
                Terms traceIdsAgg = (Terms)input.getAggregations().get("traceId_agg");
                ArrayList<Long> traceIds = new ArrayList<Long>();
                for (Terms.Bucket bucket : traceIdsAgg.getBuckets()) {
                    traceIds.add(Util.lowerHexToUnsignedLong((String)bucket.getKeyAsString()));
                }
                return ElasticsearchSpanStore.this.getTracesByIds(traceIds, stringArray);
            }
        });
    }

    public ListenableFuture<List<Span>> getTrace(long traceId) {
        return Futures.transform(this.getRawTrace(traceId), (Function)new Function<List<Span>, List<Span>>(){

            public List<Span> apply(List<Span> input) {
                return input == null ? null : CorrectForClockSkew.apply((List)MergeById.apply(input));
            }
        });
    }

    public ListenableFuture<List<Span>> getRawTrace(long traceId) {
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(new String[]{this.indexNameFormatter.catchAll()}).setTypes(new String[]{"span"}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"traceId", (String)String.format("%016x", traceId)));
        return Futures.transform(ElasticFutures.toGuava(elasticRequest.execute()), (Function)new Function<SearchResponse, List<Span>>(){

            public List<Span> apply(SearchResponse response) {
                if (response.getHits().totalHits() == 0L) {
                    return null;
                }
                ImmutableList.Builder trace = ImmutableList.builder();
                for (SearchHit hit : response.getHits()) {
                    trace.add((Object)Codec.JSON.readSpan(hit.getSourceRef().toBytes()));
                }
                return trace.build();
            }
        });
    }

    ListenableFuture<List<List<Span>>> getTracesByIds(Collection<Long> traceIds, String[] indices) {
        ArrayList<String> traceIdsStr = new ArrayList<String>(traceIds.size());
        for (long traceId : traceIds) {
            traceIdsStr.add(String.format("%016x", traceId));
        }
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(indices).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTypes(new String[]{"span"}).setSize(10000).setQuery((QueryBuilder)QueryBuilders.termsQuery((String)"traceId", traceIdsStr));
        return Futures.transform(ElasticFutures.toGuava(elasticRequest.execute()), (Function)ConvertTracesResponse.INSTANCE);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public ListenableFuture<List<String>> getServiceNames() {
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(new String[]{this.indexNameFormatter.catchAll()}).setTypes(new String[]{"span"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"annotationServiceName_agg").field("annotations.endpoint.serviceName")).size(0)).addAggregation((AbstractAggregationBuilder)AggregationBuilders.nested((String)"binaryAnnotations_agg").path("binaryAnnotations").subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"binaryAnnotationsServiceName_agg").field("binaryAnnotations.endpoint.serviceName")).size(0)));
        return Futures.transform(ElasticFutures.toGuava(elasticRequest.execute()), (Function)ConvertServiceNamesResponse.INSTANCE);
    }

    public ListenableFuture<List<String>> getSpanNames(String serviceName) {
        if (Strings.isNullOrEmpty((String)serviceName)) {
            return EMPTY_LIST;
        }
        serviceName = serviceName.toLowerCase();
        BoolQueryBuilder filter = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"annotations.endpoint.serviceName", (String)serviceName)).should((QueryBuilder)QueryBuilders.termQuery((String)"binaryAnnotations.endpoint.serviceName", (String)serviceName));
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(new String[]{this.indexNameFormatter.catchAll()}).setTypes(new String[]{"span"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)filter)).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)"name_agg").order(Terms.Order.term((boolean)true)).field("name")).size(0));
        return Futures.transform(ElasticFutures.toGuava(elasticRequest.execute()), (Function)ConvertSpanNameResponse.INSTANCE);
    }

    public ListenableFuture<List<DependencyLink>> getDependencies(long endMillis, @Nullable Long lookback) {
        long beginMillis = lookback != null ? endMillis - lookback : 0L;
        List<String> strings = this.computeIndices(beginMillis, endMillis);
        SearchRequestBuilder elasticRequest = this.client.prepareSearch(strings.toArray(new String[strings.size()])).setIndicesOptions(IndicesOptions.lenientExpandOpen()).setTypes(new String[]{"dependencylink"}).addAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"parent_child_agg").field("parent_child")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"hits_agg").setSize(1))).subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)"callCount_agg").field("callCount"))).setQuery((QueryBuilder)QueryBuilders.matchAllQuery());
        return Futures.transform(ElasticFutures.toGuava(elasticRequest.execute()), (Function)ConvertDependenciesResponse.INSTANCE);
    }

    @VisibleForTesting
    void clear() {
        this.client.admin().indices().delete(new DeleteIndexRequest(this.indexNameFormatter.catchAll())).actionGet();
        this.client.admin().indices().flush(new FlushRequest()).actionGet();
    }

    @VisibleForTesting
    void writeDependencyLinks(List<DependencyLink> links, long timestampMillis) {
        timestampMillis = Util.midnightUTC((long)timestampMillis);
        BulkRequestBuilder request = this.client.prepareBulk();
        for (DependencyLink link : links) {
            request.add(this.client.prepareIndex(this.indexNameFormatter.indexNameForTimestamp(timestampMillis), "dependencylink").setSource("parent", (Object)link.parent, "child", (Object)link.child, "parent_child", (Object)(link.parent + "|" + link.child), "callCount", (Object)link.callCount));
        }
        request.execute().actionGet();
        this.client.admin().indices().flush(new FlushRequest()).actionGet();
    }

    private List<String> computeIndices(long beginMillis, long endMillis) {
        beginMillis = Util.midnightUTC((long)beginMillis);
        endMillis = Util.midnightUTC((long)endMillis);
        ArrayList<String> indices = new ArrayList<String>();
        for (long currentMillis = beginMillis; currentMillis <= endMillis; currentMillis += ONE_DAY_IN_MILLIS) {
            indices.add(this.indexNameFormatter.indexNameForTimestamp(currentMillis));
        }
        return indices;
    }

    private void checkForIndexTemplate() {
        GetIndexTemplatesResponse existingTemplates = (GetIndexTemplatesResponse)this.client.admin().indices().getTemplates(new GetIndexTemplatesRequest(new String[]{"zipkin_template"})).actionGet();
        if (!existingTemplates.getIndexTemplates().isEmpty()) {
            return;
        }
        this.client.admin().indices().putTemplate(new PutIndexTemplateRequest("zipkin_template").source(this.indexTemplate)).actionGet();
    }

    private static Client createClient(List<String> hosts, String clusterName) {
        Settings settings = Settings.builder().put("cluster.name", clusterName).put("client.transport.sniff", true).build();
        TransportClient client = TransportClient.builder().settings(settings).build();
        for (String host : hosts) {
            HostAndPort hostAndPort = HostAndPort.fromString((String)host);
            try {
                client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(hostAndPort.getHostText()), hostAndPort.getPort()));
            }
            catch (UnknownHostException e) {}
        }
        return client;
    }

    static enum ConvertDependenciesResponse implements Function<SearchResponse, List<DependencyLink>>
    {
        INSTANCE;


        public List<DependencyLink> apply(SearchResponse response) {
            if (response.getAggregations() == null) {
                return Collections.emptyList();
            }
            Terms parentChildAgg = (Terms)response.getAggregations().get("parent_child_agg");
            if (parentChildAgg == null) {
                return Collections.emptyList();
            }
            ImmutableList.Builder links = ImmutableList.builder();
            for (Terms.Bucket bucket : parentChildAgg.getBuckets()) {
                TopHits hitsAgg = (TopHits)bucket.getAggregations().get("hits_agg");
                Sum callCountAgg = (Sum)bucket.getAggregations().get("callCount_agg");
                SearchHit hit = hitsAgg.getHits().getAt(0);
                DependencyLink link = Codec.JSON.readDependencyLink(hit.getSourceRef().toBytes());
                link = new DependencyLink.Builder(link).callCount((long)callCountAgg.getValue()).build();
                links.add((Object)link);
            }
            return links.build();
        }
    }

    static enum ConvertSpanNameResponse implements Function<SearchResponse, List<String>>
    {
        INSTANCE;


        public List<String> apply(SearchResponse response) {
            Terms namesAgg = (Terms)response.getAggregations().get("name_agg");
            if (namesAgg == null) {
                return Collections.emptyList();
            }
            ImmutableList.Builder spanNames = ImmutableList.builder();
            for (Terms.Bucket bucket : namesAgg.getBuckets()) {
                spanNames.add((Object)bucket.getKeyAsString());
            }
            return spanNames.build();
        }
    }

    static enum ConvertServiceNamesResponse implements Function<SearchResponse, List<String>>
    {
        INSTANCE;


        public List<String> apply(SearchResponse response) {
            Terms binaryAnnotationServiceNamesAgg;
            Nested binaryAnnotationsAgg;
            if (response.getAggregations() == null) {
                return Collections.emptyList();
            }
            TreeSet<String> serviceNames = new TreeSet<String>();
            Terms annotationServiceNamesAgg = (Terms)response.getAggregations().get("annotationServiceName_agg");
            if (annotationServiceNamesAgg != null) {
                for (Terms.Bucket bucket : annotationServiceNamesAgg.getBuckets()) {
                    if (bucket.getKeyAsString().isEmpty()) continue;
                    serviceNames.add(bucket.getKeyAsString());
                }
            }
            if ((binaryAnnotationsAgg = (Nested)response.getAggregations().get("binaryAnnotations_agg")) != null && binaryAnnotationsAgg.getAggregations() != null && (binaryAnnotationServiceNamesAgg = (Terms)binaryAnnotationsAgg.getAggregations().get("binaryAnnotationsServiceName_agg")) != null) {
                for (Terms.Bucket bucket : binaryAnnotationServiceNamesAgg.getBuckets()) {
                    if (bucket.getKeyAsString().isEmpty()) continue;
                    serviceNames.add(bucket.getKeyAsString());
                }
            }
            return ImmutableList.copyOf(serviceNames);
        }
    }

    static enum ConvertTracesResponse implements Function<SearchResponse, List<List<Span>>>
    {
        INSTANCE;


        public List<List<Span>> apply(SearchResponse response) {
            ArrayListMultimap groupedSpans = ArrayListMultimap.create();
            for (SearchHit hit : response.getHits()) {
                Span span = Codec.JSON.readSpan(hit.getSourceRef().toBytes());
                groupedSpans.put((Object)span.traceId, (Object)span);
            }
            ArrayList<List> result = new ArrayList<List>(groupedSpans.size());
            for (Long traceId : groupedSpans.keySet()) {
                result.add(CorrectForClockSkew.apply((List)MergeById.apply((Collection)groupedSpans.get((Object)traceId))));
            }
            return TRACE_DESCENDING.immutableSortedCopy(result);
        }
    }
}

