/*
 * Decompiled with CFR 0.152.
 */
package zipkin.elasticsearch;

import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import zipkin.internal.Util;

public class ElasticsearchConfig {
    final String clusterName;
    final List<String> hosts;
    final String index;
    final String indexTemplate;

    ElasticsearchConfig(Builder builder) {
        this.clusterName = (String)Util.checkNotNull((Object)builder.cluster, (String)"builder.cluster");
        this.hosts = (List)Util.checkNotNull((Object)builder.hosts, (String)"builder.hosts");
        this.index = (String)Util.checkNotNull((Object)builder.index, (String)"builder.index");
        try {
            this.indexTemplate = Resources.toString((URL)Resources.getResource((String)"zipkin/elasticsearch/zipkin_template.json"), (Charset)StandardCharsets.UTF_8).replace("${__INDEX__}", this.index);
        }
        catch (IOException e) {
            throw new AssertionError("Error reading jar resource, shouldn't happen.", e);
        }
    }

    public static final class Builder {
        private String cluster = "elasticsearch";
        private List<String> hosts = Collections.singletonList("localhost:9300");
        private String index = "zipkin";

        public Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder hosts(List<String> hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public ElasticsearchConfig build() {
            return new ElasticsearchConfig(this);
        }
    }
}

