/*
 * Decompiled with CFR 0.152.
 */
package zipkin.sparkstreaming.autoconfigure.consumer.storage;

import java.io.IOException;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import zipkin.Component;
import zipkin.autoconfigure.storage.cassandra.ZipkinCassandraStorageAutoConfiguration;
import zipkin.autoconfigure.storage.cassandra.ZipkinCassandraStorageProperties;
import zipkin.autoconfigure.storage.cassandra3.ZipkinCassandra3StorageAutoConfiguration;
import zipkin.autoconfigure.storage.cassandra3.ZipkinCassandra3StorageProperties;
import zipkin.autoconfigure.storage.elasticsearch.http.ZipkinElasticsearchHttpStorageAutoConfiguration;
import zipkin.autoconfigure.storage.elasticsearch.http.ZipkinElasticsearchHttpStorageProperties;
import zipkin.autoconfigure.storage.elasticsearch.http.ZipkinElasticsearchOkHttpAutoConfiguration;
import zipkin.autoconfigure.storage.mysql.ZipkinMySQLStorageAutoConfiguration;
import zipkin.autoconfigure.storage.mysql.ZipkinMySQLStorageProperties;
import zipkin.sparkstreaming.autoconfigure.consumer.storage.ZipkinStorageConsumerAutoConfiguration$MySQLStorageConsumer$$Lambda$1;
import zipkin.sparkstreaming.consumer.storage.StorageConsumer;
import zipkin.storage.StorageComponent;
import zipkin.storage.cassandra.CassandraStorage;
import zipkin.storage.cassandra3.Cassandra3Storage;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin.storage.mysql.MySQLStorage;

@Configuration
@ConditionalOnProperty(value={"zipkin.storage.type"})
@EnableConfigurationProperties(value={ZipkinCassandraStorageProperties.class, ZipkinCassandra3StorageProperties.class, ZipkinElasticsearchHttpStorageProperties.class, ZipkinMySQLStorageProperties.class})
@Import(value={ZipkinCassandraStorageAutoConfiguration.class, ZipkinCassandra3StorageAutoConfiguration.class, ZipkinElasticsearchOkHttpAutoConfiguration.class, ZipkinElasticsearchHttpStorageAutoConfiguration.class, ZipkinMySQLStorageAutoConfiguration.class})
public class ZipkinStorageConsumerAutoConfiguration {
    @ConditionalOnBean(value={StorageComponent.class})
    @Bean
    StorageConsumer storageConsumer(StorageComponent component, @Value(value="${zipkin.sparkstreaming.consumer.storage.fail-fast:true}") boolean failFast, BeanFactory bf) throws IOException {
        if (failFast) {
            this.checkStorageOk(component);
        }
        if (component instanceof ElasticsearchHttpStorage) {
            return new ElasticsearchStorageConsumer((ZipkinElasticsearchHttpStorageProperties)bf.getBean(ZipkinElasticsearchHttpStorageProperties.class));
        }
        if (component instanceof CassandraStorage) {
            return new CassandraStorageConsumer((ZipkinCassandraStorageProperties)bf.getBean(ZipkinCassandraStorageProperties.class));
        }
        if (component instanceof Cassandra3Storage) {
            return new Cassandra3StorageConsumer((ZipkinCassandra3StorageProperties)bf.getBean(ZipkinCassandra3StorageProperties.class));
        }
        if (component instanceof MySQLStorage) {
            return new MySQLStorageConsumer((ZipkinMySQLStorageProperties)bf.getBean(ZipkinMySQLStorageProperties.class));
        }
        throw new UnsupportedOperationException(component + " not yet supported");
    }

    void checkStorageOk(StorageComponent component) throws IOException {
        Component.CheckResult result = component.check();
        if (!result.ok) {
            throw new IllegalStateException("Storage not ok", result.exception);
        }
        component.close();
    }

    static final class MySQLStorageConsumer
    extends StorageConsumer {
        final ZipkinMySQLStorageProperties properties;

        MySQLStorageConsumer(ZipkinMySQLStorageProperties properties) {
            this.properties = properties;
        }

        protected StorageComponent tryCompute() {
            return MySQLStorage.builder().executor(ZipkinStorageConsumerAutoConfiguration$MySQLStorageConsumer$$Lambda$1.lambdaFactory$()).datasource(this.properties.toDataSource()).build();
        }
    }

    static final class Cassandra3StorageConsumer
    extends StorageConsumer {
        final ZipkinCassandra3StorageProperties properties;

        Cassandra3StorageConsumer(ZipkinCassandra3StorageProperties properties) {
            this.properties = properties;
        }

        protected StorageComponent tryCompute() {
            return this.properties.toBuilder().build();
        }
    }

    static final class CassandraStorageConsumer
    extends StorageConsumer {
        final ZipkinCassandraStorageProperties properties;

        CassandraStorageConsumer(ZipkinCassandraStorageProperties properties) {
            this.properties = properties;
        }

        protected StorageComponent tryCompute() {
            return this.properties.toBuilder().build();
        }
    }

    static final class ElasticsearchStorageConsumer
    extends StorageConsumer {
        final ZipkinElasticsearchHttpStorageProperties properties;

        ElasticsearchStorageConsumer(ZipkinElasticsearchHttpStorageProperties properties) {
            this.properties = properties;
        }

        protected StorageComponent tryCompute() {
            return this.properties.toBuilder(new OkHttpClient()).build();
        }
    }
}

