/*
 * Decompiled with CFR 0.152.
 */
package zipkin.sparkstreaming.autoconfigure.consumer.storage;

import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import zipkin.Component;
import zipkin.autoconfigure.storage.cassandra.ZipkinCassandraStorageAutoConfiguration;
import zipkin.autoconfigure.storage.cassandra3.ZipkinCassandra3StorageAutoConfiguration;
import zipkin.autoconfigure.storage.elasticsearch.http.ZipkinElasticsearchHttpStorageAutoConfiguration;
import zipkin.autoconfigure.storage.elasticsearch.http.ZipkinElasticsearchOkHttpAutoConfiguration;
import zipkin.autoconfigure.storage.mysql.ZipkinMySQLStorageAutoConfiguration;
import zipkin.internal.V2StorageComponent;
import zipkin.sparkstreaming.consumer.storage.StorageConsumer;
import zipkin.storage.elasticsearch.http.ElasticsearchHttpStorage;
import zipkin.storage.mysql.MySQLStorage;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.cassandra.CassandraStorage;

@Configuration
@ConditionalOnProperty(value={"zipkin.storage.type"})
@Import(value={ZipkinCassandraStorageAutoConfiguration.class, ZipkinCassandra3StorageAutoConfiguration.class, ZipkinElasticsearchOkHttpAutoConfiguration.class, ZipkinElasticsearchHttpStorageAutoConfiguration.class, ZipkinMySQLStorageAutoConfiguration.class})
public class ZipkinStorageConsumerAutoConfiguration {
    @ConditionalOnBean(value={zipkin.storage.StorageComponent.class})
    @Bean
    StorageConsumer storageConsumer(zipkin.storage.StorageComponent component, @Value(value="${zipkin.sparkstreaming.consumer.storage.fail-fast:true}") boolean failFast, BeanFactory bf) throws IOException {
        if (failFast) {
            this.checkStorageOk(component);
        }
        Properties properties = ZipkinStorageConsumerAutoConfiguration.extractZipkinProperties((ConfigurableEnvironment)bf.getBean(ConfigurableEnvironment.class));
        if (component instanceof V2StorageComponent) {
            StorageComponent v2Storage = ((V2StorageComponent)component).delegate();
            if (v2Storage instanceof ElasticsearchHttpStorage) {
                return new ElasticsearchStorageConsumer(properties);
            }
            if (v2Storage instanceof CassandraStorage) {
                return new Cassandra3StorageConsumer(properties);
            }
            throw new UnsupportedOperationException(v2Storage + " not yet supported");
        }
        if (component instanceof zipkin.storage.cassandra.CassandraStorage) {
            return new CassandraStorageConsumer(properties);
        }
        if (component instanceof MySQLStorage) {
            return new MySQLStorageConsumer(properties);
        }
        throw new UnsupportedOperationException(component + " not yet supported");
    }

    void checkStorageOk(zipkin.storage.StorageComponent component) throws IOException {
        Component.CheckResult result = component.check();
        if (!result.ok) {
            throw new IllegalStateException("Storage not ok", result.exception);
        }
        component.close();
    }

    static Properties extractZipkinProperties(ConfigurableEnvironment env) {
        Properties properties = new Properties();
        for (PropertySource next : env.getPropertySources()) {
            if (!(next instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource source = (EnumerablePropertySource)next;
            for (String name : source.getPropertyNames()) {
                if (!name.startsWith("zipkin")) continue;
                properties.put(name, source.getProperty(name));
            }
        }
        return properties;
    }

    static abstract class AutoConfigurationStorageConsumer
    extends StorageConsumer {
        final Properties properties;

        AutoConfigurationStorageConsumer(Properties properties) {
            this.properties = properties;
        }

        protected zipkin.storage.StorageComponent tryCompute() {
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
            PropertiesPropertySource source = new PropertiesPropertySource("consumer", this.properties);
            context.getEnvironment().getPropertySources().addLast((PropertySource)source);
            context.register(new Class[]{PropertyPlaceholderAutoConfiguration.class});
            this.registerAutoConfiguration(context);
            context.refresh();
            return (zipkin.storage.StorageComponent)context.getBean(zipkin.storage.StorageComponent.class);
        }

        abstract void registerAutoConfiguration(AnnotationConfigApplicationContext var1);
    }

    static final class MySQLStorageConsumer
    extends AutoConfigurationStorageConsumer {
        MySQLStorageConsumer(Properties properties) {
            super(properties);
        }

        @Override
        void registerAutoConfiguration(AnnotationConfigApplicationContext context) {
            context.register(new Class[]{ZipkinMySQLStorageAutoConfiguration.class});
        }
    }

    static final class Cassandra3StorageConsumer
    extends AutoConfigurationStorageConsumer {
        Cassandra3StorageConsumer(Properties properties) {
            super(properties);
        }

        @Override
        void registerAutoConfiguration(AnnotationConfigApplicationContext context) {
            context.register(new Class[]{ZipkinCassandra3StorageAutoConfiguration.class});
        }
    }

    static final class CassandraStorageConsumer
    extends AutoConfigurationStorageConsumer {
        CassandraStorageConsumer(Properties properties) {
            super(properties);
        }

        @Override
        void registerAutoConfiguration(AnnotationConfigApplicationContext context) {
            context.register(new Class[]{ZipkinCassandraStorageAutoConfiguration.class});
        }
    }

    static final class ElasticsearchStorageConsumer
    extends AutoConfigurationStorageConsumer {
        ElasticsearchStorageConsumer(Properties properties) {
            super(properties);
        }

        @Override
        void registerAutoConfiguration(AnnotationConfigApplicationContext context) {
            context.register(new Class[]{ZipkinElasticsearchOkHttpAutoConfiguration.class});
            context.register(new Class[]{ZipkinElasticsearchHttpStorageAutoConfiguration.class});
        }
    }
}

