/*
 * Decompiled with CFR 0.152.
 */
package zipkin.sparkstreaming.consumer.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import zipkin.Component;
import zipkin.Span;
import zipkin.internal.CallbackCaptor;
import zipkin.sparkstreaming.Consumer;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

public abstract class StorageConsumer
implements Consumer,
Component {
    static final Logger log = Logger.getLogger(StorageConsumer.class.getName());
    volatile transient StorageComponent instance;

    protected abstract StorageComponent tryCompute();

    Logger log() {
        return log;
    }

    public final void accept(Iterable<Span> spansSharingId) {
        List<Span> list = StorageConsumer.asList(spansSharingId);
        if (list.isEmpty()) {
            this.log().fine("Input was empty");
            return;
        }
        CallbackCaptor blockingCallback = new CallbackCaptor();
        try {
            this.get().asyncSpanConsumer().accept(list, (Callback)blockingCallback);
            blockingCallback.get();
            this.log().info("Wrote " + list.size() + " spans");
        }
        catch (RuntimeException e) {
            RuntimeException toLog = e.getClass().equals(RuntimeException.class) && e.getCause() != null ? e.getCause() : e;
            String message = "Dropped " + list.size() + " spans: " + toLog.getMessage();
            if (this.log().isLoggable(Level.WARNING)) {
                this.log().log(Level.WARNING, message, toLog);
            }
            this.log().warning(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final StorageComponent get() {
        StorageComponent result = this.instance;
        if (result == null) {
            StorageConsumer storageConsumer = this;
            synchronized (storageConsumer) {
                result = this.instance;
                if (result == null) {
                    this.instance = result = this.tryCompute();
                }
            }
        }
        return result;
    }

    public Component.CheckResult check() {
        return this.get().check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        StorageConsumer storageConsumer = this;
        synchronized (storageConsumer) {
            if (this.instance != null) {
                this.instance.close();
            }
        }
    }

    static <E> List<E> asList(Iterable<E> iter) {
        ArrayList<E> list = new ArrayList<E>();
        for (E item : iter) {
            list.add(item);
        }
        return list;
    }
}

