/*
 * Decompiled with CFR 0.152.
 */
package zipkin.sparkstreaming.consumer.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Component;
import zipkin.Span;
import zipkin.internal.CallbackCaptor;
import zipkin.sparkstreaming.Consumer;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

public abstract class StorageConsumer
implements Consumer,
Component {
    private static final Logger log = LoggerFactory.getLogger(StorageConsumer.class);
    volatile transient StorageComponent instance;

    Logger log() {
        return log;
    }

    protected abstract StorageComponent tryCompute();

    public final void accept(Iterable<Span> spansSharingId) {
        List<Span> list = StorageConsumer.asList(spansSharingId);
        if (list.isEmpty()) {
            this.log().debug("Input was empty");
            return;
        }
        CallbackCaptor blockingCallback = new CallbackCaptor();
        try {
            this.get().asyncSpanConsumer().accept(list, (Callback)blockingCallback);
            blockingCallback.get();
            this.log().debug("Wrote {} spans", (Object)list.size());
        }
        catch (RuntimeException e) {
            RuntimeException toLog = e.getClass().equals(RuntimeException.class) && e.getCause() != null ? e.getCause() : e;
            String message = "Dropped " + list.size() + " spans: " + toLog.getMessage();
            if (this.log().isWarnEnabled()) {
                this.log().warn(message, (Throwable)toLog);
            }
            this.log().warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final StorageComponent get() {
        StorageComponent result = this.instance;
        if (result == null) {
            StorageConsumer storageConsumer = this;
            synchronized (storageConsumer) {
                result = this.instance;
                if (result == null) {
                    this.instance = result = this.tryCompute();
                }
            }
        }
        return result;
    }

    public Component.CheckResult check() {
        return this.get().check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        StorageConsumer storageConsumer = this;
        synchronized (storageConsumer) {
            if (this.instance != null) {
                this.instance.close();
            }
        }
    }

    static <E> List<E> asList(Iterable<E> iter) {
        ArrayList<E> list = new ArrayList<E>();
        for (E item : iter) {
            list.add(item);
        }
        return list;
    }
}

