/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector.activemq;

import java.io.IOException;
import java.io.UncheckedIOException;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import zipkin2.CheckResult;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorComponent;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.collector.activemq.LazyInit;
import zipkin2.storage.StorageComponent;

public final class ActiveMQCollector
extends CollectorComponent {
    final String queue;
    final LazyInit lazyInit;

    public static Builder builder() {
        return new Builder();
    }

    ActiveMQCollector(Builder builder) {
        this.queue = builder.queue;
        this.lazyInit = new LazyInit(builder);
    }

    public ActiveMQCollector start() {
        this.lazyInit.init();
        return this;
    }

    public CheckResult check() {
        if (this.lazyInit.result == null) {
            return CheckResult.failed((Throwable)new IllegalStateException("Collector not yet started"));
        }
        return this.lazyInit.result.checkResult;
    }

    public void close() throws IOException {
        this.lazyInit.close();
    }

    public final String toString() {
        return "ActiveMQCollector{brokerURL=" + this.lazyInit.connectionFactory.getBrokerURL() + ", queue=" + this.lazyInit.queue + "}";
    }

    static RuntimeException uncheckedException(String prefix, JMSException e) {
        Exception cause = e.getLinkedException();
        if (cause instanceof IOException) {
            return new UncheckedIOException(prefix + ActiveMQCollector.message(cause), (IOException)cause);
        }
        return new RuntimeException(prefix + ActiveMQCollector.message((Exception)((Object)e)), e);
    }

    static String message(Exception cause) {
        return cause.getMessage() != null ? cause.getMessage() : cause.getClass().getSimpleName();
    }

    public static final class Builder
    extends CollectorComponent.Builder {
        Collector.Builder delegate = Collector.newBuilder(ActiveMQCollector.class);
        CollectorMetrics metrics = CollectorMetrics.NOOP_METRICS;
        ActiveMQConnectionFactory connectionFactory;
        String queue = "zipkin";
        int concurrency = 1;

        public Builder storage(StorageComponent storage) {
            this.delegate.storage(storage);
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics == null");
            }
            this.metrics = metrics.forTransport("activemq");
            this.delegate.metrics(this.metrics);
            return this;
        }

        public Builder connectionFactory(ActiveMQConnectionFactory connectionFactory) {
            if (connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder queue(String queue) {
            if (queue == null) {
                throw new NullPointerException("queue == null");
            }
            this.queue = queue;
            return this;
        }

        public Builder concurrency(int concurrency) {
            if (concurrency < 1) {
                throw new IllegalArgumentException("concurrency < 1");
            }
            this.concurrency = concurrency;
            return this;
        }

        public ActiveMQCollector build() {
            if (this.connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            return new ActiveMQCollector(this);
        }
    }
}

