/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector.activemq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.transport.TransportListener;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;

final class ActiveMQSpanConsumer
implements TransportListener,
MessageListener,
Closeable {
    static final Callback<Void> NOOP = new Callback<Void>(){

        public void onSuccess(Void value) {
        }

        public void onError(Throwable t) {
        }
    };
    static final CheckResult CLOSED = CheckResult.failed((Throwable)new IllegalStateException("Collector intentionally closed"));
    static final CheckResult INTERRUPTION = CheckResult.failed((Throwable)new IOException("Recoverable error on ActiveMQ connection"));
    final Collector collector;
    final CollectorMetrics metrics;
    final ActiveMQConnection connection;
    final Map<QueueSession, QueueReceiver> sessionToReceiver = new LinkedHashMap<QueueSession, QueueReceiver>();
    volatile CheckResult checkResult = CheckResult.OK;

    ActiveMQSpanConsumer(Collector collector, CollectorMetrics metrics, ActiveMQConnection conn) {
        this.collector = collector;
        this.metrics = metrics;
        this.connection = conn;
        this.connection.addTransportListener((TransportListener)this);
    }

    void registerInNewSession(ActiveMQConnection connection, String queue) throws JMSException {
        QueueSession session = connection.createQueueSession(false, 1);
        Queue destination = session.createQueue(queue);
        QueueReceiver receiver = session.createReceiver(destination);
        receiver.setMessageListener((MessageListener)this);
        this.sessionToReceiver.put(session, receiver);
    }

    public void onCommand(Object o) {
    }

    public void onException(IOException error) {
        this.checkResult = CheckResult.failed((Throwable)error);
    }

    public void transportInterupted() {
        this.checkResult = INTERRUPTION;
    }

    public void transportResumed() {
        this.checkResult = CheckResult.OK;
    }

    public void onMessage(Message message) {
        byte[] serialized;
        block5: {
            this.metrics.incrementMessages();
            try {
                if (message instanceof BytesMessage) {
                    BytesMessage bytesMessage = (BytesMessage)message;
                    serialized = new byte[(int)bytesMessage.getBodyLength()];
                    bytesMessage.readBytes(serialized);
                    break block5;
                }
                if (message instanceof TextMessage) {
                    String text = ((TextMessage)message).getText();
                    serialized = text.getBytes(StandardCharsets.UTF_8);
                    break block5;
                }
                this.metrics.incrementMessagesDropped();
                return;
            }
            catch (Exception e) {
                this.metrics.incrementMessagesDropped();
                return;
            }
        }
        this.metrics.incrementBytes(serialized.length);
        if (serialized.length == 0) {
            return;
        }
        this.collector.acceptSpans(serialized, NOOP);
    }

    @Override
    public void close() {
        if (this.checkResult == CLOSED) {
            return;
        }
        this.checkResult = CLOSED;
        this.connection.removeTransportListener((TransportListener)this);
        try {
            for (Map.Entry<QueueSession, QueueReceiver> sessionReceiver : this.sessionToReceiver.entrySet()) {
                sessionReceiver.getValue().setMessageListener(null);
                sessionReceiver.getKey().close();
            }
            this.connection.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

