/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector.activemq;

import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.activemq.ActiveMQCollector;
import zipkin2.collector.activemq.ActiveMQSpanConsumer;

final class LazyInit {
    final Collector collector;
    final CollectorMetrics metrics;
    final ActiveMQConnectionFactory connectionFactory;
    final String queue;
    final int concurrency;
    volatile ActiveMQSpanConsumer result;

    LazyInit(ActiveMQCollector.Builder builder) {
        this.collector = builder.delegate.build();
        this.metrics = builder.metrics;
        this.connectionFactory = builder.connectionFactory;
        this.queue = builder.queue;
        this.concurrency = builder.concurrency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActiveMQSpanConsumer init() {
        if (this.result == null) {
            LazyInit lazyInit = this;
            synchronized (lazyInit) {
                if (this.result == null) {
                    this.result = this.doInit();
                }
            }
        }
        return this.result;
    }

    void close() {
        ActiveMQSpanConsumer maybe = this.result;
        if (maybe != null) {
            this.result.close();
        }
    }

    ActiveMQSpanConsumer doInit() {
        ActiveMQConnection connection;
        try {
            connection = (ActiveMQConnection)this.connectionFactory.createQueueConnection();
            connection.start();
        }
        catch (JMSException e) {
            throw ActiveMQCollector.uncheckedException("Unable to establish connection to ActiveMQ broker: ", e);
        }
        try {
            ActiveMQSpanConsumer result = new ActiveMQSpanConsumer(this.collector, this.metrics, connection);
            for (int i = 0; i < this.concurrency; ++i) {
                result.registerInNewSession(connection, this.queue);
            }
            return result;
        }
        catch (JMSException e) {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            throw ActiveMQCollector.uncheckedException("Unable to create queueReceiver(" + this.queue + "): ", e);
        }
    }
}

