/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.collector.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.collector.Collector;
import zipkin2.collector.CollectorComponent;
import zipkin2.collector.CollectorMetrics;
import zipkin2.collector.CollectorSampler;
import zipkin2.storage.StorageComponent;

public final class RabbitMQCollector
extends CollectorComponent {
    static final Callback<Void> NOOP = new Callback<Void>(){

        public void onSuccess(Void value) {
        }

        public void onError(Throwable t) {
        }
    };
    final String queue;
    final LazyInit connection;

    public static Builder builder() {
        return new Builder();
    }

    RabbitMQCollector(Builder builder) {
        this.queue = builder.queue;
        this.connection = new LazyInit(builder);
    }

    public RabbitMQCollector start() {
        this.connection.get();
        return this;
    }

    public CheckResult check() {
        try {
            this.start();
            CheckResult failure = this.connection.failure.get();
            if (failure != null) {
                return failure;
            }
            return CheckResult.OK;
        }
        catch (Throwable e) {
            Call.propagateIfFatal((Throwable)e);
            return CheckResult.failed((Throwable)e);
        }
    }

    public void close() throws IOException {
        this.connection.close();
    }

    public final String toString() {
        return "RabbitMQCollector{addresses=" + Arrays.toString(this.connection.builder.addresses) + ", queue=" + this.queue + "}";
    }

    static Address[] convertAddresses(List<String> addresses) {
        Address[] addressArray = new Address[addresses.size()];
        for (int i = 0; i < addresses.size(); ++i) {
            String[] splitAddress = addresses.get(i).split(":", 100);
            String host = splitAddress[0];
            Integer port = null;
            try {
                if (splitAddress.length == 2) {
                    port = Integer.parseInt(splitAddress[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            addressArray[i] = port != null ? new Address(host, port.intValue()) : new Address(host);
        }
        return addressArray;
    }

    public static final class Builder
    extends CollectorComponent.Builder {
        Collector.Builder delegate = Collector.newBuilder(RabbitMQCollector.class);
        CollectorMetrics metrics = CollectorMetrics.NOOP_METRICS;
        String queue = "zipkin";
        ConnectionFactory connectionFactory = new ConnectionFactory();
        Address[] addresses;
        int concurrency = 1;

        public Builder storage(StorageComponent storage) {
            this.delegate.storage(storage);
            return this;
        }

        public Builder sampler(CollectorSampler sampler) {
            this.delegate.sampler(sampler);
            return this;
        }

        public Builder metrics(CollectorMetrics metrics) {
            if (metrics == null) {
                throw new NullPointerException("metrics == null");
            }
            this.metrics = metrics.forTransport("rabbitmq");
            this.delegate.metrics(this.metrics);
            return this;
        }

        public Builder addresses(List<String> addresses) {
            this.addresses = RabbitMQCollector.convertAddresses(addresses);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public Builder connectionFactory(ConnectionFactory connectionFactory) {
            if (connectionFactory == null) {
                throw new NullPointerException("connectionFactory == null");
            }
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder queue(String queue) {
            if (queue == null) {
                throw new NullPointerException("queue == null");
            }
            this.queue = queue;
            return this;
        }

        public RabbitMQCollector build() {
            return new RabbitMQCollector(this);
        }
    }

    static final class LazyInit {
        final Builder builder;
        final AtomicReference<CheckResult> failure = new AtomicReference();
        volatile Connection connection;

        LazyInit(Builder builder) {
            this.builder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connection get() {
            if (this.connection == null) {
                LazyInit lazyInit = this;
                synchronized (lazyInit) {
                    if (this.connection == null) {
                        this.connection = this.compute();
                    }
                }
            }
            return this.connection;
        }

        void close() throws IOException {
            Connection maybeConnection = this.connection;
            if (maybeConnection != null) {
                maybeConnection.close();
            }
        }

        Connection compute() {
            Connection connection;
            try {
                connection = this.builder.addresses == null ? this.builder.connectionFactory.newConnection() : this.builder.connectionFactory.newConnection(this.builder.addresses);
                this.declareQueueIfMissing(connection);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to establish connection to RabbitMQ server: " + e.getMessage(), e);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Timeout establishing connection to RabbitMQ server: " + e.getMessage(), e);
            }
            Collector collector = this.builder.delegate.build();
            CollectorMetrics metrics = this.builder.metrics;
            for (int i = 0; i < this.builder.concurrency; ++i) {
                String consumerTag = "zipkin-rabbitmq." + i;
                try {
                    Channel channel = connection.createChannel();
                    RabbitMQSpanConsumer consumer = new RabbitMQSpanConsumer(channel, collector, metrics);
                    channel.basicConsume(this.builder.queue, true, consumerTag, (Consumer)consumer);
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to start RabbitMQ consumer " + consumerTag, e);
                }
            }
            return connection;
        }

        private void declareQueueIfMissing(Connection connection) throws IOException, TimeoutException {
            Channel channel = connection.createChannel();
            try {
                channel.queueDeclarePassive(this.builder.queue);
                channel.close();
            }
            catch (IOException maybeQueueDoesNotExist) {
                Throwable cause = maybeQueueDoesNotExist.getCause();
                if (cause != null && cause.getMessage().contains("NOT_FOUND")) {
                    channel = connection.createChannel();
                    channel.queueDeclare(this.builder.queue, true, false, false, null);
                    channel.close();
                }
                throw maybeQueueDoesNotExist;
            }
        }
    }

    static class RabbitMQSpanConsumer
    extends DefaultConsumer {
        final Collector collector;
        final CollectorMetrics metrics;

        RabbitMQSpanConsumer(Channel channel, Collector collector, CollectorMetrics metrics) {
            super(channel);
            this.collector = collector;
            this.metrics = metrics;
        }

        public void handleDelivery(String tag, Envelope envelope, AMQP.BasicProperties props, byte[] body) {
            this.metrics.incrementMessages();
            this.metrics.incrementBytes(body.length);
            if (body.length == 0) {
                return;
            }
            this.collector.acceptSpans(body, NOOP);
        }
    }
}

