/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.TestObjects;
import zipkin2.storage.ServiceAndSpanNames;
import zipkin2.storage.StorageComponent;

public abstract class ITServiceAndSpanNames {
    protected abstract StorageComponent storage();

    protected ServiceAndSpanNames serviceAndSpanNames() {
        return this.storage().serviceAndSpanNames();
    }

    @Before
    public abstract void clear() throws Exception;

    @Test
    public void getLocalServiceNames_includesLocalServiceName() throws Exception {
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getServiceNames().execute())).isEmpty();
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getServiceNames().execute())).containsOnly((Object[])new String[]{"frontend"});
    }

    @Test
    public void getLocalServiceNames_noServiceName() throws IOException {
        this.accept(Span.newBuilder().traceId("a").id("a").build());
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getServiceNames().execute())).isEmpty();
    }

    @Test
    public void getRemoteServiceNames() throws Exception {
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getRemoteServiceNames("frontend").execute())).isEmpty();
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getRemoteServiceNames("frontend1").execute())).isEmpty();
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getRemoteServiceNames("frontend").execute())).contains((Object[])new String[]{TestObjects.CLIENT_SPAN.remoteServiceName()});
    }

    @Test
    public void getRemoteServiceNames_allReturned() throws IOException {
        ArrayList<String> remoteServiceNames = new ArrayList<String>();
        for (int i = 0; i < 50; ++i) {
            String suffix = i < 10 ? "0" + i : String.valueOf(i);
            this.accept(TestObjects.CLIENT_SPAN.toBuilder().id((long)(i + 1)).remoteEndpoint(Endpoint.newBuilder().serviceName("yak" + suffix).build()).build());
            remoteServiceNames.add("yak" + suffix);
        }
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getRemoteServiceNames("frontend").execute())).containsExactlyInAnyOrderElementsOf(remoteServiceNames);
    }

    @Test
    public void getRemoteServiceNames_dedupes() throws IOException {
        for (int i = 0; i < 50; ++i) {
            this.accept(TestObjects.CLIENT_SPAN.toBuilder().id((long)(i + 1)).build());
        }
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getRemoteServiceNames("frontend").execute())).containsExactly((Object[])new String[]{TestObjects.CLIENT_SPAN.remoteServiceName()});
    }

    @Test
    public void getRemoteServiceNames_noRemoteServiceName() throws IOException {
        this.accept(Span.newBuilder().traceId("a").id("a").localEndpoint(TestObjects.FRONTEND).build());
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getRemoteServiceNames("frontend").execute())).isEmpty();
    }

    @Test
    public void getRemoteServiceNames_serviceNameGoesLowercase() throws IOException {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getRemoteServiceNames("FrOnTeNd").execute())).containsExactly((Object[])new String[]{TestObjects.CLIENT_SPAN.remoteServiceName()});
    }

    @Test
    public void getSpanNames_doesNotMapNameToRemoteServiceName() throws Exception {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getSpanNames(TestObjects.CLIENT_SPAN.remoteServiceName()).execute())).isEmpty();
    }

    @Test
    public void getSpanNames() throws Exception {
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getSpanNames("frontend").execute())).isEmpty();
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getSpanNames("frontend1").execute())).isEmpty();
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getSpanNames("frontend").execute())).contains((Object[])new String[]{TestObjects.CLIENT_SPAN.name()});
    }

    @Test
    public void getSpanNames_allReturned() throws IOException {
        ArrayList<String> spanNames = new ArrayList<String>();
        for (int i = 0; i < 50; ++i) {
            String suffix = i < 10 ? "0" + i : String.valueOf(i);
            this.accept(TestObjects.CLIENT_SPAN.toBuilder().id((long)(i + 1)).name("yak" + suffix).build());
            spanNames.add("yak" + suffix);
        }
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getSpanNames("frontend").execute())).containsExactlyInAnyOrderElementsOf(spanNames);
    }

    @Test
    public void getSpanNames_dedupes() throws IOException {
        for (int i = 0; i < 50; ++i) {
            this.accept(TestObjects.CLIENT_SPAN.toBuilder().id((long)(i + 1)).build());
        }
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getSpanNames("frontend").execute())).containsExactly((Object[])new String[]{TestObjects.CLIENT_SPAN.name()});
    }

    @Test
    public void getSpanNames_noSpanName() throws IOException {
        this.accept(Span.newBuilder().traceId("a").id("a").localEndpoint(TestObjects.FRONTEND).build());
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getSpanNames("frontend").execute())).isEmpty();
    }

    @Test
    public void getSpanNames_serviceNameGoesLowercase() throws IOException {
        this.accept(TestObjects.CLIENT_SPAN);
        Assertions.assertThat((List)((List)this.serviceAndSpanNames().getSpanNames("FrOnTeNd").execute())).containsExactly((Object[])new String[]{"get"});
    }

    protected void accept(List<Span> spans) throws IOException {
        this.storage().spanConsumer().accept(spans).execute();
    }

    protected void accept(Span ... spans) throws IOException {
        this.storage().spanConsumer().accept(Arrays.asList(spans)).execute();
    }
}

