/*
 * Decompiled with CFR 0.152.
 */
package zipkin2;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import zipkin2.Endpoint;
import zipkin2.Span;
import zipkin2.internal.WriteBuffer;

public final class TestObjects {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final long DAY = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS);
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final long TODAY = TestObjects.midnightUTC(System.currentTimeMillis());
    public static final Endpoint FRONTEND = Endpoint.newBuilder().serviceName("frontend").ip("127.0.0.1").build();
    public static final Endpoint BACKEND = Endpoint.newBuilder().serviceName("backend").ip("192.168.99.101").port(9000).build();
    public static final Endpoint DB = Endpoint.newBuilder().serviceName("db").ip("2001:db8::c001").port(3036).build();
    public static final Endpoint KAFKA = Endpoint.newBuilder().serviceName("kafka").build();
    public static final Span CLIENT_SPAN = Span.newBuilder().traceId("7180c278b62e8f6a216a2aea45d08fc9").parentId("1").id("2").name("get").kind(Span.Kind.CLIENT).localEndpoint(FRONTEND).remoteEndpoint(BACKEND).timestamp((TODAY + 50L) * 1000L).duration(200000L).addAnnotation((TODAY + 100L) * 1000L, "foo").putTag("http.path", "/api").putTag("clnt/finagle.version", "6.45.0").build();
    public static final List<Span> TRACE = TestObjects.newTrace(CLIENT_SPAN.traceId(), "");
    static final Span.Builder SPAN_BUILDER = TestObjects.newSpanBuilder();
    public static final Span[] LOTS_OF_SPANS = (Span[])new Random().longs(100000L).mapToObj(TestObjects::span).toArray(Span[]::new);

    public static long midnightUTC(long epochMillis) {
        Calendar day = Calendar.getInstance(UTC);
        day.setTimeInMillis(epochMillis);
        day.set(14, 0);
        day.set(13, 0);
        day.set(12, 0);
        day.set(11, 0);
        return day.getTimeInMillis();
    }

    public static long startTs(List<Span> trace) {
        return trace.get(0).timestampAsLong() / 1000L;
    }

    public static long endTs(List<Span> trace) {
        return TestObjects.startTs(trace) + trace.get(0).durationAsLong() / 1000L;
    }

    static Span.Builder newSpanBuilder() {
        return Span.newBuilder().name("get").timestamp(TODAY * 1000L + 100L).duration(200000L).localEndpoint(FRONTEND).putTag("environment", "test");
    }

    public static Span span(long traceId) {
        return SPAN_BUILDER.traceId(0L, traceId).id(traceId).build();
    }

    public static Span newClientSpan(String serviceNameSuffix) {
        return TestObjects.spanBuilder(serviceNameSuffix).kind(Span.Kind.CLIENT).remoteEndpoint(BACKEND.toBuilder().serviceName("backend" + serviceNameSuffix).build()).name("get /foo").clearTags().putTag("http.method", "GET").putTag("http.path", "/foo").build();
    }

    public static Span.Builder spanBuilder(String serviceNameSuffix) {
        Endpoint frontend = TestObjects.suffixServiceName(FRONTEND, serviceNameSuffix);
        return SPAN_BUILDER.clone().localEndpoint(frontend).traceId(TestObjects.newTraceId());
    }

    public static String appendSuffix(String serviceName, String serviceNameSuffix) {
        if (serviceNameSuffix == null) {
            throw new NullPointerException("serviceNameSuffix == null");
        }
        if (serviceNameSuffix.isEmpty()) {
            return serviceName;
        }
        return serviceName + "_" + serviceNameSuffix;
    }

    public static Endpoint suffixServiceName(Endpoint endpoint, String serviceNameSuffix) {
        String prefixed = TestObjects.appendSuffix(endpoint.serviceName(), serviceNameSuffix);
        if (endpoint.serviceName().equals(prefixed)) {
            return endpoint;
        }
        return endpoint.toBuilder().serviceName(prefixed).build();
    }

    public static List<Span> newTrace(String serviceNameSuffix) {
        return TestObjects.newTrace(TestObjects.newTraceId(), serviceNameSuffix);
    }

    static List<Span> newTrace(String traceId, String serviceNameSuffix) {
        Endpoint frontend = TestObjects.suffixServiceName(FRONTEND, serviceNameSuffix);
        Endpoint backend = TestObjects.suffixServiceName(BACKEND, serviceNameSuffix);
        Endpoint db = TestObjects.suffixServiceName(DB, serviceNameSuffix);
        return Arrays.asList(Span.newBuilder().traceId(traceId).id("1").name("get").kind(Span.Kind.SERVER).localEndpoint(frontend).timestamp(TODAY * 1000L).duration(350000L).build(), CLIENT_SPAN.toBuilder().traceId(traceId).localEndpoint(frontend).remoteEndpoint(backend).build(), Span.newBuilder().traceId(traceId).parentId(CLIENT_SPAN.parentId()).id(CLIENT_SPAN.id()).shared(true).name("get").kind(Span.Kind.SERVER).localEndpoint(backend).timestamp((TODAY + 100L) * 1000L).duration(150000L).build(), Span.newBuilder().traceId(traceId).parentId("2").id("3").name("query").kind(Span.Kind.CLIENT).localEndpoint(backend).remoteEndpoint(db).timestamp((TODAY + 150L) * 1000L).duration(50000L).addAnnotation((TODAY + 190L) * 1000L, "\u2ee9").putTag("error", "\ud83d\udca9").build());
    }

    public static String newTraceId() {
        byte[] traceId = new byte[32];
        WriteBuffer buffer = WriteBuffer.wrap((byte[])traceId);
        buffer.writeLongHex(ThreadLocalRandom.current().nextLong());
        buffer.writeLongHex(ThreadLocalRandom.current().nextLong());
        return new String(traceId, UTF_8);
    }
}

