/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.forceten.lookandfeel.impl;

import it.tidalwave.forceten.lookandfeel.LookAndFeel;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class LookAndFeelImpl
implements LookAndFeel {
    private static final String CLASS = LookAndFeelImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    @Override
    public void installDarkViewLAF(JComponent parent) {
        logger.info("installDarkViewLAF(" + parent + ")");
        JComponent view = LookAndFeelImpl.findView(parent);
        logger.fine(">>>>> view: " + view);
        if (view != null) {
            view.setFont(UIManager.getFont("it.tidalwave.openide.explorer.font"));
            view.setBackground(UIManager.getColor("it.tidalwave.forceten.explorer.background"));
            view.setForeground(UIManager.getColor("it.tidalwave.forceten.explorer.foreground"));
            view.putClientProperty("Tree.selectionForeground", UIManager.getColor("it.tidalwave.forceten.explorer.selectionForeground"));
            view.putClientProperty("Tree.selectionBackground", UIManager.getColor("it.tidalwave.forceten.explorer.selectionBackground"));
            this.installDarkLAF(view);
            Border border = UIManager.getBorder("it.tidalwave.openide.explorer.border");
            if (border != null) {
                view.setBorder(border);
            }
        }
    }

    private static JComponent findView(JComponent component) {
        logger.finer("findView(" + component + ")");
        if (LookAndFeelImpl.isView(component.getClass())) {
            return component;
        }
        for (Component child : component.getComponents()) {
            JComponent view;
            if (!(child instanceof JComponent) || (view = LookAndFeelImpl.findView((JComponent)child)) == null) continue;
            return view;
        }
        return null;
    }

    private static boolean isView(Class clazz) {
        logger.finer("isView(" + clazz + ")");
        String className = clazz.getName();
        if (className.equals("org.openide.explorer.view.ListView") || className.equals("org.openide.explorer.view.TreeView")) {
            return true;
        }
        if (clazz.getSuperclass() == null) {
            return false;
        }
        return LookAndFeelImpl.isView(clazz.getSuperclass());
    }

    @Override
    public void installHeaderUI(JPanel pnHeader) {
    }

    @Override
    public void installDarkLAF(Component c) {
    }
}

