/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.forceten.lookandfeel.impl;

import java.awt.Color;
import java.awt.Font;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.openide.modules.ModuleInstall;
import org.openide.util.Utilities;

public class LookAndFeelModule
extends ModuleInstall {
    private static final String CLASS = LookAndFeelModule.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final float FONT_HEADER_SCALE = 1.2307693f;
    private static final float FONT_HEADER_SMALL_SCALE = 1.0769231f;

    public void restored() {
        super.restored();
        logger.info("Installing look and feel...");
        if (Utilities.getOperatingSystem() == 4096) {
            this.installQuaqua();
            UIManager.put("DatePickerUI", "org.jdesktop.swingx.plaf.basic.BasicDatePickerUI");
        } else {
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
            this.installNimrod();
        }
        if (!Boolean.getBoolean("it.tidalwave.bluemarine.showtabs")) {
            this.installEmptyComponentTabs();
        }
        this.installFonts();
        this.installBlueMarineTheme();
        this.installBlackTheme();
    }

    private void installQuaqua() {
        if (!Boolean.getBoolean("it.tidalwave.bluemarine.disableQuaua")) {
            String lafClassName = "ch.randelshofer.quaqua.QuaquaLookAndFeel";
            this.installLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
            Object icon = LookAndFeel.makeIcon(((Object)((Object)this)).getClass(), "Icon-64.png");
            UIManager.put("OptionPane.errorIcon", icon);
            UIManager.put("OptionPane.informationIcon", icon);
            UIManager.put("OptionPane.questionIcon", icon);
            UIManager.put("OptionPane.warningIcon", icon);
        }
    }

    private void installNimbus() {
        this.installLookAndFeel("org.jdesktop.swingx.plaf.nimbus.NimbusLookAndFeel");
        UIManager.put("Nb.Toolbar.ui", "javax.swing.plaf.basic.BasicToolBarUI");
        this.installDefaultDarkUISettings();
    }

    private void installNimrod() {
        System.setProperty("nimrodlf.p1", "#808080");
        System.setProperty("nimrodlf.p2", "#a0a0a0");
        System.setProperty("nimrodlf.p3", "#c0c0c0");
        System.setProperty("nimrodlf.s1", "#525252");
        System.setProperty("nimrodlf.s2", "#5C5C5C");
        System.setProperty("nimrodlf.s3", "#666666");
        System.setProperty("nimrodlf.w", "#000000");
        System.setProperty("nimrodlf.b", "#FFFFFF");
        System.setProperty("nimrodlf.menuOpacity", "195");
        System.setProperty("nimrodlf.frameOpacity", "180");
        this.installLookAndFeel("com.nilo.plaf.nimrod.NimRODLookAndFeel");
        UIManager.put("Nb.Toolbar.ui", "javax.swing.plaf.basic.BasicToolBarUI");
        this.installDefaultDarkUISettings();
    }

    private void installLookAndFeel(String lafClassName) {
        try {
            UIManager.setLookAndFeel(lafClassName);
        }
        catch (Exception e) {
            logger.throwing(CLASS, "installLookAndFeel()", e);
        }
    }

    private void installEmptyComponentTabs() {
    }

    private void installBlueMarineTheme() {
        UIManager.put("it.tidalwave.forceten.desktop.background", new Color(100, 100, 100));
        UIManager.put("it.tidalwave.forceten.explorer.background", new Color(210, 210, 210));
        UIManager.put("it.tidalwave.forceten.explorer.foreground", new Color(40, 40, 40));
        UIManager.put("it.tidalwave.forceten.header.foreground", new Color(0, 0, 0));
        UIManager.put("it.tidalwave.forceten.header.background", new Color(185, 185, 185));
        UIManager.put("it.tidalwave.forceten.darkheader.foreground", new Color(140, 140, 140));
        UIManager.put("it.tidalwave.forceten.darkheader.foreground2", new Color(200, 200, 200));
        UIManager.put("it.tidalwave.forceten.darkheader.background", new Color(25, 25, 25));
    }

    private void installDefaultDarkUISettings() throws NumberFormatException {
        UIManager.put("List.background", Color.decode("#777777"));
        UIManager.put("Tree.background", Color.decode("#777777"));
        UIManager.put("Tree.textBackground", Color.decode("#777777"));
        UIManager.put("Table.background", Color.decode("#777777"));
        UIManager.put("TextField.background", Color.decode("#777777"));
        UIManager.put("EditorPane.background", Color.decode("#666666"));
        UIManager.put("EditorPane.foreground", Color.decode("#ffffff"));
        UIManager.put("TextPane.background", Color.decode("#666666"));
        UIManager.put("TextPane.foreground", Color.decode("#ffffff"));
        HTMLEditorKit editorKit = new HTMLEditorKit();
        StyleSheet defaultStyleSheet = editorKit.getStyleSheet();
        Style bodyStyle = defaultStyleSheet.getStyle("body");
        StyleConstants.setForeground(bodyStyle, Color.WHITE);
        StyleConstants.setFontFamily(bodyStyle, "sansserif");
        Style aStyle = defaultStyleSheet.getStyle("a");
        StyleConstants.setForeground(aStyle, Color.WHITE);
        StyleConstants.setBold(aStyle, true);
        StyleConstants.setUnderline(aStyle, false);
        StyleConstants.setItalic(aStyle, true);
    }

    private void installFonts() {
        Font font = UIManager.getFont("Tree.font");
        if (Utilities.getOperatingSystem() == 4096) {
            font = new Font("Lucida grande", 0, font.getSize());
        } else if (Utilities.getOperatingSystem() == 16) {
            font = new Font("Arial", 0, font.getSize());
        }
        if (font != null) {
            float scale = 0.9230769f;
            Font newFont = font.deriveFont(scale * font.getSize2D());
            UIManager.put("it.tidalwave.openide.explorer.font", newFont);
            UIManager.put("it.tidalwave.forceten.smallfont", newFont);
            UIManager.put("it.tidalwave.forceten.header.font", font.deriveFont(1.2307693f * font.getSize2D()));
            UIManager.put("it.tidalwave.forceten.header.smallfont", font.deriveFont(1.0769231f * font.getSize2D()));
        }
    }

    private void installBlackTheme() {
    }
}

