package it.tidalwave.image.metadata;

import javax.annotation.Nonnull;
import javax.annotation.Nonnegative;
import java.time.*;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import it.tidalwave.image.Rational;
import lombok.*;
import static java.util.Objects.requireNonNull;

/* Automatically generated on Thu Jan 19 18:29:30 CET 2023 - DO NOT EDIT! */

public class IPTCDirectoryGenerated extends Directory
  {
    private final static long serialVersionUID = 2056233055989339523L;

    public IPTCDirectoryGenerated()
      {
      }

    public IPTCDirectoryGenerated (final Instant latestModificationTime)
      {
        super(latestModificationTime);
      }

    public final static int C_APPLICATION_RECORD_VERSION = 0;
    public final static int C_OBJECT_TYPE_REFERENCE = 3;
    public final static int C_OBJECT_ATTRIBUTE_REFERENCE = 4;
    public final static int C_OBJECT_NAME = 5;
    public final static int C_EDIT_STATUS = 7;
    public final static int C_EDITORIAL_UPDATE = 8;
    public final static int C_URGENCY = 10;
    public final static int C_SUBJECT_REFERENCE = 12;
    public final static int C_CATEGORY = 15;
    public final static int C_SUPPLEMENTAL_CATEGORIES = 20;
    public final static int C_FIXTURE_IDENTIFIER = 22;
    public final static int C_KEYWORDS = 25;
    public final static int C_CONTENT_LOCATION_CODE = 26;
    public final static int C_CONTENT_LOCATION_NAME = 27;
    public final static int C_RELEASE_DATE = 30;
    public final static int C_RELEASE_TIME = 35;
    public final static int C_EXPIRATION_DATE = 37;
    public final static int C_EXPIRATION_TIME = 38;
    public final static int C_SPECIAL_INSTRUCTIONS = 40;
    public final static int C_ACTION_ADVISED = 42;
    public final static int C_REFERENCE_SERVICE = 45;
    public final static int C_REFERENCE_DATE = 47;
    public final static int C_REFERENCE_NUMBER = 50;
    public final static int C_DATE_CREATED = 55;
    public final static int C_TIME_CREATED = 60;
    public final static int C_DIGITAL_CREATION_DATE = 62;
    public final static int C_DIGITAL_CREATION_TIME = 63;
    public final static int C_ORIGINATING_PROGRAM = 65;
    public final static int C_PROGRAM_VERSION = 70;
    public final static int C_OBJECT_CYCLE = 75;
    public final static int C_BYLINE = 80;
    public final static int C_BYLINE_TITLE = 85;
    public final static int C_CITY = 90;
    public final static int C_SUBLOCATION = 92;
    public final static int C_PROVINCESTATE = 95;
    public final static int C_COUNTRYPRIMARY_LOCATION_CODE = 100;
    public final static int C_COUNTRYPRIMARY_LOCATION_NAME = 101;
    public final static int C_ORIGINAL_TRANSMISSION_REFERENCE = 103;
    public final static int C_HEADLINE = 105;
    public final static int C_CREDIT = 110;
    public final static int C_SOURCE = 115;
    public final static int C_COPYRIGHT_NOTICE = 116;
    public final static int C_CONTACT = 118;
    public final static int C_CAPTIONABSTRACT = 120;
    public final static int C_LOCAL_CAPTION = 121;
    public final static int C_WRITEREDITOR = 122;
    public final static int C_RASTERIZED_CAPTION = 125;
    public final static int C_IMAGE_TYPE = 130;
    public final static int C_IMAGE_ORIENTATION = 131;
    public final static int C_LANGUAGE_IDENTIFIER = 135;
    public final static int C_AUDIO_TYPE = 150;
    public final static int C_AUDIO_SAMPLING_RATE = 151;
    public final static int C_AUDIO_SAMPLING_RESOLUTION = 152;
    public final static int C_AUDIO_DURATION = 153;
    public final static int C_AUDIO_OUTCUE = 154;
    public final static int C_JOB_ID = 184;
    public final static int C_MASTER_DOCUMENT_ID = 185;
    public final static int C_SHORT_DOCUMENT_ID = 186;
    public final static int C_UNIQUE_DOCUMENT_ID = 187;
    public final static int C_OWNER_ID = 188;
    public final static int C_OBJECT_PREVIEW_FILE_FORMAT = 200;
    public final static int C_OBJECT_PREVIEW_FILE_VERSION = 201;
    public final static int C_OBJECT_PREVIEW_DATA = 202;
    public final static int C_PREFS = 221;
    public final static int C_CLASSIFY_STATE = 225;
    public final static int C_SIMILARITY_INDEX = 228;
    public final static int C_DOCUMENT_NOTES = 230;
    public final static int C_DOCUMENT_HISTORY = 231;
    public final static int C_EXIF_CAMERA_INFO = 232;
    public final static int C_ADOBE_CREATOR_ADDRESS = 100000;
    public final static int C_ADOBE_CREATOR_CITY = 100001;
    public final static int C_ADOBE_CREATOR_STATE__PROVINCE = 100002;
    public final static int C_ADOBE_CREATOR_POSTAL_CODE = 100003;
    public final static int C_ADOBE_CREATOR_COUNTRY = 100004;
    public final static int C_ADOBE_CREATOR_PHONE = 100005;
    public final static int C_ADOBE_CREATOR_EMAIL = 100006;
    public final static int C_ADOBE_CREATOR_WEBSITE = 100007;
    public final static int C_ADOBE_IPTC_SUBJECT_CODE = 100010;
    public final static int C_ADOBE_INTELLECTUAL_GENRE = 100020;
    public final static int C_ADOBE_SCENE = 100021;
    public final static int C_ADOBE_LOCATION = 100022;
    public final static int C_ADOBE_COUNTRY_ISO_CODE = 100023;
    public final static int C_ADOBE_COPYRIGHT_STATUS = 100030;
    public final static int C_ADOBE_RIGHT_USAGE_TERMS = 100031;
    public final static int C_ADOBE_COPYRIGHT_INFO_URL = 100032;

    public final static Tag<Integer> APPLICATION_RECORD_VERSION =
           Tag.of(0, "Application Record Version", "applicationRecordVersion", Integer.class);
    public final static Tag<String> OBJECT_TYPE_REFERENCE =
           Tag.of(3, "Object Type Reference", "objectTypeReference", String.class);
    public final static Tag<String> OBJECT_ATTRIBUTE_REFERENCE =
           Tag.of(4, "Object Attribute Reference", "objectAttributeReference", String.class);
    public final static Tag<String> OBJECT_NAME =
           Tag.of(5, "Object Name", "objectName", String.class);
    public final static Tag<String> EDIT_STATUS =
           Tag.of(7, "Edit Status", "editStatus", String.class);
    public final static Tag<String> EDITORIAL_UPDATE =
           Tag.of(8, "Editorial Update", "editorialUpdate", String.class);
    public final static Tag<String> URGENCY =
           Tag.of(10, "Urgency", "urgency", String.class);
    public final static Tag<String> SUBJECT_REFERENCE =
           Tag.of(12, "Subject Reference", "subjectReference", String.class);
    public final static Tag<String> CATEGORY =
           Tag.of(15, "Category", "category", String.class);
    public final static Tag<String> SUPPLEMENTAL_CATEGORIES =
           Tag.of(20, "Supplemental Categories", "supplementalCategories", String.class);
    public final static Tag<String> FIXTURE_IDENTIFIER =
           Tag.of(22, "Fixture Identifier", "fixtureIdentifier", String.class);
    public final static Tag<String> KEYWORDS =
           Tag.of(25, "Keywords", "keywords", String.class);
    public final static Tag<String> CONTENT_LOCATION_CODE =
           Tag.of(26, "Content Location Code", "contentLocationCode", String.class);
    public final static Tag<String> CONTENT_LOCATION_NAME =
           Tag.of(27, "Content Location Name", "contentLocationName", String.class);
    public final static Tag<String> RELEASE_DATE =
           Tag.of(30, "Release Date", "releaseDate", String.class);
    public final static Tag<String> RELEASE_TIME =
           Tag.of(35, "Release Time", "releaseTime", String.class);
    public final static Tag<String> EXPIRATION_DATE =
           Tag.of(37, "Expiration Date", "expirationDate", String.class);
    public final static Tag<String> EXPIRATION_TIME =
           Tag.of(38, "Expiration Time", "expirationTime", String.class);
    public final static Tag<String> SPECIAL_INSTRUCTIONS =
           Tag.of(40, "Special Instructions", "specialInstructions", String.class);
    public final static Tag<ActionAdvised> ACTION_ADVISED =
           Tag.of(42, "Action Advised", "actionAdvised", ActionAdvised.class);
    public final static Tag<String> REFERENCE_SERVICE =
           Tag.of(45, "Reference Service", "referenceService", String.class);
    public final static Tag<String> REFERENCE_DATE =
           Tag.of(47, "Reference Date", "referenceDate", String.class);
    public final static Tag<String> REFERENCE_NUMBER =
           Tag.of(50, "Reference Number", "referenceNumber", String.class);
    public final static Tag<String> DATE_CREATED =
           Tag.of(55, "Date Created", "dateCreated", String.class);
    public final static Tag<String> TIME_CREATED =
           Tag.of(60, "Time Created", "timeCreated", String.class);
    public final static Tag<String> DIGITAL_CREATION_DATE =
           Tag.of(62, "Digital Creation Date", "digitalCreationDate", String.class);
    public final static Tag<String> DIGITAL_CREATION_TIME =
           Tag.of(63, "Digital Creation Time", "digitalCreationTime", String.class);
    public final static Tag<String> ORIGINATING_PROGRAM =
           Tag.of(65, "Originating Program", "originatingProgram", String.class);
    public final static Tag<String> PROGRAM_VERSION =
           Tag.of(70, "Program Version", "programVersion", String.class);
    public final static Tag<String> OBJECT_CYCLE =
           Tag.of(75, "Object Cycle", "objectCycle", String.class);
    public final static Tag<String> BYLINE =
           Tag.of(80, "By-line", "byline", String.class);
    public final static Tag<String> BYLINE_TITLE =
           Tag.of(85, "By-line Title", "bylineTitle", String.class);
    public final static Tag<String> CITY =
           Tag.of(90, "City", "city", String.class);
    public final static Tag<String> SUBLOCATION =
           Tag.of(92, "Sub-location", "sublocation", String.class);
    public final static Tag<String> PROVINCESTATE =
           Tag.of(95, "Province-State", "provinceState", String.class);
    public final static Tag<String> COUNTRYPRIMARY_LOCATION_CODE =
           Tag.of(100, "Country-Primary Location Code", "countryPrimaryLocationCode", String.class);
    public final static Tag<String> COUNTRYPRIMARY_LOCATION_NAME =
           Tag.of(101, "Country-Primary Location Name", "countryPrimaryLocationName", String.class);
    public final static Tag<String> ORIGINAL_TRANSMISSION_REFERENCE =
           Tag.of(103, "Original Transmission Reference", "originalTransmissionReference", String.class);
    public final static Tag<String> HEADLINE =
           Tag.of(105, "Headline", "headline", String.class);
    public final static Tag<String> CREDIT =
           Tag.of(110, "Credit", "credit", String.class);
    public final static Tag<String> SOURCE =
           Tag.of(115, "Source", "source", String.class);
    public final static Tag<String> COPYRIGHT_NOTICE =
           Tag.of(116, "Copyright Notice", "copyrightNotice", String.class);
    public final static Tag<String> CONTACT =
           Tag.of(118, "Contact", "contact", String.class);
    public final static Tag<String> CAPTIONABSTRACT =
           Tag.of(120, "Caption-Abstract", "captionAbstract", String.class);
    public final static Tag<String> LOCAL_CAPTION =
           Tag.of(121, "Local Caption", "localCaption", String.class);
    public final static Tag<String> WRITEREDITOR =
           Tag.of(122, "Writer-Editor", "writerEditor", String.class);
    public final static Tag<String> RASTERIZED_CAPTION =
           Tag.of(125, "Rasterized Caption", "rasterizedCaption", String.class);
    public final static Tag<String> IMAGE_TYPE =
           Tag.of(130, "Image Type", "imageType", String.class);
    public final static Tag<String> IMAGE_ORIENTATION =
           Tag.of(131, "Image Orientation", "imageOrientation", String.class);
    public final static Tag<String> LANGUAGE_IDENTIFIER =
           Tag.of(135, "Language Identifier", "languageIdentifier", String.class);
    public final static Tag<String> AUDIO_TYPE =
           Tag.of(150, "Audio Type", "audioType", String.class);
    public final static Tag<String> AUDIO_SAMPLING_RATE =
           Tag.of(151, "Audio Sampling Rate", "audioSamplingRate", String.class);
    public final static Tag<String> AUDIO_SAMPLING_RESOLUTION =
           Tag.of(152, "Audio Sampling Resolution", "audioSamplingResolution", String.class);
    public final static Tag<String> AUDIO_DURATION =
           Tag.of(153, "Audio Duration", "audioDuration", String.class);
    public final static Tag<String> AUDIO_OUTCUE =
           Tag.of(154, "Audio Outcue", "audioOutcue", String.class);
    public final static Tag<String> JOB_ID =
           Tag.of(184, "Job ID", "jobID", String.class);
    public final static Tag<String> MASTER_DOCUMENT_ID =
           Tag.of(185, "Master Document ID", "masterDocumentID", String.class);
    public final static Tag<String> SHORT_DOCUMENT_ID =
           Tag.of(186, "Short Document ID", "shortDocumentID", String.class);
    public final static Tag<String> UNIQUE_DOCUMENT_ID =
           Tag.of(187, "Unique Document ID", "uniqueDocumentID", String.class);
    public final static Tag<String> OWNER_ID =
           Tag.of(188, "Owner ID", "ownerID", String.class);
    public final static Tag<ObjectPreviewFileFormat> OBJECT_PREVIEW_FILE_FORMAT =
           Tag.of(200, "Object Preview File Format", "objectPreviewFileFormat", ObjectPreviewFileFormat.class);
    public final static Tag<Integer> OBJECT_PREVIEW_FILE_VERSION =
           Tag.of(201, "Object Preview File Version", "objectPreviewFileVersion", Integer.class);
    public final static Tag<String> OBJECT_PREVIEW_DATA =
           Tag.of(202, "Object Preview Data", "objectPreviewData", String.class);
    public final static Tag<String> PREFS =
           Tag.of(221, "Prefs", "prefs", String.class);
    public final static Tag<String> CLASSIFY_STATE =
           Tag.of(225, "Classify State", "classifyState", String.class);
    public final static Tag<String> SIMILARITY_INDEX =
           Tag.of(228, "Similarity Index", "similarityIndex", String.class);
    public final static Tag<String> DOCUMENT_NOTES =
           Tag.of(230, "Document Notes", "documentNotes", String.class);
    public final static Tag<String> DOCUMENT_HISTORY =
           Tag.of(231, "Document History", "documentHistory", String.class);
    public final static Tag<String> EXIF_CAMERA_INFO =
           Tag.of(232, "EXIF Camera Info", "EXIFCameraInfo", String.class);
    public final static Tag<String> ADOBE_CREATOR_ADDRESS =
           Tag.of(100000, "Adobe Creator Address", "adobeCreatorAddress", String.class);
    public final static Tag<String> ADOBE_CREATOR_CITY =
           Tag.of(100001, "Adobe Creator City", "adobeCreatorCity", String.class);
    public final static Tag<String> ADOBE_CREATOR_STATE__PROVINCE =
           Tag.of(100002, "Adobe Creator State  Province", "adobeCreatorStateProvince", String.class);
    public final static Tag<String> ADOBE_CREATOR_POSTAL_CODE =
           Tag.of(100003, "Adobe Creator Postal Code", "adobeCreatorPostalCode", String.class);
    public final static Tag<String> ADOBE_CREATOR_COUNTRY =
           Tag.of(100004, "Adobe Creator Country", "adobeCreatorCountry", String.class);
    public final static Tag<String> ADOBE_CREATOR_PHONE =
           Tag.of(100005, "Adobe Creator Phone", "adobeCreatorPhone", String.class);
    public final static Tag<String> ADOBE_CREATOR_EMAIL =
           Tag.of(100006, "Adobe Creator Email", "adobeCreatorEmail", String.class);
    public final static Tag<String> ADOBE_CREATOR_WEBSITE =
           Tag.of(100007, "Adobe Creator Website", "adobeCreatorWebsite", String.class);
    public final static Tag<String> ADOBE_IPTC_SUBJECT_CODE =
           Tag.of(100010, "Adobe IPTC Subject Code", "adobeIPTCSubjectCode", String.class);
    public final static Tag<String> ADOBE_INTELLECTUAL_GENRE =
           Tag.of(100020, "Adobe Intellectual Genre", "adobeIntellectualGenre", String.class);
    public final static Tag<String> ADOBE_SCENE =
           Tag.of(100021, "Adobe Scene", "adobeScene", String.class);
    public final static Tag<String> ADOBE_LOCATION =
           Tag.of(100022, "Adobe Location", "adobeLocation", String.class);
    public final static Tag<String> ADOBE_COUNTRY_ISO_CODE =
           Tag.of(100023, "Adobe Country ISO Code", "adobeCountryISOCode", String.class);
    public final static Tag<String> ADOBE_COPYRIGHT_STATUS =
           Tag.of(100030, "Adobe Copyright Status", "adobeCopyrightStatus", String.class);
    public final static Tag<String> ADOBE_RIGHT_USAGE_TERMS =
           Tag.of(100031, "Adobe Right Usage Terms", "adobeRightUsageTerms", String.class);
    public final static Tag<String> ADOBE_COPYRIGHT_INFO_URL =
           Tag.of(100032, "Adobe Copyright Info URL", "adobeCopyrightInfoURL", String.class);

    static
      {
        tagMapByCode.put("IPTCDirectoryGenerated.0", APPLICATION_RECORD_VERSION);
        tagMapByCode.put("IPTCDirectoryGenerated.3", OBJECT_TYPE_REFERENCE);
        tagMapByCode.put("IPTCDirectoryGenerated.4", OBJECT_ATTRIBUTE_REFERENCE);
        tagMapByCode.put("IPTCDirectoryGenerated.5", OBJECT_NAME);
        tagMapByCode.put("IPTCDirectoryGenerated.7", EDIT_STATUS);
        tagMapByCode.put("IPTCDirectoryGenerated.8", EDITORIAL_UPDATE);
        tagMapByCode.put("IPTCDirectoryGenerated.10", URGENCY);
        tagMapByCode.put("IPTCDirectoryGenerated.12", SUBJECT_REFERENCE);
        tagMapByCode.put("IPTCDirectoryGenerated.15", CATEGORY);
        tagMapByCode.put("IPTCDirectoryGenerated.20", SUPPLEMENTAL_CATEGORIES);
        tagMapByCode.put("IPTCDirectoryGenerated.22", FIXTURE_IDENTIFIER);
        tagMapByCode.put("IPTCDirectoryGenerated.25", KEYWORDS);
        tagMapByCode.put("IPTCDirectoryGenerated.26", CONTENT_LOCATION_CODE);
        tagMapByCode.put("IPTCDirectoryGenerated.27", CONTENT_LOCATION_NAME);
        tagMapByCode.put("IPTCDirectoryGenerated.30", RELEASE_DATE);
        tagMapByCode.put("IPTCDirectoryGenerated.35", RELEASE_TIME);
        tagMapByCode.put("IPTCDirectoryGenerated.37", EXPIRATION_DATE);
        tagMapByCode.put("IPTCDirectoryGenerated.38", EXPIRATION_TIME);
        tagMapByCode.put("IPTCDirectoryGenerated.40", SPECIAL_INSTRUCTIONS);
        tagMapByCode.put("IPTCDirectoryGenerated.42", ACTION_ADVISED);
        tagMapByCode.put("IPTCDirectoryGenerated.45", REFERENCE_SERVICE);
        tagMapByCode.put("IPTCDirectoryGenerated.47", REFERENCE_DATE);
        tagMapByCode.put("IPTCDirectoryGenerated.50", REFERENCE_NUMBER);
        tagMapByCode.put("IPTCDirectoryGenerated.55", DATE_CREATED);
        tagMapByCode.put("IPTCDirectoryGenerated.60", TIME_CREATED);
        tagMapByCode.put("IPTCDirectoryGenerated.62", DIGITAL_CREATION_DATE);
        tagMapByCode.put("IPTCDirectoryGenerated.63", DIGITAL_CREATION_TIME);
        tagMapByCode.put("IPTCDirectoryGenerated.65", ORIGINATING_PROGRAM);
        tagMapByCode.put("IPTCDirectoryGenerated.70", PROGRAM_VERSION);
        tagMapByCode.put("IPTCDirectoryGenerated.75", OBJECT_CYCLE);
        tagMapByCode.put("IPTCDirectoryGenerated.80", BYLINE);
        tagMapByCode.put("IPTCDirectoryGenerated.85", BYLINE_TITLE);
        tagMapByCode.put("IPTCDirectoryGenerated.90", CITY);
        tagMapByCode.put("IPTCDirectoryGenerated.92", SUBLOCATION);
        tagMapByCode.put("IPTCDirectoryGenerated.95", PROVINCESTATE);
        tagMapByCode.put("IPTCDirectoryGenerated.100", COUNTRYPRIMARY_LOCATION_CODE);
        tagMapByCode.put("IPTCDirectoryGenerated.101", COUNTRYPRIMARY_LOCATION_NAME);
        tagMapByCode.put("IPTCDirectoryGenerated.103", ORIGINAL_TRANSMISSION_REFERENCE);
        tagMapByCode.put("IPTCDirectoryGenerated.105", HEADLINE);
        tagMapByCode.put("IPTCDirectoryGenerated.110", CREDIT);
        tagMapByCode.put("IPTCDirectoryGenerated.115", SOURCE);
        tagMapByCode.put("IPTCDirectoryGenerated.116", COPYRIGHT_NOTICE);
        tagMapByCode.put("IPTCDirectoryGenerated.118", CONTACT);
        tagMapByCode.put("IPTCDirectoryGenerated.120", CAPTIONABSTRACT);
        tagMapByCode.put("IPTCDirectoryGenerated.121", LOCAL_CAPTION);
        tagMapByCode.put("IPTCDirectoryGenerated.122", WRITEREDITOR);
        tagMapByCode.put("IPTCDirectoryGenerated.125", RASTERIZED_CAPTION);
        tagMapByCode.put("IPTCDirectoryGenerated.130", IMAGE_TYPE);
        tagMapByCode.put("IPTCDirectoryGenerated.131", IMAGE_ORIENTATION);
        tagMapByCode.put("IPTCDirectoryGenerated.135", LANGUAGE_IDENTIFIER);
        tagMapByCode.put("IPTCDirectoryGenerated.150", AUDIO_TYPE);
        tagMapByCode.put("IPTCDirectoryGenerated.151", AUDIO_SAMPLING_RATE);
        tagMapByCode.put("IPTCDirectoryGenerated.152", AUDIO_SAMPLING_RESOLUTION);
        tagMapByCode.put("IPTCDirectoryGenerated.153", AUDIO_DURATION);
        tagMapByCode.put("IPTCDirectoryGenerated.154", AUDIO_OUTCUE);
        tagMapByCode.put("IPTCDirectoryGenerated.184", JOB_ID);
        tagMapByCode.put("IPTCDirectoryGenerated.185", MASTER_DOCUMENT_ID);
        tagMapByCode.put("IPTCDirectoryGenerated.186", SHORT_DOCUMENT_ID);
        tagMapByCode.put("IPTCDirectoryGenerated.187", UNIQUE_DOCUMENT_ID);
        tagMapByCode.put("IPTCDirectoryGenerated.188", OWNER_ID);
        tagMapByCode.put("IPTCDirectoryGenerated.200", OBJECT_PREVIEW_FILE_FORMAT);
        tagMapByCode.put("IPTCDirectoryGenerated.201", OBJECT_PREVIEW_FILE_VERSION);
        tagMapByCode.put("IPTCDirectoryGenerated.202", OBJECT_PREVIEW_DATA);
        tagMapByCode.put("IPTCDirectoryGenerated.221", PREFS);
        tagMapByCode.put("IPTCDirectoryGenerated.225", CLASSIFY_STATE);
        tagMapByCode.put("IPTCDirectoryGenerated.228", SIMILARITY_INDEX);
        tagMapByCode.put("IPTCDirectoryGenerated.230", DOCUMENT_NOTES);
        tagMapByCode.put("IPTCDirectoryGenerated.231", DOCUMENT_HISTORY);
        tagMapByCode.put("IPTCDirectoryGenerated.232", EXIF_CAMERA_INFO);
        tagMapByCode.put("IPTCDirectoryGenerated.100000", ADOBE_CREATOR_ADDRESS);
        tagMapByCode.put("IPTCDirectoryGenerated.100001", ADOBE_CREATOR_CITY);
        tagMapByCode.put("IPTCDirectoryGenerated.100002", ADOBE_CREATOR_STATE__PROVINCE);
        tagMapByCode.put("IPTCDirectoryGenerated.100003", ADOBE_CREATOR_POSTAL_CODE);
        tagMapByCode.put("IPTCDirectoryGenerated.100004", ADOBE_CREATOR_COUNTRY);
        tagMapByCode.put("IPTCDirectoryGenerated.100005", ADOBE_CREATOR_PHONE);
        tagMapByCode.put("IPTCDirectoryGenerated.100006", ADOBE_CREATOR_EMAIL);
        tagMapByCode.put("IPTCDirectoryGenerated.100007", ADOBE_CREATOR_WEBSITE);
        tagMapByCode.put("IPTCDirectoryGenerated.100010", ADOBE_IPTC_SUBJECT_CODE);
        tagMapByCode.put("IPTCDirectoryGenerated.100020", ADOBE_INTELLECTUAL_GENRE);
        tagMapByCode.put("IPTCDirectoryGenerated.100021", ADOBE_SCENE);
        tagMapByCode.put("IPTCDirectoryGenerated.100022", ADOBE_LOCATION);
        tagMapByCode.put("IPTCDirectoryGenerated.100023", ADOBE_COUNTRY_ISO_CODE);
        tagMapByCode.put("IPTCDirectoryGenerated.100030", ADOBE_COPYRIGHT_STATUS);
        tagMapByCode.put("IPTCDirectoryGenerated.100031", ADOBE_RIGHT_USAGE_TERMS);
        tagMapByCode.put("IPTCDirectoryGenerated.100032", ADOBE_COPYRIGHT_INFO_URL);

      }
    /*******************************************************************************************************************
     *
     * Sets the property {@code APPLICATION_RECORD_VERSION}. If the value is changed, property change events will be fired
     * for {@code "applicationRecordVersion"} and {@code "latestModificationTime}.
     *
     * @param   applicationRecordVersion     the new value of {@code APPLICATION_RECORD_VERSION}
     *
     ******************************************************************************************************************/
    public void setApplicationRecordVersion (@Nonnull final Integer applicationRecordVersion)
      {
        requireNonNull(applicationRecordVersion, "applicationRecordVersion");
        setApplicationRecordVersion(Optional.of(applicationRecordVersion));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code APPLICATION_RECORD_VERSION}. If the value is changed, property change events will be fired
     * for {@code "applicationRecordVersion"} and {@code "latestModificationTime}.
     *
     * @param   applicationRecordVersion     the new value of {@code APPLICATION_RECORD_VERSION}
     *
     ******************************************************************************************************************/
    public void setApplicationRecordVersion (@Nonnull final Optional<Integer> applicationRecordVersion)
      {
        requireNonNull(applicationRecordVersion, "applicationRecordVersion");
        set(IPTCDirectoryGenerated.APPLICATION_RECORD_VERSION, applicationRecordVersion);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code APPLICATION_RECORD_VERSION}.
     *
     * @return  the current value of applicationRecordVersion
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<Integer> getApplicationRecordVersion()
      {
        return get(APPLICATION_RECORD_VERSION, Integer.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_TYPE_REFERENCE}. If the value is changed, property change events will be fired
     * for {@code "objectTypeReference"} and {@code "latestModificationTime}.
     *
     * @param   objectTypeReference     the new value of {@code OBJECT_TYPE_REFERENCE}
     *
     ******************************************************************************************************************/
    public void setObjectTypeReference (@Nonnull final String objectTypeReference)
      {
        requireNonNull(objectTypeReference, "objectTypeReference");
        setObjectTypeReference(Optional.of(objectTypeReference));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_TYPE_REFERENCE}. If the value is changed, property change events will be fired
     * for {@code "objectTypeReference"} and {@code "latestModificationTime}.
     *
     * @param   objectTypeReference     the new value of {@code OBJECT_TYPE_REFERENCE}
     *
     ******************************************************************************************************************/
    public void setObjectTypeReference (@Nonnull final Optional<String> objectTypeReference)
      {
        requireNonNull(objectTypeReference, "objectTypeReference");
        set(IPTCDirectoryGenerated.OBJECT_TYPE_REFERENCE, objectTypeReference);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code OBJECT_TYPE_REFERENCE}.
     *
     * @return  the current value of objectTypeReference
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getObjectTypeReference()
      {
        return get(OBJECT_TYPE_REFERENCE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_ATTRIBUTE_REFERENCE}. If the value is changed, property change events will be fired
     * for {@code "objectAttributeReference"} and {@code "latestModificationTime}.
     *
     * @param   objectAttributeReference     the new value of {@code OBJECT_ATTRIBUTE_REFERENCE}
     *
     ******************************************************************************************************************/
    public void setObjectAttributeReference (@Nonnull final String objectAttributeReference)
      {
        requireNonNull(objectAttributeReference, "objectAttributeReference");
        setObjectAttributeReference(Optional.of(objectAttributeReference));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_ATTRIBUTE_REFERENCE}. If the value is changed, property change events will be fired
     * for {@code "objectAttributeReference"} and {@code "latestModificationTime}.
     *
     * @param   objectAttributeReference     the new value of {@code OBJECT_ATTRIBUTE_REFERENCE}
     *
     ******************************************************************************************************************/
    public void setObjectAttributeReference (@Nonnull final Optional<String> objectAttributeReference)
      {
        requireNonNull(objectAttributeReference, "objectAttributeReference");
        set(IPTCDirectoryGenerated.OBJECT_ATTRIBUTE_REFERENCE, objectAttributeReference);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code OBJECT_ATTRIBUTE_REFERENCE}.
     *
     * @return  the current value of objectAttributeReference
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getObjectAttributeReference()
      {
        return get(OBJECT_ATTRIBUTE_REFERENCE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_NAME}. If the value is changed, property change events will be fired
     * for {@code "objectName"} and {@code "latestModificationTime}.
     *
     * @param   objectName     the new value of {@code OBJECT_NAME}
     *
     ******************************************************************************************************************/
    public void setObjectName (@Nonnull final String objectName)
      {
        requireNonNull(objectName, "objectName");
        setObjectName(Optional.of(objectName));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_NAME}. If the value is changed, property change events will be fired
     * for {@code "objectName"} and {@code "latestModificationTime}.
     *
     * @param   objectName     the new value of {@code OBJECT_NAME}
     *
     ******************************************************************************************************************/
    public void setObjectName (@Nonnull final Optional<String> objectName)
      {
        requireNonNull(objectName, "objectName");
        set(IPTCDirectoryGenerated.OBJECT_NAME, objectName);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code OBJECT_NAME}.
     *
     * @return  the current value of objectName
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getObjectName()
      {
        return get(OBJECT_NAME, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EDIT_STATUS}. If the value is changed, property change events will be fired
     * for {@code "editStatus"} and {@code "latestModificationTime}.
     *
     * @param   editStatus     the new value of {@code EDIT_STATUS}
     *
     ******************************************************************************************************************/
    public void setEditStatus (@Nonnull final String editStatus)
      {
        requireNonNull(editStatus, "editStatus");
        setEditStatus(Optional.of(editStatus));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EDIT_STATUS}. If the value is changed, property change events will be fired
     * for {@code "editStatus"} and {@code "latestModificationTime}.
     *
     * @param   editStatus     the new value of {@code EDIT_STATUS}
     *
     ******************************************************************************************************************/
    public void setEditStatus (@Nonnull final Optional<String> editStatus)
      {
        requireNonNull(editStatus, "editStatus");
        set(IPTCDirectoryGenerated.EDIT_STATUS, editStatus);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code EDIT_STATUS}.
     *
     * @return  the current value of editStatus
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getEditStatus()
      {
        return get(EDIT_STATUS, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EDITORIAL_UPDATE}. If the value is changed, property change events will be fired
     * for {@code "editorialUpdate"} and {@code "latestModificationTime}.
     *
     * @param   editorialUpdate     the new value of {@code EDITORIAL_UPDATE}
     *
     ******************************************************************************************************************/
    public void setEditorialUpdate (@Nonnull final String editorialUpdate)
      {
        requireNonNull(editorialUpdate, "editorialUpdate");
        setEditorialUpdate(Optional.of(editorialUpdate));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EDITORIAL_UPDATE}. If the value is changed, property change events will be fired
     * for {@code "editorialUpdate"} and {@code "latestModificationTime}.
     *
     * @param   editorialUpdate     the new value of {@code EDITORIAL_UPDATE}
     *
     ******************************************************************************************************************/
    public void setEditorialUpdate (@Nonnull final Optional<String> editorialUpdate)
      {
        requireNonNull(editorialUpdate, "editorialUpdate");
        set(IPTCDirectoryGenerated.EDITORIAL_UPDATE, editorialUpdate);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code EDITORIAL_UPDATE}.
     *
     * @return  the current value of editorialUpdate
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getEditorialUpdate()
      {
        return get(EDITORIAL_UPDATE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code URGENCY}. If the value is changed, property change events will be fired
     * for {@code "urgency"} and {@code "latestModificationTime}.
     *
     * @param   urgency     the new value of {@code URGENCY}
     *
     ******************************************************************************************************************/
    public void setUrgency (@Nonnull final String urgency)
      {
        requireNonNull(urgency, "urgency");
        setUrgency(Optional.of(urgency));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code URGENCY}. If the value is changed, property change events will be fired
     * for {@code "urgency"} and {@code "latestModificationTime}.
     *
     * @param   urgency     the new value of {@code URGENCY}
     *
     ******************************************************************************************************************/
    public void setUrgency (@Nonnull final Optional<String> urgency)
      {
        requireNonNull(urgency, "urgency");
        set(IPTCDirectoryGenerated.URGENCY, urgency);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code URGENCY}.
     *
     * @return  the current value of urgency
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getUrgency()
      {
        return get(URGENCY, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SUBJECT_REFERENCE}. If the value is changed, property change events will be fired
     * for {@code "subjectReference"} and {@code "latestModificationTime}.
     *
     * @param   subjectReference     the new value of {@code SUBJECT_REFERENCE}
     *
     ******************************************************************************************************************/
    public void setSubjectReference (@Nonnull final String subjectReference)
      {
        requireNonNull(subjectReference, "subjectReference");
        setSubjectReference(Optional.of(subjectReference));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SUBJECT_REFERENCE}. If the value is changed, property change events will be fired
     * for {@code "subjectReference"} and {@code "latestModificationTime}.
     *
     * @param   subjectReference     the new value of {@code SUBJECT_REFERENCE}
     *
     ******************************************************************************************************************/
    public void setSubjectReference (@Nonnull final Optional<String> subjectReference)
      {
        requireNonNull(subjectReference, "subjectReference");
        set(IPTCDirectoryGenerated.SUBJECT_REFERENCE, subjectReference);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code SUBJECT_REFERENCE}.
     *
     * @return  the current value of subjectReference
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getSubjectReference()
      {
        return get(SUBJECT_REFERENCE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CATEGORY}. If the value is changed, property change events will be fired
     * for {@code "category"} and {@code "latestModificationTime}.
     *
     * @param   category     the new value of {@code CATEGORY}
     *
     ******************************************************************************************************************/
    public void setCategory (@Nonnull final String category)
      {
        requireNonNull(category, "category");
        setCategory(Optional.of(category));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CATEGORY}. If the value is changed, property change events will be fired
     * for {@code "category"} and {@code "latestModificationTime}.
     *
     * @param   category     the new value of {@code CATEGORY}
     *
     ******************************************************************************************************************/
    public void setCategory (@Nonnull final Optional<String> category)
      {
        requireNonNull(category, "category");
        set(IPTCDirectoryGenerated.CATEGORY, category);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code CATEGORY}.
     *
     * @return  the current value of category
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getCategory()
      {
        return get(CATEGORY, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SUPPLEMENTAL_CATEGORIES}. If the value is changed, property change events will be fired
     * for {@code "supplementalCategories"} and {@code "latestModificationTime}.
     *
     * @param   supplementalCategories     the new value of {@code SUPPLEMENTAL_CATEGORIES}
     *
     ******************************************************************************************************************/
    public void setSupplementalCategories (@Nonnull final String supplementalCategories)
      {
        requireNonNull(supplementalCategories, "supplementalCategories");
        setSupplementalCategories(Optional.of(supplementalCategories));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SUPPLEMENTAL_CATEGORIES}. If the value is changed, property change events will be fired
     * for {@code "supplementalCategories"} and {@code "latestModificationTime}.
     *
     * @param   supplementalCategories     the new value of {@code SUPPLEMENTAL_CATEGORIES}
     *
     ******************************************************************************************************************/
    public void setSupplementalCategories (@Nonnull final Optional<String> supplementalCategories)
      {
        requireNonNull(supplementalCategories, "supplementalCategories");
        set(IPTCDirectoryGenerated.SUPPLEMENTAL_CATEGORIES, supplementalCategories);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code SUPPLEMENTAL_CATEGORIES}.
     *
     * @return  the current value of supplementalCategories
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getSupplementalCategories()
      {
        return get(SUPPLEMENTAL_CATEGORIES, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code FIXTURE_IDENTIFIER}. If the value is changed, property change events will be fired
     * for {@code "fixtureIdentifier"} and {@code "latestModificationTime}.
     *
     * @param   fixtureIdentifier     the new value of {@code FIXTURE_IDENTIFIER}
     *
     ******************************************************************************************************************/
    public void setFixtureIdentifier (@Nonnull final String fixtureIdentifier)
      {
        requireNonNull(fixtureIdentifier, "fixtureIdentifier");
        setFixtureIdentifier(Optional.of(fixtureIdentifier));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code FIXTURE_IDENTIFIER}. If the value is changed, property change events will be fired
     * for {@code "fixtureIdentifier"} and {@code "latestModificationTime}.
     *
     * @param   fixtureIdentifier     the new value of {@code FIXTURE_IDENTIFIER}
     *
     ******************************************************************************************************************/
    public void setFixtureIdentifier (@Nonnull final Optional<String> fixtureIdentifier)
      {
        requireNonNull(fixtureIdentifier, "fixtureIdentifier");
        set(IPTCDirectoryGenerated.FIXTURE_IDENTIFIER, fixtureIdentifier);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code FIXTURE_IDENTIFIER}.
     *
     * @return  the current value of fixtureIdentifier
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getFixtureIdentifier()
      {
        return get(FIXTURE_IDENTIFIER, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code KEYWORDS}. If the value is changed, property change events will be fired
     * for {@code "keywords"} and {@code "latestModificationTime}.
     *
     * @param   keywords     the new value of {@code KEYWORDS}
     *
     ******************************************************************************************************************/
    public void setKeywords (@Nonnull final String keywords)
      {
        requireNonNull(keywords, "keywords");
        setKeywords(Optional.of(keywords));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code KEYWORDS}. If the value is changed, property change events will be fired
     * for {@code "keywords"} and {@code "latestModificationTime}.
     *
     * @param   keywords     the new value of {@code KEYWORDS}
     *
     ******************************************************************************************************************/
    public void setKeywords (@Nonnull final Optional<String> keywords)
      {
        requireNonNull(keywords, "keywords");
        set(IPTCDirectoryGenerated.KEYWORDS, keywords);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code KEYWORDS}.
     *
     * @return  the current value of keywords
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getKeywords()
      {
        return get(KEYWORDS, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CONTENT_LOCATION_CODE}. If the value is changed, property change events will be fired
     * for {@code "contentLocationCode"} and {@code "latestModificationTime}.
     *
     * @param   contentLocationCode     the new value of {@code CONTENT_LOCATION_CODE}
     *
     ******************************************************************************************************************/
    public void setContentLocationCode (@Nonnull final String contentLocationCode)
      {
        requireNonNull(contentLocationCode, "contentLocationCode");
        setContentLocationCode(Optional.of(contentLocationCode));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CONTENT_LOCATION_CODE}. If the value is changed, property change events will be fired
     * for {@code "contentLocationCode"} and {@code "latestModificationTime}.
     *
     * @param   contentLocationCode     the new value of {@code CONTENT_LOCATION_CODE}
     *
     ******************************************************************************************************************/
    public void setContentLocationCode (@Nonnull final Optional<String> contentLocationCode)
      {
        requireNonNull(contentLocationCode, "contentLocationCode");
        set(IPTCDirectoryGenerated.CONTENT_LOCATION_CODE, contentLocationCode);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code CONTENT_LOCATION_CODE}.
     *
     * @return  the current value of contentLocationCode
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getContentLocationCode()
      {
        return get(CONTENT_LOCATION_CODE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CONTENT_LOCATION_NAME}. If the value is changed, property change events will be fired
     * for {@code "contentLocationName"} and {@code "latestModificationTime}.
     *
     * @param   contentLocationName     the new value of {@code CONTENT_LOCATION_NAME}
     *
     ******************************************************************************************************************/
    public void setContentLocationName (@Nonnull final String contentLocationName)
      {
        requireNonNull(contentLocationName, "contentLocationName");
        setContentLocationName(Optional.of(contentLocationName));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CONTENT_LOCATION_NAME}. If the value is changed, property change events will be fired
     * for {@code "contentLocationName"} and {@code "latestModificationTime}.
     *
     * @param   contentLocationName     the new value of {@code CONTENT_LOCATION_NAME}
     *
     ******************************************************************************************************************/
    public void setContentLocationName (@Nonnull final Optional<String> contentLocationName)
      {
        requireNonNull(contentLocationName, "contentLocationName");
        set(IPTCDirectoryGenerated.CONTENT_LOCATION_NAME, contentLocationName);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code CONTENT_LOCATION_NAME}.
     *
     * @return  the current value of contentLocationName
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getContentLocationName()
      {
        return get(CONTENT_LOCATION_NAME, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code RELEASE_DATE}. If the value is changed, property change events will be fired
     * for {@code "releaseDate"} and {@code "latestModificationTime}.
     *
     * @param   releaseDate     the new value of {@code RELEASE_DATE}
     *
     ******************************************************************************************************************/
    public void setReleaseDate (@Nonnull final String releaseDate)
      {
        requireNonNull(releaseDate, "releaseDate");
        setReleaseDate(Optional.of(releaseDate));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code RELEASE_DATE}. If the value is changed, property change events will be fired
     * for {@code "releaseDate"} and {@code "latestModificationTime}.
     *
     * @param   releaseDate     the new value of {@code RELEASE_DATE}
     *
     ******************************************************************************************************************/
    public void setReleaseDate (@Nonnull final Optional<String> releaseDate)
      {
        requireNonNull(releaseDate, "releaseDate");
        set(IPTCDirectoryGenerated.RELEASE_DATE, releaseDate);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code RELEASE_DATE}.
     *
     * @return  the current value of releaseDate
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getReleaseDate()
      {
        return get(RELEASE_DATE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code RELEASE_TIME}. If the value is changed, property change events will be fired
     * for {@code "releaseTime"} and {@code "latestModificationTime}.
     *
     * @param   releaseTime     the new value of {@code RELEASE_TIME}
     *
     ******************************************************************************************************************/
    public void setReleaseTime (@Nonnull final String releaseTime)
      {
        requireNonNull(releaseTime, "releaseTime");
        setReleaseTime(Optional.of(releaseTime));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code RELEASE_TIME}. If the value is changed, property change events will be fired
     * for {@code "releaseTime"} and {@code "latestModificationTime}.
     *
     * @param   releaseTime     the new value of {@code RELEASE_TIME}
     *
     ******************************************************************************************************************/
    public void setReleaseTime (@Nonnull final Optional<String> releaseTime)
      {
        requireNonNull(releaseTime, "releaseTime");
        set(IPTCDirectoryGenerated.RELEASE_TIME, releaseTime);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code RELEASE_TIME}.
     *
     * @return  the current value of releaseTime
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getReleaseTime()
      {
        return get(RELEASE_TIME, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EXPIRATION_DATE}. If the value is changed, property change events will be fired
     * for {@code "expirationDate"} and {@code "latestModificationTime}.
     *
     * @param   expirationDate     the new value of {@code EXPIRATION_DATE}
     *
     ******************************************************************************************************************/
    public void setExpirationDate (@Nonnull final String expirationDate)
      {
        requireNonNull(expirationDate, "expirationDate");
        setExpirationDate(Optional.of(expirationDate));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EXPIRATION_DATE}. If the value is changed, property change events will be fired
     * for {@code "expirationDate"} and {@code "latestModificationTime}.
     *
     * @param   expirationDate     the new value of {@code EXPIRATION_DATE}
     *
     ******************************************************************************************************************/
    public void setExpirationDate (@Nonnull final Optional<String> expirationDate)
      {
        requireNonNull(expirationDate, "expirationDate");
        set(IPTCDirectoryGenerated.EXPIRATION_DATE, expirationDate);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code EXPIRATION_DATE}.
     *
     * @return  the current value of expirationDate
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getExpirationDate()
      {
        return get(EXPIRATION_DATE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EXPIRATION_TIME}. If the value is changed, property change events will be fired
     * for {@code "expirationTime"} and {@code "latestModificationTime}.
     *
     * @param   expirationTime     the new value of {@code EXPIRATION_TIME}
     *
     ******************************************************************************************************************/
    public void setExpirationTime (@Nonnull final String expirationTime)
      {
        requireNonNull(expirationTime, "expirationTime");
        setExpirationTime(Optional.of(expirationTime));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EXPIRATION_TIME}. If the value is changed, property change events will be fired
     * for {@code "expirationTime"} and {@code "latestModificationTime}.
     *
     * @param   expirationTime     the new value of {@code EXPIRATION_TIME}
     *
     ******************************************************************************************************************/
    public void setExpirationTime (@Nonnull final Optional<String> expirationTime)
      {
        requireNonNull(expirationTime, "expirationTime");
        set(IPTCDirectoryGenerated.EXPIRATION_TIME, expirationTime);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code EXPIRATION_TIME}.
     *
     * @return  the current value of expirationTime
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getExpirationTime()
      {
        return get(EXPIRATION_TIME, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SPECIAL_INSTRUCTIONS}. If the value is changed, property change events will be fired
     * for {@code "specialInstructions"} and {@code "latestModificationTime}.
     *
     * @param   specialInstructions     the new value of {@code SPECIAL_INSTRUCTIONS}
     *
     ******************************************************************************************************************/
    public void setSpecialInstructions (@Nonnull final String specialInstructions)
      {
        requireNonNull(specialInstructions, "specialInstructions");
        setSpecialInstructions(Optional.of(specialInstructions));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SPECIAL_INSTRUCTIONS}. If the value is changed, property change events will be fired
     * for {@code "specialInstructions"} and {@code "latestModificationTime}.
     *
     * @param   specialInstructions     the new value of {@code SPECIAL_INSTRUCTIONS}
     *
     ******************************************************************************************************************/
    public void setSpecialInstructions (@Nonnull final Optional<String> specialInstructions)
      {
        requireNonNull(specialInstructions, "specialInstructions");
        set(IPTCDirectoryGenerated.SPECIAL_INSTRUCTIONS, specialInstructions);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code SPECIAL_INSTRUCTIONS}.
     *
     * @return  the current value of specialInstructions
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getSpecialInstructions()
      {
        return get(SPECIAL_INSTRUCTIONS, String.class);
      }

    /*******************************************************************************************************************
     *
     * Enumeration for representing the possible values of tag ActionAdvised.
     *
     ******************************************************************************************************************/
    @RequiredArgsConstructor(access = AccessLevel.PRIVATE) @Getter
    public static enum ActionAdvised
       {
                  OBJECT_KILL(1, "Object Kill"),
          OBJECT_REPLACE(2, "Object Replace"),
          OBJECT_APPEND(3, "Object Append"),
          OBJECT_REFERENCE(4, "Object Reference"),
          
         _UNKNOWN(-1, "_unknown_");

         private final static long serialVersionUID = 3059468666726854749L;
         private final int value;
         private final String name;

         @Nonnull
         public static ActionAdvised fromInteger (final int value)
           {
                          if (value == 1) return OBJECT_KILL;
              if (value == 2) return OBJECT_REPLACE;
              if (value == 3) return OBJECT_APPEND;
              if (value == 4) return OBJECT_REFERENCE;
              
             return _UNKNOWN;
           }
       }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ACTION_ADVISED}. If the value is changed, property change events will be fired
     * for {@code "actionAdvised"} and {@code "latestModificationTime}.
     *
     * @param   actionAdvised     the new value of {@code ACTION_ADVISED}
     *
     ******************************************************************************************************************/
    public void setActionAdvised (@Nonnull final ActionAdvised actionAdvised)
      {
        requireNonNull(actionAdvised, "actionAdvised");
        setActionAdvised(Optional.of(actionAdvised));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ACTION_ADVISED}. If the value is changed, property change events will be fired
     * for {@code "actionAdvised"} and {@code "latestModificationTime}.
     *
     * @param   actionAdvised     the new value of {@code ACTION_ADVISED}
     *
     ******************************************************************************************************************/
    public void setActionAdvised (@Nonnull final Optional<ActionAdvised> actionAdvised)
      {
        requireNonNull(actionAdvised, "actionAdvised");
        set(IPTCDirectoryGenerated.ACTION_ADVISED, actionAdvised);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ACTION_ADVISED}.
     *
     * @return  the current value of actionAdvised
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<ActionAdvised> getActionAdvised()
      {
        return get(ACTION_ADVISED, ActionAdvised.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code REFERENCE_SERVICE}. If the value is changed, property change events will be fired
     * for {@code "referenceService"} and {@code "latestModificationTime}.
     *
     * @param   referenceService     the new value of {@code REFERENCE_SERVICE}
     *
     ******************************************************************************************************************/
    public void setReferenceService (@Nonnull final String referenceService)
      {
        requireNonNull(referenceService, "referenceService");
        setReferenceService(Optional.of(referenceService));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code REFERENCE_SERVICE}. If the value is changed, property change events will be fired
     * for {@code "referenceService"} and {@code "latestModificationTime}.
     *
     * @param   referenceService     the new value of {@code REFERENCE_SERVICE}
     *
     ******************************************************************************************************************/
    public void setReferenceService (@Nonnull final Optional<String> referenceService)
      {
        requireNonNull(referenceService, "referenceService");
        set(IPTCDirectoryGenerated.REFERENCE_SERVICE, referenceService);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code REFERENCE_SERVICE}.
     *
     * @return  the current value of referenceService
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getReferenceService()
      {
        return get(REFERENCE_SERVICE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code REFERENCE_DATE}. If the value is changed, property change events will be fired
     * for {@code "referenceDate"} and {@code "latestModificationTime}.
     *
     * @param   referenceDate     the new value of {@code REFERENCE_DATE}
     *
     ******************************************************************************************************************/
    public void setReferenceDate (@Nonnull final String referenceDate)
      {
        requireNonNull(referenceDate, "referenceDate");
        setReferenceDate(Optional.of(referenceDate));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code REFERENCE_DATE}. If the value is changed, property change events will be fired
     * for {@code "referenceDate"} and {@code "latestModificationTime}.
     *
     * @param   referenceDate     the new value of {@code REFERENCE_DATE}
     *
     ******************************************************************************************************************/
    public void setReferenceDate (@Nonnull final Optional<String> referenceDate)
      {
        requireNonNull(referenceDate, "referenceDate");
        set(IPTCDirectoryGenerated.REFERENCE_DATE, referenceDate);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code REFERENCE_DATE}.
     *
     * @return  the current value of referenceDate
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getReferenceDate()
      {
        return get(REFERENCE_DATE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code REFERENCE_NUMBER}. If the value is changed, property change events will be fired
     * for {@code "referenceNumber"} and {@code "latestModificationTime}.
     *
     * @param   referenceNumber     the new value of {@code REFERENCE_NUMBER}
     *
     ******************************************************************************************************************/
    public void setReferenceNumber (@Nonnull final String referenceNumber)
      {
        requireNonNull(referenceNumber, "referenceNumber");
        setReferenceNumber(Optional.of(referenceNumber));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code REFERENCE_NUMBER}. If the value is changed, property change events will be fired
     * for {@code "referenceNumber"} and {@code "latestModificationTime}.
     *
     * @param   referenceNumber     the new value of {@code REFERENCE_NUMBER}
     *
     ******************************************************************************************************************/
    public void setReferenceNumber (@Nonnull final Optional<String> referenceNumber)
      {
        requireNonNull(referenceNumber, "referenceNumber");
        set(IPTCDirectoryGenerated.REFERENCE_NUMBER, referenceNumber);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code REFERENCE_NUMBER}.
     *
     * @return  the current value of referenceNumber
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getReferenceNumber()
      {
        return get(REFERENCE_NUMBER, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DATE_CREATED}. If the value is changed, property change events will be fired
     * for {@code "dateCreated"} and {@code "latestModificationTime}.
     *
     * @param   dateCreated     the new value of {@code DATE_CREATED}
     *
     ******************************************************************************************************************/
    public void setDateCreated (@Nonnull final String dateCreated)
      {
        requireNonNull(dateCreated, "dateCreated");
        setDateCreated(Optional.of(dateCreated));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DATE_CREATED}. If the value is changed, property change events will be fired
     * for {@code "dateCreated"} and {@code "latestModificationTime}.
     *
     * @param   dateCreated     the new value of {@code DATE_CREATED}
     *
     ******************************************************************************************************************/
    public void setDateCreated (@Nonnull final Optional<String> dateCreated)
      {
        requireNonNull(dateCreated, "dateCreated");
        set(IPTCDirectoryGenerated.DATE_CREATED, dateCreated);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code DATE_CREATED}.
     *
     * @return  the current value of dateCreated
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getDateCreated()
      {
        return get(DATE_CREATED, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code TIME_CREATED}. If the value is changed, property change events will be fired
     * for {@code "timeCreated"} and {@code "latestModificationTime}.
     *
     * @param   timeCreated     the new value of {@code TIME_CREATED}
     *
     ******************************************************************************************************************/
    public void setTimeCreated (@Nonnull final String timeCreated)
      {
        requireNonNull(timeCreated, "timeCreated");
        setTimeCreated(Optional.of(timeCreated));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code TIME_CREATED}. If the value is changed, property change events will be fired
     * for {@code "timeCreated"} and {@code "latestModificationTime}.
     *
     * @param   timeCreated     the new value of {@code TIME_CREATED}
     *
     ******************************************************************************************************************/
    public void setTimeCreated (@Nonnull final Optional<String> timeCreated)
      {
        requireNonNull(timeCreated, "timeCreated");
        set(IPTCDirectoryGenerated.TIME_CREATED, timeCreated);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code TIME_CREATED}.
     *
     * @return  the current value of timeCreated
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getTimeCreated()
      {
        return get(TIME_CREATED, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DIGITAL_CREATION_DATE}. If the value is changed, property change events will be fired
     * for {@code "digitalCreationDate"} and {@code "latestModificationTime}.
     *
     * @param   digitalCreationDate     the new value of {@code DIGITAL_CREATION_DATE}
     *
     ******************************************************************************************************************/
    public void setDigitalCreationDate (@Nonnull final String digitalCreationDate)
      {
        requireNonNull(digitalCreationDate, "digitalCreationDate");
        setDigitalCreationDate(Optional.of(digitalCreationDate));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DIGITAL_CREATION_DATE}. If the value is changed, property change events will be fired
     * for {@code "digitalCreationDate"} and {@code "latestModificationTime}.
     *
     * @param   digitalCreationDate     the new value of {@code DIGITAL_CREATION_DATE}
     *
     ******************************************************************************************************************/
    public void setDigitalCreationDate (@Nonnull final Optional<String> digitalCreationDate)
      {
        requireNonNull(digitalCreationDate, "digitalCreationDate");
        set(IPTCDirectoryGenerated.DIGITAL_CREATION_DATE, digitalCreationDate);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code DIGITAL_CREATION_DATE}.
     *
     * @return  the current value of digitalCreationDate
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getDigitalCreationDate()
      {
        return get(DIGITAL_CREATION_DATE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DIGITAL_CREATION_TIME}. If the value is changed, property change events will be fired
     * for {@code "digitalCreationTime"} and {@code "latestModificationTime}.
     *
     * @param   digitalCreationTime     the new value of {@code DIGITAL_CREATION_TIME}
     *
     ******************************************************************************************************************/
    public void setDigitalCreationTime (@Nonnull final String digitalCreationTime)
      {
        requireNonNull(digitalCreationTime, "digitalCreationTime");
        setDigitalCreationTime(Optional.of(digitalCreationTime));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DIGITAL_CREATION_TIME}. If the value is changed, property change events will be fired
     * for {@code "digitalCreationTime"} and {@code "latestModificationTime}.
     *
     * @param   digitalCreationTime     the new value of {@code DIGITAL_CREATION_TIME}
     *
     ******************************************************************************************************************/
    public void setDigitalCreationTime (@Nonnull final Optional<String> digitalCreationTime)
      {
        requireNonNull(digitalCreationTime, "digitalCreationTime");
        set(IPTCDirectoryGenerated.DIGITAL_CREATION_TIME, digitalCreationTime);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code DIGITAL_CREATION_TIME}.
     *
     * @return  the current value of digitalCreationTime
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getDigitalCreationTime()
      {
        return get(DIGITAL_CREATION_TIME, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ORIGINATING_PROGRAM}. If the value is changed, property change events will be fired
     * for {@code "originatingProgram"} and {@code "latestModificationTime}.
     *
     * @param   originatingProgram     the new value of {@code ORIGINATING_PROGRAM}
     *
     ******************************************************************************************************************/
    public void setOriginatingProgram (@Nonnull final String originatingProgram)
      {
        requireNonNull(originatingProgram, "originatingProgram");
        setOriginatingProgram(Optional.of(originatingProgram));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ORIGINATING_PROGRAM}. If the value is changed, property change events will be fired
     * for {@code "originatingProgram"} and {@code "latestModificationTime}.
     *
     * @param   originatingProgram     the new value of {@code ORIGINATING_PROGRAM}
     *
     ******************************************************************************************************************/
    public void setOriginatingProgram (@Nonnull final Optional<String> originatingProgram)
      {
        requireNonNull(originatingProgram, "originatingProgram");
        set(IPTCDirectoryGenerated.ORIGINATING_PROGRAM, originatingProgram);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ORIGINATING_PROGRAM}.
     *
     * @return  the current value of originatingProgram
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getOriginatingProgram()
      {
        return get(ORIGINATING_PROGRAM, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code PROGRAM_VERSION}. If the value is changed, property change events will be fired
     * for {@code "programVersion"} and {@code "latestModificationTime}.
     *
     * @param   programVersion     the new value of {@code PROGRAM_VERSION}
     *
     ******************************************************************************************************************/
    public void setProgramVersion (@Nonnull final String programVersion)
      {
        requireNonNull(programVersion, "programVersion");
        setProgramVersion(Optional.of(programVersion));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code PROGRAM_VERSION}. If the value is changed, property change events will be fired
     * for {@code "programVersion"} and {@code "latestModificationTime}.
     *
     * @param   programVersion     the new value of {@code PROGRAM_VERSION}
     *
     ******************************************************************************************************************/
    public void setProgramVersion (@Nonnull final Optional<String> programVersion)
      {
        requireNonNull(programVersion, "programVersion");
        set(IPTCDirectoryGenerated.PROGRAM_VERSION, programVersion);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code PROGRAM_VERSION}.
     *
     * @return  the current value of programVersion
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getProgramVersion()
      {
        return get(PROGRAM_VERSION, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_CYCLE}. If the value is changed, property change events will be fired
     * for {@code "objectCycle"} and {@code "latestModificationTime}.
     *
     * @param   objectCycle     the new value of {@code OBJECT_CYCLE}
     *
     ******************************************************************************************************************/
    public void setObjectCycle (@Nonnull final String objectCycle)
      {
        requireNonNull(objectCycle, "objectCycle");
        setObjectCycle(Optional.of(objectCycle));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_CYCLE}. If the value is changed, property change events will be fired
     * for {@code "objectCycle"} and {@code "latestModificationTime}.
     *
     * @param   objectCycle     the new value of {@code OBJECT_CYCLE}
     *
     ******************************************************************************************************************/
    public void setObjectCycle (@Nonnull final Optional<String> objectCycle)
      {
        requireNonNull(objectCycle, "objectCycle");
        set(IPTCDirectoryGenerated.OBJECT_CYCLE, objectCycle);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code OBJECT_CYCLE}.
     *
     * @return  the current value of objectCycle
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getObjectCycle()
      {
        return get(OBJECT_CYCLE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code BYLINE}. If the value is changed, property change events will be fired
     * for {@code "byline"} and {@code "latestModificationTime}.
     *
     * @param   byline     the new value of {@code BYLINE}
     *
     ******************************************************************************************************************/
    public void setByline (@Nonnull final String byline)
      {
        requireNonNull(byline, "byline");
        setByline(Optional.of(byline));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code BYLINE}. If the value is changed, property change events will be fired
     * for {@code "byline"} and {@code "latestModificationTime}.
     *
     * @param   byline     the new value of {@code BYLINE}
     *
     ******************************************************************************************************************/
    public void setByline (@Nonnull final Optional<String> byline)
      {
        requireNonNull(byline, "byline");
        set(IPTCDirectoryGenerated.BYLINE, byline);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code BYLINE}.
     *
     * @return  the current value of byline
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getByline()
      {
        return get(BYLINE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code BYLINE_TITLE}. If the value is changed, property change events will be fired
     * for {@code "bylineTitle"} and {@code "latestModificationTime}.
     *
     * @param   bylineTitle     the new value of {@code BYLINE_TITLE}
     *
     ******************************************************************************************************************/
    public void setBylineTitle (@Nonnull final String bylineTitle)
      {
        requireNonNull(bylineTitle, "bylineTitle");
        setBylineTitle(Optional.of(bylineTitle));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code BYLINE_TITLE}. If the value is changed, property change events will be fired
     * for {@code "bylineTitle"} and {@code "latestModificationTime}.
     *
     * @param   bylineTitle     the new value of {@code BYLINE_TITLE}
     *
     ******************************************************************************************************************/
    public void setBylineTitle (@Nonnull final Optional<String> bylineTitle)
      {
        requireNonNull(bylineTitle, "bylineTitle");
        set(IPTCDirectoryGenerated.BYLINE_TITLE, bylineTitle);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code BYLINE_TITLE}.
     *
     * @return  the current value of bylineTitle
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getBylineTitle()
      {
        return get(BYLINE_TITLE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CITY}. If the value is changed, property change events will be fired
     * for {@code "city"} and {@code "latestModificationTime}.
     *
     * @param   city     the new value of {@code CITY}
     *
     ******************************************************************************************************************/
    public void setCity (@Nonnull final String city)
      {
        requireNonNull(city, "city");
        setCity(Optional.of(city));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CITY}. If the value is changed, property change events will be fired
     * for {@code "city"} and {@code "latestModificationTime}.
     *
     * @param   city     the new value of {@code CITY}
     *
     ******************************************************************************************************************/
    public void setCity (@Nonnull final Optional<String> city)
      {
        requireNonNull(city, "city");
        set(IPTCDirectoryGenerated.CITY, city);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code CITY}.
     *
     * @return  the current value of city
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getCity()
      {
        return get(CITY, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SUBLOCATION}. If the value is changed, property change events will be fired
     * for {@code "sublocation"} and {@code "latestModificationTime}.
     *
     * @param   sublocation     the new value of {@code SUBLOCATION}
     *
     ******************************************************************************************************************/
    public void setSublocation (@Nonnull final String sublocation)
      {
        requireNonNull(sublocation, "sublocation");
        setSublocation(Optional.of(sublocation));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SUBLOCATION}. If the value is changed, property change events will be fired
     * for {@code "sublocation"} and {@code "latestModificationTime}.
     *
     * @param   sublocation     the new value of {@code SUBLOCATION}
     *
     ******************************************************************************************************************/
    public void setSublocation (@Nonnull final Optional<String> sublocation)
      {
        requireNonNull(sublocation, "sublocation");
        set(IPTCDirectoryGenerated.SUBLOCATION, sublocation);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code SUBLOCATION}.
     *
     * @return  the current value of sublocation
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getSublocation()
      {
        return get(SUBLOCATION, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code PROVINCESTATE}. If the value is changed, property change events will be fired
     * for {@code "provinceState"} and {@code "latestModificationTime}.
     *
     * @param   provinceState     the new value of {@code PROVINCESTATE}
     *
     ******************************************************************************************************************/
    public void setProvinceState (@Nonnull final String provinceState)
      {
        requireNonNull(provinceState, "provinceState");
        setProvinceState(Optional.of(provinceState));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code PROVINCESTATE}. If the value is changed, property change events will be fired
     * for {@code "provinceState"} and {@code "latestModificationTime}.
     *
     * @param   provinceState     the new value of {@code PROVINCESTATE}
     *
     ******************************************************************************************************************/
    public void setProvinceState (@Nonnull final Optional<String> provinceState)
      {
        requireNonNull(provinceState, "provinceState");
        set(IPTCDirectoryGenerated.PROVINCESTATE, provinceState);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code PROVINCESTATE}.
     *
     * @return  the current value of provinceState
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getProvinceState()
      {
        return get(PROVINCESTATE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code COUNTRYPRIMARY_LOCATION_CODE}. If the value is changed, property change events will be fired
     * for {@code "countryPrimaryLocationCode"} and {@code "latestModificationTime}.
     *
     * @param   countryPrimaryLocationCode     the new value of {@code COUNTRYPRIMARY_LOCATION_CODE}
     *
     ******************************************************************************************************************/
    public void setCountryPrimaryLocationCode (@Nonnull final String countryPrimaryLocationCode)
      {
        requireNonNull(countryPrimaryLocationCode, "countryPrimaryLocationCode");
        setCountryPrimaryLocationCode(Optional.of(countryPrimaryLocationCode));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code COUNTRYPRIMARY_LOCATION_CODE}. If the value is changed, property change events will be fired
     * for {@code "countryPrimaryLocationCode"} and {@code "latestModificationTime}.
     *
     * @param   countryPrimaryLocationCode     the new value of {@code COUNTRYPRIMARY_LOCATION_CODE}
     *
     ******************************************************************************************************************/
    public void setCountryPrimaryLocationCode (@Nonnull final Optional<String> countryPrimaryLocationCode)
      {
        requireNonNull(countryPrimaryLocationCode, "countryPrimaryLocationCode");
        set(IPTCDirectoryGenerated.COUNTRYPRIMARY_LOCATION_CODE, countryPrimaryLocationCode);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code COUNTRYPRIMARY_LOCATION_CODE}.
     *
     * @return  the current value of countryPrimaryLocationCode
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getCountryPrimaryLocationCode()
      {
        return get(COUNTRYPRIMARY_LOCATION_CODE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code COUNTRYPRIMARY_LOCATION_NAME}. If the value is changed, property change events will be fired
     * for {@code "countryPrimaryLocationName"} and {@code "latestModificationTime}.
     *
     * @param   countryPrimaryLocationName     the new value of {@code COUNTRYPRIMARY_LOCATION_NAME}
     *
     ******************************************************************************************************************/
    public void setCountryPrimaryLocationName (@Nonnull final String countryPrimaryLocationName)
      {
        requireNonNull(countryPrimaryLocationName, "countryPrimaryLocationName");
        setCountryPrimaryLocationName(Optional.of(countryPrimaryLocationName));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code COUNTRYPRIMARY_LOCATION_NAME}. If the value is changed, property change events will be fired
     * for {@code "countryPrimaryLocationName"} and {@code "latestModificationTime}.
     *
     * @param   countryPrimaryLocationName     the new value of {@code COUNTRYPRIMARY_LOCATION_NAME}
     *
     ******************************************************************************************************************/
    public void setCountryPrimaryLocationName (@Nonnull final Optional<String> countryPrimaryLocationName)
      {
        requireNonNull(countryPrimaryLocationName, "countryPrimaryLocationName");
        set(IPTCDirectoryGenerated.COUNTRYPRIMARY_LOCATION_NAME, countryPrimaryLocationName);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code COUNTRYPRIMARY_LOCATION_NAME}.
     *
     * @return  the current value of countryPrimaryLocationName
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getCountryPrimaryLocationName()
      {
        return get(COUNTRYPRIMARY_LOCATION_NAME, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ORIGINAL_TRANSMISSION_REFERENCE}. If the value is changed, property change events will be fired
     * for {@code "originalTransmissionReference"} and {@code "latestModificationTime}.
     *
     * @param   originalTransmissionReference     the new value of {@code ORIGINAL_TRANSMISSION_REFERENCE}
     *
     ******************************************************************************************************************/
    public void setOriginalTransmissionReference (@Nonnull final String originalTransmissionReference)
      {
        requireNonNull(originalTransmissionReference, "originalTransmissionReference");
        setOriginalTransmissionReference(Optional.of(originalTransmissionReference));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ORIGINAL_TRANSMISSION_REFERENCE}. If the value is changed, property change events will be fired
     * for {@code "originalTransmissionReference"} and {@code "latestModificationTime}.
     *
     * @param   originalTransmissionReference     the new value of {@code ORIGINAL_TRANSMISSION_REFERENCE}
     *
     ******************************************************************************************************************/
    public void setOriginalTransmissionReference (@Nonnull final Optional<String> originalTransmissionReference)
      {
        requireNonNull(originalTransmissionReference, "originalTransmissionReference");
        set(IPTCDirectoryGenerated.ORIGINAL_TRANSMISSION_REFERENCE, originalTransmissionReference);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ORIGINAL_TRANSMISSION_REFERENCE}.
     *
     * @return  the current value of originalTransmissionReference
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getOriginalTransmissionReference()
      {
        return get(ORIGINAL_TRANSMISSION_REFERENCE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code HEADLINE}. If the value is changed, property change events will be fired
     * for {@code "headline"} and {@code "latestModificationTime}.
     *
     * @param   headline     the new value of {@code HEADLINE}
     *
     ******************************************************************************************************************/
    public void setHeadline (@Nonnull final String headline)
      {
        requireNonNull(headline, "headline");
        setHeadline(Optional.of(headline));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code HEADLINE}. If the value is changed, property change events will be fired
     * for {@code "headline"} and {@code "latestModificationTime}.
     *
     * @param   headline     the new value of {@code HEADLINE}
     *
     ******************************************************************************************************************/
    public void setHeadline (@Nonnull final Optional<String> headline)
      {
        requireNonNull(headline, "headline");
        set(IPTCDirectoryGenerated.HEADLINE, headline);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code HEADLINE}.
     *
     * @return  the current value of headline
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getHeadline()
      {
        return get(HEADLINE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CREDIT}. If the value is changed, property change events will be fired
     * for {@code "credit"} and {@code "latestModificationTime}.
     *
     * @param   credit     the new value of {@code CREDIT}
     *
     ******************************************************************************************************************/
    public void setCredit (@Nonnull final String credit)
      {
        requireNonNull(credit, "credit");
        setCredit(Optional.of(credit));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CREDIT}. If the value is changed, property change events will be fired
     * for {@code "credit"} and {@code "latestModificationTime}.
     *
     * @param   credit     the new value of {@code CREDIT}
     *
     ******************************************************************************************************************/
    public void setCredit (@Nonnull final Optional<String> credit)
      {
        requireNonNull(credit, "credit");
        set(IPTCDirectoryGenerated.CREDIT, credit);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code CREDIT}.
     *
     * @return  the current value of credit
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getCredit()
      {
        return get(CREDIT, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SOURCE}. If the value is changed, property change events will be fired
     * for {@code "source"} and {@code "latestModificationTime}.
     *
     * @param   source     the new value of {@code SOURCE}
     *
     ******************************************************************************************************************/
    public void setSource (@Nonnull final String source)
      {
        requireNonNull(source, "source");
        setSource(Optional.of(source));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SOURCE}. If the value is changed, property change events will be fired
     * for {@code "source"} and {@code "latestModificationTime}.
     *
     * @param   source     the new value of {@code SOURCE}
     *
     ******************************************************************************************************************/
    public void setSource (@Nonnull final Optional<String> source)
      {
        requireNonNull(source, "source");
        set(IPTCDirectoryGenerated.SOURCE, source);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code SOURCE}.
     *
     * @return  the current value of source
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getSource()
      {
        return get(SOURCE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code COPYRIGHT_NOTICE}. If the value is changed, property change events will be fired
     * for {@code "copyrightNotice"} and {@code "latestModificationTime}.
     *
     * @param   copyrightNotice     the new value of {@code COPYRIGHT_NOTICE}
     *
     ******************************************************************************************************************/
    public void setCopyrightNotice (@Nonnull final String copyrightNotice)
      {
        requireNonNull(copyrightNotice, "copyrightNotice");
        setCopyrightNotice(Optional.of(copyrightNotice));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code COPYRIGHT_NOTICE}. If the value is changed, property change events will be fired
     * for {@code "copyrightNotice"} and {@code "latestModificationTime}.
     *
     * @param   copyrightNotice     the new value of {@code COPYRIGHT_NOTICE}
     *
     ******************************************************************************************************************/
    public void setCopyrightNotice (@Nonnull final Optional<String> copyrightNotice)
      {
        requireNonNull(copyrightNotice, "copyrightNotice");
        set(IPTCDirectoryGenerated.COPYRIGHT_NOTICE, copyrightNotice);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code COPYRIGHT_NOTICE}.
     *
     * @return  the current value of copyrightNotice
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getCopyrightNotice()
      {
        return get(COPYRIGHT_NOTICE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CONTACT}. If the value is changed, property change events will be fired
     * for {@code "contact"} and {@code "latestModificationTime}.
     *
     * @param   contact     the new value of {@code CONTACT}
     *
     ******************************************************************************************************************/
    public void setContact (@Nonnull final String contact)
      {
        requireNonNull(contact, "contact");
        setContact(Optional.of(contact));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CONTACT}. If the value is changed, property change events will be fired
     * for {@code "contact"} and {@code "latestModificationTime}.
     *
     * @param   contact     the new value of {@code CONTACT}
     *
     ******************************************************************************************************************/
    public void setContact (@Nonnull final Optional<String> contact)
      {
        requireNonNull(contact, "contact");
        set(IPTCDirectoryGenerated.CONTACT, contact);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code CONTACT}.
     *
     * @return  the current value of contact
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getContact()
      {
        return get(CONTACT, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CAPTIONABSTRACT}. If the value is changed, property change events will be fired
     * for {@code "captionAbstract"} and {@code "latestModificationTime}.
     *
     * @param   captionAbstract     the new value of {@code CAPTIONABSTRACT}
     *
     ******************************************************************************************************************/
    public void setCaptionAbstract (@Nonnull final String captionAbstract)
      {
        requireNonNull(captionAbstract, "captionAbstract");
        setCaptionAbstract(Optional.of(captionAbstract));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CAPTIONABSTRACT}. If the value is changed, property change events will be fired
     * for {@code "captionAbstract"} and {@code "latestModificationTime}.
     *
     * @param   captionAbstract     the new value of {@code CAPTIONABSTRACT}
     *
     ******************************************************************************************************************/
    public void setCaptionAbstract (@Nonnull final Optional<String> captionAbstract)
      {
        requireNonNull(captionAbstract, "captionAbstract");
        set(IPTCDirectoryGenerated.CAPTIONABSTRACT, captionAbstract);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code CAPTIONABSTRACT}.
     *
     * @return  the current value of captionAbstract
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getCaptionAbstract()
      {
        return get(CAPTIONABSTRACT, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code LOCAL_CAPTION}. If the value is changed, property change events will be fired
     * for {@code "localCaption"} and {@code "latestModificationTime}.
     *
     * @param   localCaption     the new value of {@code LOCAL_CAPTION}
     *
     ******************************************************************************************************************/
    public void setLocalCaption (@Nonnull final String localCaption)
      {
        requireNonNull(localCaption, "localCaption");
        setLocalCaption(Optional.of(localCaption));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code LOCAL_CAPTION}. If the value is changed, property change events will be fired
     * for {@code "localCaption"} and {@code "latestModificationTime}.
     *
     * @param   localCaption     the new value of {@code LOCAL_CAPTION}
     *
     ******************************************************************************************************************/
    public void setLocalCaption (@Nonnull final Optional<String> localCaption)
      {
        requireNonNull(localCaption, "localCaption");
        set(IPTCDirectoryGenerated.LOCAL_CAPTION, localCaption);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code LOCAL_CAPTION}.
     *
     * @return  the current value of localCaption
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getLocalCaption()
      {
        return get(LOCAL_CAPTION, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code WRITEREDITOR}. If the value is changed, property change events will be fired
     * for {@code "writerEditor"} and {@code "latestModificationTime}.
     *
     * @param   writerEditor     the new value of {@code WRITEREDITOR}
     *
     ******************************************************************************************************************/
    public void setWriterEditor (@Nonnull final String writerEditor)
      {
        requireNonNull(writerEditor, "writerEditor");
        setWriterEditor(Optional.of(writerEditor));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code WRITEREDITOR}. If the value is changed, property change events will be fired
     * for {@code "writerEditor"} and {@code "latestModificationTime}.
     *
     * @param   writerEditor     the new value of {@code WRITEREDITOR}
     *
     ******************************************************************************************************************/
    public void setWriterEditor (@Nonnull final Optional<String> writerEditor)
      {
        requireNonNull(writerEditor, "writerEditor");
        set(IPTCDirectoryGenerated.WRITEREDITOR, writerEditor);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code WRITEREDITOR}.
     *
     * @return  the current value of writerEditor
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getWriterEditor()
      {
        return get(WRITEREDITOR, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code RASTERIZED_CAPTION}. If the value is changed, property change events will be fired
     * for {@code "rasterizedCaption"} and {@code "latestModificationTime}.
     *
     * @param   rasterizedCaption     the new value of {@code RASTERIZED_CAPTION}
     *
     ******************************************************************************************************************/
    public void setRasterizedCaption (@Nonnull final String rasterizedCaption)
      {
        requireNonNull(rasterizedCaption, "rasterizedCaption");
        setRasterizedCaption(Optional.of(rasterizedCaption));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code RASTERIZED_CAPTION}. If the value is changed, property change events will be fired
     * for {@code "rasterizedCaption"} and {@code "latestModificationTime}.
     *
     * @param   rasterizedCaption     the new value of {@code RASTERIZED_CAPTION}
     *
     ******************************************************************************************************************/
    public void setRasterizedCaption (@Nonnull final Optional<String> rasterizedCaption)
      {
        requireNonNull(rasterizedCaption, "rasterizedCaption");
        set(IPTCDirectoryGenerated.RASTERIZED_CAPTION, rasterizedCaption);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code RASTERIZED_CAPTION}.
     *
     * @return  the current value of rasterizedCaption
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getRasterizedCaption()
      {
        return get(RASTERIZED_CAPTION, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code IMAGE_TYPE}. If the value is changed, property change events will be fired
     * for {@code "imageType"} and {@code "latestModificationTime}.
     *
     * @param   imageType     the new value of {@code IMAGE_TYPE}
     *
     ******************************************************************************************************************/
    public void setImageType (@Nonnull final String imageType)
      {
        requireNonNull(imageType, "imageType");
        setImageType(Optional.of(imageType));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code IMAGE_TYPE}. If the value is changed, property change events will be fired
     * for {@code "imageType"} and {@code "latestModificationTime}.
     *
     * @param   imageType     the new value of {@code IMAGE_TYPE}
     *
     ******************************************************************************************************************/
    public void setImageType (@Nonnull final Optional<String> imageType)
      {
        requireNonNull(imageType, "imageType");
        set(IPTCDirectoryGenerated.IMAGE_TYPE, imageType);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code IMAGE_TYPE}.
     *
     * @return  the current value of imageType
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getImageType()
      {
        return get(IMAGE_TYPE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code IMAGE_ORIENTATION}. If the value is changed, property change events will be fired
     * for {@code "imageOrientation"} and {@code "latestModificationTime}.
     *
     * @param   imageOrientation     the new value of {@code IMAGE_ORIENTATION}
     *
     ******************************************************************************************************************/
    public void setImageOrientation (@Nonnull final String imageOrientation)
      {
        requireNonNull(imageOrientation, "imageOrientation");
        setImageOrientation(Optional.of(imageOrientation));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code IMAGE_ORIENTATION}. If the value is changed, property change events will be fired
     * for {@code "imageOrientation"} and {@code "latestModificationTime}.
     *
     * @param   imageOrientation     the new value of {@code IMAGE_ORIENTATION}
     *
     ******************************************************************************************************************/
    public void setImageOrientation (@Nonnull final Optional<String> imageOrientation)
      {
        requireNonNull(imageOrientation, "imageOrientation");
        set(IPTCDirectoryGenerated.IMAGE_ORIENTATION, imageOrientation);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code IMAGE_ORIENTATION}.
     *
     * @return  the current value of imageOrientation
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getImageOrientation()
      {
        return get(IMAGE_ORIENTATION, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code LANGUAGE_IDENTIFIER}. If the value is changed, property change events will be fired
     * for {@code "languageIdentifier"} and {@code "latestModificationTime}.
     *
     * @param   languageIdentifier     the new value of {@code LANGUAGE_IDENTIFIER}
     *
     ******************************************************************************************************************/
    public void setLanguageIdentifier (@Nonnull final String languageIdentifier)
      {
        requireNonNull(languageIdentifier, "languageIdentifier");
        setLanguageIdentifier(Optional.of(languageIdentifier));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code LANGUAGE_IDENTIFIER}. If the value is changed, property change events will be fired
     * for {@code "languageIdentifier"} and {@code "latestModificationTime}.
     *
     * @param   languageIdentifier     the new value of {@code LANGUAGE_IDENTIFIER}
     *
     ******************************************************************************************************************/
    public void setLanguageIdentifier (@Nonnull final Optional<String> languageIdentifier)
      {
        requireNonNull(languageIdentifier, "languageIdentifier");
        set(IPTCDirectoryGenerated.LANGUAGE_IDENTIFIER, languageIdentifier);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code LANGUAGE_IDENTIFIER}.
     *
     * @return  the current value of languageIdentifier
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getLanguageIdentifier()
      {
        return get(LANGUAGE_IDENTIFIER, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_TYPE}. If the value is changed, property change events will be fired
     * for {@code "audioType"} and {@code "latestModificationTime}.
     *
     * @param   audioType     the new value of {@code AUDIO_TYPE}
     *
     ******************************************************************************************************************/
    public void setAudioType (@Nonnull final String audioType)
      {
        requireNonNull(audioType, "audioType");
        setAudioType(Optional.of(audioType));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_TYPE}. If the value is changed, property change events will be fired
     * for {@code "audioType"} and {@code "latestModificationTime}.
     *
     * @param   audioType     the new value of {@code AUDIO_TYPE}
     *
     ******************************************************************************************************************/
    public void setAudioType (@Nonnull final Optional<String> audioType)
      {
        requireNonNull(audioType, "audioType");
        set(IPTCDirectoryGenerated.AUDIO_TYPE, audioType);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code AUDIO_TYPE}.
     *
     * @return  the current value of audioType
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAudioType()
      {
        return get(AUDIO_TYPE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_SAMPLING_RATE}. If the value is changed, property change events will be fired
     * for {@code "audioSamplingRate"} and {@code "latestModificationTime}.
     *
     * @param   audioSamplingRate     the new value of {@code AUDIO_SAMPLING_RATE}
     *
     ******************************************************************************************************************/
    public void setAudioSamplingRate (@Nonnull final String audioSamplingRate)
      {
        requireNonNull(audioSamplingRate, "audioSamplingRate");
        setAudioSamplingRate(Optional.of(audioSamplingRate));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_SAMPLING_RATE}. If the value is changed, property change events will be fired
     * for {@code "audioSamplingRate"} and {@code "latestModificationTime}.
     *
     * @param   audioSamplingRate     the new value of {@code AUDIO_SAMPLING_RATE}
     *
     ******************************************************************************************************************/
    public void setAudioSamplingRate (@Nonnull final Optional<String> audioSamplingRate)
      {
        requireNonNull(audioSamplingRate, "audioSamplingRate");
        set(IPTCDirectoryGenerated.AUDIO_SAMPLING_RATE, audioSamplingRate);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code AUDIO_SAMPLING_RATE}.
     *
     * @return  the current value of audioSamplingRate
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAudioSamplingRate()
      {
        return get(AUDIO_SAMPLING_RATE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_SAMPLING_RESOLUTION}. If the value is changed, property change events will be fired
     * for {@code "audioSamplingResolution"} and {@code "latestModificationTime}.
     *
     * @param   audioSamplingResolution     the new value of {@code AUDIO_SAMPLING_RESOLUTION}
     *
     ******************************************************************************************************************/
    public void setAudioSamplingResolution (@Nonnull final String audioSamplingResolution)
      {
        requireNonNull(audioSamplingResolution, "audioSamplingResolution");
        setAudioSamplingResolution(Optional.of(audioSamplingResolution));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_SAMPLING_RESOLUTION}. If the value is changed, property change events will be fired
     * for {@code "audioSamplingResolution"} and {@code "latestModificationTime}.
     *
     * @param   audioSamplingResolution     the new value of {@code AUDIO_SAMPLING_RESOLUTION}
     *
     ******************************************************************************************************************/
    public void setAudioSamplingResolution (@Nonnull final Optional<String> audioSamplingResolution)
      {
        requireNonNull(audioSamplingResolution, "audioSamplingResolution");
        set(IPTCDirectoryGenerated.AUDIO_SAMPLING_RESOLUTION, audioSamplingResolution);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code AUDIO_SAMPLING_RESOLUTION}.
     *
     * @return  the current value of audioSamplingResolution
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAudioSamplingResolution()
      {
        return get(AUDIO_SAMPLING_RESOLUTION, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_DURATION}. If the value is changed, property change events will be fired
     * for {@code "audioDuration"} and {@code "latestModificationTime}.
     *
     * @param   audioDuration     the new value of {@code AUDIO_DURATION}
     *
     ******************************************************************************************************************/
    public void setAudioDuration (@Nonnull final String audioDuration)
      {
        requireNonNull(audioDuration, "audioDuration");
        setAudioDuration(Optional.of(audioDuration));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_DURATION}. If the value is changed, property change events will be fired
     * for {@code "audioDuration"} and {@code "latestModificationTime}.
     *
     * @param   audioDuration     the new value of {@code AUDIO_DURATION}
     *
     ******************************************************************************************************************/
    public void setAudioDuration (@Nonnull final Optional<String> audioDuration)
      {
        requireNonNull(audioDuration, "audioDuration");
        set(IPTCDirectoryGenerated.AUDIO_DURATION, audioDuration);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code AUDIO_DURATION}.
     *
     * @return  the current value of audioDuration
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAudioDuration()
      {
        return get(AUDIO_DURATION, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_OUTCUE}. If the value is changed, property change events will be fired
     * for {@code "audioOutcue"} and {@code "latestModificationTime}.
     *
     * @param   audioOutcue     the new value of {@code AUDIO_OUTCUE}
     *
     ******************************************************************************************************************/
    public void setAudioOutcue (@Nonnull final String audioOutcue)
      {
        requireNonNull(audioOutcue, "audioOutcue");
        setAudioOutcue(Optional.of(audioOutcue));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code AUDIO_OUTCUE}. If the value is changed, property change events will be fired
     * for {@code "audioOutcue"} and {@code "latestModificationTime}.
     *
     * @param   audioOutcue     the new value of {@code AUDIO_OUTCUE}
     *
     ******************************************************************************************************************/
    public void setAudioOutcue (@Nonnull final Optional<String> audioOutcue)
      {
        requireNonNull(audioOutcue, "audioOutcue");
        set(IPTCDirectoryGenerated.AUDIO_OUTCUE, audioOutcue);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code AUDIO_OUTCUE}.
     *
     * @return  the current value of audioOutcue
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAudioOutcue()
      {
        return get(AUDIO_OUTCUE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code JOB_ID}. If the value is changed, property change events will be fired
     * for {@code "jobID"} and {@code "latestModificationTime}.
     *
     * @param   jobID     the new value of {@code JOB_ID}
     *
     ******************************************************************************************************************/
    public void setJobID (@Nonnull final String jobID)
      {
        requireNonNull(jobID, "jobID");
        setJobID(Optional.of(jobID));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code JOB_ID}. If the value is changed, property change events will be fired
     * for {@code "jobID"} and {@code "latestModificationTime}.
     *
     * @param   jobID     the new value of {@code JOB_ID}
     *
     ******************************************************************************************************************/
    public void setJobID (@Nonnull final Optional<String> jobID)
      {
        requireNonNull(jobID, "jobID");
        set(IPTCDirectoryGenerated.JOB_ID, jobID);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code JOB_ID}.
     *
     * @return  the current value of jobID
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getJobID()
      {
        return get(JOB_ID, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code MASTER_DOCUMENT_ID}. If the value is changed, property change events will be fired
     * for {@code "masterDocumentID"} and {@code "latestModificationTime}.
     *
     * @param   masterDocumentID     the new value of {@code MASTER_DOCUMENT_ID}
     *
     ******************************************************************************************************************/
    public void setMasterDocumentID (@Nonnull final String masterDocumentID)
      {
        requireNonNull(masterDocumentID, "masterDocumentID");
        setMasterDocumentID(Optional.of(masterDocumentID));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code MASTER_DOCUMENT_ID}. If the value is changed, property change events will be fired
     * for {@code "masterDocumentID"} and {@code "latestModificationTime}.
     *
     * @param   masterDocumentID     the new value of {@code MASTER_DOCUMENT_ID}
     *
     ******************************************************************************************************************/
    public void setMasterDocumentID (@Nonnull final Optional<String> masterDocumentID)
      {
        requireNonNull(masterDocumentID, "masterDocumentID");
        set(IPTCDirectoryGenerated.MASTER_DOCUMENT_ID, masterDocumentID);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code MASTER_DOCUMENT_ID}.
     *
     * @return  the current value of masterDocumentID
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getMasterDocumentID()
      {
        return get(MASTER_DOCUMENT_ID, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SHORT_DOCUMENT_ID}. If the value is changed, property change events will be fired
     * for {@code "shortDocumentID"} and {@code "latestModificationTime}.
     *
     * @param   shortDocumentID     the new value of {@code SHORT_DOCUMENT_ID}
     *
     ******************************************************************************************************************/
    public void setShortDocumentID (@Nonnull final String shortDocumentID)
      {
        requireNonNull(shortDocumentID, "shortDocumentID");
        setShortDocumentID(Optional.of(shortDocumentID));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SHORT_DOCUMENT_ID}. If the value is changed, property change events will be fired
     * for {@code "shortDocumentID"} and {@code "latestModificationTime}.
     *
     * @param   shortDocumentID     the new value of {@code SHORT_DOCUMENT_ID}
     *
     ******************************************************************************************************************/
    public void setShortDocumentID (@Nonnull final Optional<String> shortDocumentID)
      {
        requireNonNull(shortDocumentID, "shortDocumentID");
        set(IPTCDirectoryGenerated.SHORT_DOCUMENT_ID, shortDocumentID);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code SHORT_DOCUMENT_ID}.
     *
     * @return  the current value of shortDocumentID
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getShortDocumentID()
      {
        return get(SHORT_DOCUMENT_ID, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code UNIQUE_DOCUMENT_ID}. If the value is changed, property change events will be fired
     * for {@code "uniqueDocumentID"} and {@code "latestModificationTime}.
     *
     * @param   uniqueDocumentID     the new value of {@code UNIQUE_DOCUMENT_ID}
     *
     ******************************************************************************************************************/
    public void setUniqueDocumentID (@Nonnull final String uniqueDocumentID)
      {
        requireNonNull(uniqueDocumentID, "uniqueDocumentID");
        setUniqueDocumentID(Optional.of(uniqueDocumentID));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code UNIQUE_DOCUMENT_ID}. If the value is changed, property change events will be fired
     * for {@code "uniqueDocumentID"} and {@code "latestModificationTime}.
     *
     * @param   uniqueDocumentID     the new value of {@code UNIQUE_DOCUMENT_ID}
     *
     ******************************************************************************************************************/
    public void setUniqueDocumentID (@Nonnull final Optional<String> uniqueDocumentID)
      {
        requireNonNull(uniqueDocumentID, "uniqueDocumentID");
        set(IPTCDirectoryGenerated.UNIQUE_DOCUMENT_ID, uniqueDocumentID);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code UNIQUE_DOCUMENT_ID}.
     *
     * @return  the current value of uniqueDocumentID
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getUniqueDocumentID()
      {
        return get(UNIQUE_DOCUMENT_ID, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OWNER_ID}. If the value is changed, property change events will be fired
     * for {@code "ownerID"} and {@code "latestModificationTime}.
     *
     * @param   ownerID     the new value of {@code OWNER_ID}
     *
     ******************************************************************************************************************/
    public void setOwnerID (@Nonnull final String ownerID)
      {
        requireNonNull(ownerID, "ownerID");
        setOwnerID(Optional.of(ownerID));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OWNER_ID}. If the value is changed, property change events will be fired
     * for {@code "ownerID"} and {@code "latestModificationTime}.
     *
     * @param   ownerID     the new value of {@code OWNER_ID}
     *
     ******************************************************************************************************************/
    public void setOwnerID (@Nonnull final Optional<String> ownerID)
      {
        requireNonNull(ownerID, "ownerID");
        set(IPTCDirectoryGenerated.OWNER_ID, ownerID);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code OWNER_ID}.
     *
     * @return  the current value of ownerID
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getOwnerID()
      {
        return get(OWNER_ID, String.class);
      }

    /*******************************************************************************************************************
     *
     * Enumeration for representing the possible values of tag ObjectPreviewFileFormat.
     *
     ******************************************************************************************************************/
    @RequiredArgsConstructor(access = AccessLevel.PRIVATE) @Getter
    public static enum ObjectPreviewFileFormat
       {
                  NO_OBJECTDATA(0, "No ObjectData"),
          IPTC_NAA_DIGITAL_NEWSPHOTO_PARAMETER_RECORD(1, "IPTC-NAA Digital Newsphoto Parameter Record"),
          IPTC7901_RECOMMENDED_MESSAGE_FORMAT(2, "IPTC7901 Recommended Message Format"),
          TAGGED_IMAGE_FILE_FORMAT_ADOBE_ALDUS_IMAGE_DATA(3, "Tagged Image File Format Adobe/Aldus Image data)"),
          ILLUSTRATOR_ADOBE_GRAPHICS_DATA(4, "Illustrator Adobe Graphics data)"),
          APPLESINGLE_APPLE_COMPUTER_INC(5, "AppleSingle Apple Computer Inc)"),
          NAA_89_3_ANPA_1312(6, "NAA 89-3 ANPA 1312"),
          MACBINARY_II(7, "MacBinary II"),
          IPTC_UNSTRUCTURED_CHARACTER_ORIENTED_FILE_FORMAT_UCOFF(8, "IPTC Unstructured Character Oriented File Format UCOFF)"),
          UNITED_PRESS_INTERNATIONAL_ANPA_1312_VARIANT(9, "United Press International ANPA 1312 variant"),
          UNITED_PRESS_INTERNATIONAL_DOWN_LOAD_MESSAGE(10, "United Press International Down-Load Message"),
          JPEG_FILE_INTERCHANGE_JFIF(11, "JPEG File Interchange JFIF)"),
          PHOTO_CD_IMAGE_PAC_EASTMAN_KODAK(12, "Photo-CD Image-Pac Eastman Kodak)"),
          BIT_MAPPED_GRAPHICS_FILE_BMP_MICROSOFT(13, "Bit Mapped Graphics File BMP Microsoft)"),
          DIGITAL_AUDIO_FILE_WAV_MICROSOFT__CREATIVE_LABS(14, "Digital Audio File WAV Microsoft  Creative Labs)"),
          AUDIO_PLUS_MOVING_VIDEO_AVI_MICROSOFT(15, "Audio plus Moving Video AVI Microsoft)"),
          PC_DOS_WINDOWS_EXECUTABLE_FILES_COMEXE(16, "PC DOS/Windows Executable Files COMEXE"),
          COMPRESSED_BINARY_FILE_ZIP_PKWARE_INC(17, "Compressed Binary File ZIP PKWare Inc)"),
          AUDIO_INTERCHANGE_FILE_FORMAT_AIFF_APPLE_COMPUTER_INC(18, "Audio Interchange File Format AIFF Apple Computer Inc)"),
          RIFF_WAVE_MICROSOFT_CORPORATION(19, "RIFF Wave Microsoft Corporation)"),
          FREEHAND_MACROMEDIA_ALDUS(20, "Freehand Macromedia/Aldus)"),
          HYPERTEXT_MARKUP_LANGUAGE_HTML_THE_INTERNET_SOCIETY(21, "Hypertext Markup Language HTML The Internet Society)"),
          MPEG_2_AUDIO_LAYER_2_MUSICOM(22, "MPEG 2 Audio Layer 2 Musicom)"),
          MPEG_2_AUDIO_LAYER_3(23, "MPEG 2 Audio Layer 3"),
          PORTABLE_DOCUMENT_FILE_PDF_ADOBE(24, "Portable Document File PDF Adobe"),
          NEWS_INDUSTRY_TEXT_FORMAT_NITF(25, "News Industry Text Format NITF)"),
          TAPE_ARCHIVE_TAR(26, "Tape Archive TAR"),
          TIDNINGARNAS_TELEGRAMBYRA_NITF_VERSION_TTNITF_DTD(27, "Tidningarnas Telegrambyra NITF version TTNITF DTD)"),
          RITZAUS_BUREAU_NITF_VERSION_RBNITF_DTD(28, "Ritzaus Bureau NITF version RBNITF DTD)"),
          COREL_DRAW_CDR(29, "Corel Draw CDR"),
          
         _UNKNOWN(-1, "_unknown_");

         private final static long serialVersionUID = 3059468666726854749L;
         private final int value;
         private final String name;

         @Nonnull
         public static ObjectPreviewFileFormat fromInteger (final int value)
           {
                          if (value == 0) return NO_OBJECTDATA;
              if (value == 1) return IPTC_NAA_DIGITAL_NEWSPHOTO_PARAMETER_RECORD;
              if (value == 2) return IPTC7901_RECOMMENDED_MESSAGE_FORMAT;
              if (value == 3) return TAGGED_IMAGE_FILE_FORMAT_ADOBE_ALDUS_IMAGE_DATA;
              if (value == 4) return ILLUSTRATOR_ADOBE_GRAPHICS_DATA;
              if (value == 5) return APPLESINGLE_APPLE_COMPUTER_INC;
              if (value == 6) return NAA_89_3_ANPA_1312;
              if (value == 7) return MACBINARY_II;
              if (value == 8) return IPTC_UNSTRUCTURED_CHARACTER_ORIENTED_FILE_FORMAT_UCOFF;
              if (value == 9) return UNITED_PRESS_INTERNATIONAL_ANPA_1312_VARIANT;
              if (value == 10) return UNITED_PRESS_INTERNATIONAL_DOWN_LOAD_MESSAGE;
              if (value == 11) return JPEG_FILE_INTERCHANGE_JFIF;
              if (value == 12) return PHOTO_CD_IMAGE_PAC_EASTMAN_KODAK;
              if (value == 13) return BIT_MAPPED_GRAPHICS_FILE_BMP_MICROSOFT;
              if (value == 14) return DIGITAL_AUDIO_FILE_WAV_MICROSOFT__CREATIVE_LABS;
              if (value == 15) return AUDIO_PLUS_MOVING_VIDEO_AVI_MICROSOFT;
              if (value == 16) return PC_DOS_WINDOWS_EXECUTABLE_FILES_COMEXE;
              if (value == 17) return COMPRESSED_BINARY_FILE_ZIP_PKWARE_INC;
              if (value == 18) return AUDIO_INTERCHANGE_FILE_FORMAT_AIFF_APPLE_COMPUTER_INC;
              if (value == 19) return RIFF_WAVE_MICROSOFT_CORPORATION;
              if (value == 20) return FREEHAND_MACROMEDIA_ALDUS;
              if (value == 21) return HYPERTEXT_MARKUP_LANGUAGE_HTML_THE_INTERNET_SOCIETY;
              if (value == 22) return MPEG_2_AUDIO_LAYER_2_MUSICOM;
              if (value == 23) return MPEG_2_AUDIO_LAYER_3;
              if (value == 24) return PORTABLE_DOCUMENT_FILE_PDF_ADOBE;
              if (value == 25) return NEWS_INDUSTRY_TEXT_FORMAT_NITF;
              if (value == 26) return TAPE_ARCHIVE_TAR;
              if (value == 27) return TIDNINGARNAS_TELEGRAMBYRA_NITF_VERSION_TTNITF_DTD;
              if (value == 28) return RITZAUS_BUREAU_NITF_VERSION_RBNITF_DTD;
              if (value == 29) return COREL_DRAW_CDR;
              
             return _UNKNOWN;
           }
       }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_PREVIEW_FILE_FORMAT}. If the value is changed, property change events will be fired
     * for {@code "objectPreviewFileFormat"} and {@code "latestModificationTime}.
     *
     * @param   objectPreviewFileFormat     the new value of {@code OBJECT_PREVIEW_FILE_FORMAT}
     *
     ******************************************************************************************************************/
    public void setObjectPreviewFileFormat (@Nonnull final ObjectPreviewFileFormat objectPreviewFileFormat)
      {
        requireNonNull(objectPreviewFileFormat, "objectPreviewFileFormat");
        setObjectPreviewFileFormat(Optional.of(objectPreviewFileFormat));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_PREVIEW_FILE_FORMAT}. If the value is changed, property change events will be fired
     * for {@code "objectPreviewFileFormat"} and {@code "latestModificationTime}.
     *
     * @param   objectPreviewFileFormat     the new value of {@code OBJECT_PREVIEW_FILE_FORMAT}
     *
     ******************************************************************************************************************/
    public void setObjectPreviewFileFormat (@Nonnull final Optional<ObjectPreviewFileFormat> objectPreviewFileFormat)
      {
        requireNonNull(objectPreviewFileFormat, "objectPreviewFileFormat");
        set(IPTCDirectoryGenerated.OBJECT_PREVIEW_FILE_FORMAT, objectPreviewFileFormat);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code OBJECT_PREVIEW_FILE_FORMAT}.
     *
     * @return  the current value of objectPreviewFileFormat
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<ObjectPreviewFileFormat> getObjectPreviewFileFormat()
      {
        return get(OBJECT_PREVIEW_FILE_FORMAT, ObjectPreviewFileFormat.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_PREVIEW_FILE_VERSION}. If the value is changed, property change events will be fired
     * for {@code "objectPreviewFileVersion"} and {@code "latestModificationTime}.
     *
     * @param   objectPreviewFileVersion     the new value of {@code OBJECT_PREVIEW_FILE_VERSION}
     *
     ******************************************************************************************************************/
    public void setObjectPreviewFileVersion (@Nonnull final Integer objectPreviewFileVersion)
      {
        requireNonNull(objectPreviewFileVersion, "objectPreviewFileVersion");
        setObjectPreviewFileVersion(Optional.of(objectPreviewFileVersion));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_PREVIEW_FILE_VERSION}. If the value is changed, property change events will be fired
     * for {@code "objectPreviewFileVersion"} and {@code "latestModificationTime}.
     *
     * @param   objectPreviewFileVersion     the new value of {@code OBJECT_PREVIEW_FILE_VERSION}
     *
     ******************************************************************************************************************/
    public void setObjectPreviewFileVersion (@Nonnull final Optional<Integer> objectPreviewFileVersion)
      {
        requireNonNull(objectPreviewFileVersion, "objectPreviewFileVersion");
        set(IPTCDirectoryGenerated.OBJECT_PREVIEW_FILE_VERSION, objectPreviewFileVersion);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code OBJECT_PREVIEW_FILE_VERSION}.
     *
     * @return  the current value of objectPreviewFileVersion
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<Integer> getObjectPreviewFileVersion()
      {
        return get(OBJECT_PREVIEW_FILE_VERSION, Integer.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_PREVIEW_DATA}. If the value is changed, property change events will be fired
     * for {@code "objectPreviewData"} and {@code "latestModificationTime}.
     *
     * @param   objectPreviewData     the new value of {@code OBJECT_PREVIEW_DATA}
     *
     ******************************************************************************************************************/
    public void setObjectPreviewData (@Nonnull final String objectPreviewData)
      {
        requireNonNull(objectPreviewData, "objectPreviewData");
        setObjectPreviewData(Optional.of(objectPreviewData));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code OBJECT_PREVIEW_DATA}. If the value is changed, property change events will be fired
     * for {@code "objectPreviewData"} and {@code "latestModificationTime}.
     *
     * @param   objectPreviewData     the new value of {@code OBJECT_PREVIEW_DATA}
     *
     ******************************************************************************************************************/
    public void setObjectPreviewData (@Nonnull final Optional<String> objectPreviewData)
      {
        requireNonNull(objectPreviewData, "objectPreviewData");
        set(IPTCDirectoryGenerated.OBJECT_PREVIEW_DATA, objectPreviewData);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code OBJECT_PREVIEW_DATA}.
     *
     * @return  the current value of objectPreviewData
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getObjectPreviewData()
      {
        return get(OBJECT_PREVIEW_DATA, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code PREFS}. If the value is changed, property change events will be fired
     * for {@code "prefs"} and {@code "latestModificationTime}.
     *
     * @param   prefs     the new value of {@code PREFS}
     *
     ******************************************************************************************************************/
    public void setPrefs (@Nonnull final String prefs)
      {
        requireNonNull(prefs, "prefs");
        setPrefs(Optional.of(prefs));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code PREFS}. If the value is changed, property change events will be fired
     * for {@code "prefs"} and {@code "latestModificationTime}.
     *
     * @param   prefs     the new value of {@code PREFS}
     *
     ******************************************************************************************************************/
    public void setPrefs (@Nonnull final Optional<String> prefs)
      {
        requireNonNull(prefs, "prefs");
        set(IPTCDirectoryGenerated.PREFS, prefs);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code PREFS}.
     *
     * @return  the current value of prefs
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getPrefs()
      {
        return get(PREFS, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CLASSIFY_STATE}. If the value is changed, property change events will be fired
     * for {@code "classifyState"} and {@code "latestModificationTime}.
     *
     * @param   classifyState     the new value of {@code CLASSIFY_STATE}
     *
     ******************************************************************************************************************/
    public void setClassifyState (@Nonnull final String classifyState)
      {
        requireNonNull(classifyState, "classifyState");
        setClassifyState(Optional.of(classifyState));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code CLASSIFY_STATE}. If the value is changed, property change events will be fired
     * for {@code "classifyState"} and {@code "latestModificationTime}.
     *
     * @param   classifyState     the new value of {@code CLASSIFY_STATE}
     *
     ******************************************************************************************************************/
    public void setClassifyState (@Nonnull final Optional<String> classifyState)
      {
        requireNonNull(classifyState, "classifyState");
        set(IPTCDirectoryGenerated.CLASSIFY_STATE, classifyState);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code CLASSIFY_STATE}.
     *
     * @return  the current value of classifyState
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getClassifyState()
      {
        return get(CLASSIFY_STATE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SIMILARITY_INDEX}. If the value is changed, property change events will be fired
     * for {@code "similarityIndex"} and {@code "latestModificationTime}.
     *
     * @param   similarityIndex     the new value of {@code SIMILARITY_INDEX}
     *
     ******************************************************************************************************************/
    public void setSimilarityIndex (@Nonnull final String similarityIndex)
      {
        requireNonNull(similarityIndex, "similarityIndex");
        setSimilarityIndex(Optional.of(similarityIndex));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code SIMILARITY_INDEX}. If the value is changed, property change events will be fired
     * for {@code "similarityIndex"} and {@code "latestModificationTime}.
     *
     * @param   similarityIndex     the new value of {@code SIMILARITY_INDEX}
     *
     ******************************************************************************************************************/
    public void setSimilarityIndex (@Nonnull final Optional<String> similarityIndex)
      {
        requireNonNull(similarityIndex, "similarityIndex");
        set(IPTCDirectoryGenerated.SIMILARITY_INDEX, similarityIndex);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code SIMILARITY_INDEX}.
     *
     * @return  the current value of similarityIndex
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getSimilarityIndex()
      {
        return get(SIMILARITY_INDEX, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DOCUMENT_NOTES}. If the value is changed, property change events will be fired
     * for {@code "documentNotes"} and {@code "latestModificationTime}.
     *
     * @param   documentNotes     the new value of {@code DOCUMENT_NOTES}
     *
     ******************************************************************************************************************/
    public void setDocumentNotes (@Nonnull final String documentNotes)
      {
        requireNonNull(documentNotes, "documentNotes");
        setDocumentNotes(Optional.of(documentNotes));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DOCUMENT_NOTES}. If the value is changed, property change events will be fired
     * for {@code "documentNotes"} and {@code "latestModificationTime}.
     *
     * @param   documentNotes     the new value of {@code DOCUMENT_NOTES}
     *
     ******************************************************************************************************************/
    public void setDocumentNotes (@Nonnull final Optional<String> documentNotes)
      {
        requireNonNull(documentNotes, "documentNotes");
        set(IPTCDirectoryGenerated.DOCUMENT_NOTES, documentNotes);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code DOCUMENT_NOTES}.
     *
     * @return  the current value of documentNotes
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getDocumentNotes()
      {
        return get(DOCUMENT_NOTES, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DOCUMENT_HISTORY}. If the value is changed, property change events will be fired
     * for {@code "documentHistory"} and {@code "latestModificationTime}.
     *
     * @param   documentHistory     the new value of {@code DOCUMENT_HISTORY}
     *
     ******************************************************************************************************************/
    public void setDocumentHistory (@Nonnull final String documentHistory)
      {
        requireNonNull(documentHistory, "documentHistory");
        setDocumentHistory(Optional.of(documentHistory));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code DOCUMENT_HISTORY}. If the value is changed, property change events will be fired
     * for {@code "documentHistory"} and {@code "latestModificationTime}.
     *
     * @param   documentHistory     the new value of {@code DOCUMENT_HISTORY}
     *
     ******************************************************************************************************************/
    public void setDocumentHistory (@Nonnull final Optional<String> documentHistory)
      {
        requireNonNull(documentHistory, "documentHistory");
        set(IPTCDirectoryGenerated.DOCUMENT_HISTORY, documentHistory);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code DOCUMENT_HISTORY}.
     *
     * @return  the current value of documentHistory
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getDocumentHistory()
      {
        return get(DOCUMENT_HISTORY, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EXIF_CAMERA_INFO}. If the value is changed, property change events will be fired
     * for {@code "EXIFCameraInfo"} and {@code "latestModificationTime}.
     *
     * @param   EXIFCameraInfo     the new value of {@code EXIF_CAMERA_INFO}
     *
     ******************************************************************************************************************/
    public void setEXIFCameraInfo (@Nonnull final String EXIFCameraInfo)
      {
        requireNonNull(EXIFCameraInfo, "EXIFCameraInfo");
        setEXIFCameraInfo(Optional.of(EXIFCameraInfo));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code EXIF_CAMERA_INFO}. If the value is changed, property change events will be fired
     * for {@code "EXIFCameraInfo"} and {@code "latestModificationTime}.
     *
     * @param   EXIFCameraInfo     the new value of {@code EXIF_CAMERA_INFO}
     *
     ******************************************************************************************************************/
    public void setEXIFCameraInfo (@Nonnull final Optional<String> EXIFCameraInfo)
      {
        requireNonNull(EXIFCameraInfo, "EXIFCameraInfo");
        set(IPTCDirectoryGenerated.EXIF_CAMERA_INFO, EXIFCameraInfo);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code EXIF_CAMERA_INFO}.
     *
     * @return  the current value of EXIFCameraInfo
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getEXIFCameraInfo()
      {
        return get(EXIF_CAMERA_INFO, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_ADDRESS}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorAddress"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorAddress     the new value of {@code ADOBE_CREATOR_ADDRESS}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorAddress (@Nonnull final String adobeCreatorAddress)
      {
        requireNonNull(adobeCreatorAddress, "adobeCreatorAddress");
        setAdobeCreatorAddress(Optional.of(adobeCreatorAddress));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_ADDRESS}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorAddress"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorAddress     the new value of {@code ADOBE_CREATOR_ADDRESS}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorAddress (@Nonnull final Optional<String> adobeCreatorAddress)
      {
        requireNonNull(adobeCreatorAddress, "adobeCreatorAddress");
        set(IPTCDirectoryGenerated.ADOBE_CREATOR_ADDRESS, adobeCreatorAddress);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_CREATOR_ADDRESS}.
     *
     * @return  the current value of adobeCreatorAddress
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCreatorAddress()
      {
        return get(ADOBE_CREATOR_ADDRESS, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_CITY}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorCity"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorCity     the new value of {@code ADOBE_CREATOR_CITY}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorCity (@Nonnull final String adobeCreatorCity)
      {
        requireNonNull(adobeCreatorCity, "adobeCreatorCity");
        setAdobeCreatorCity(Optional.of(adobeCreatorCity));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_CITY}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorCity"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorCity     the new value of {@code ADOBE_CREATOR_CITY}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorCity (@Nonnull final Optional<String> adobeCreatorCity)
      {
        requireNonNull(adobeCreatorCity, "adobeCreatorCity");
        set(IPTCDirectoryGenerated.ADOBE_CREATOR_CITY, adobeCreatorCity);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_CREATOR_CITY}.
     *
     * @return  the current value of adobeCreatorCity
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCreatorCity()
      {
        return get(ADOBE_CREATOR_CITY, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_STATE__PROVINCE}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorStateProvince"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorStateProvince     the new value of {@code ADOBE_CREATOR_STATE__PROVINCE}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorStateProvince (@Nonnull final String adobeCreatorStateProvince)
      {
        requireNonNull(adobeCreatorStateProvince, "adobeCreatorStateProvince");
        setAdobeCreatorStateProvince(Optional.of(adobeCreatorStateProvince));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_STATE__PROVINCE}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorStateProvince"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorStateProvince     the new value of {@code ADOBE_CREATOR_STATE__PROVINCE}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorStateProvince (@Nonnull final Optional<String> adobeCreatorStateProvince)
      {
        requireNonNull(adobeCreatorStateProvince, "adobeCreatorStateProvince");
        set(IPTCDirectoryGenerated.ADOBE_CREATOR_STATE__PROVINCE, adobeCreatorStateProvince);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_CREATOR_STATE__PROVINCE}.
     *
     * @return  the current value of adobeCreatorStateProvince
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCreatorStateProvince()
      {
        return get(ADOBE_CREATOR_STATE__PROVINCE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_POSTAL_CODE}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorPostalCode"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorPostalCode     the new value of {@code ADOBE_CREATOR_POSTAL_CODE}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorPostalCode (@Nonnull final String adobeCreatorPostalCode)
      {
        requireNonNull(adobeCreatorPostalCode, "adobeCreatorPostalCode");
        setAdobeCreatorPostalCode(Optional.of(adobeCreatorPostalCode));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_POSTAL_CODE}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorPostalCode"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorPostalCode     the new value of {@code ADOBE_CREATOR_POSTAL_CODE}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorPostalCode (@Nonnull final Optional<String> adobeCreatorPostalCode)
      {
        requireNonNull(adobeCreatorPostalCode, "adobeCreatorPostalCode");
        set(IPTCDirectoryGenerated.ADOBE_CREATOR_POSTAL_CODE, adobeCreatorPostalCode);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_CREATOR_POSTAL_CODE}.
     *
     * @return  the current value of adobeCreatorPostalCode
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCreatorPostalCode()
      {
        return get(ADOBE_CREATOR_POSTAL_CODE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_COUNTRY}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorCountry"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorCountry     the new value of {@code ADOBE_CREATOR_COUNTRY}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorCountry (@Nonnull final String adobeCreatorCountry)
      {
        requireNonNull(adobeCreatorCountry, "adobeCreatorCountry");
        setAdobeCreatorCountry(Optional.of(adobeCreatorCountry));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_COUNTRY}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorCountry"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorCountry     the new value of {@code ADOBE_CREATOR_COUNTRY}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorCountry (@Nonnull final Optional<String> adobeCreatorCountry)
      {
        requireNonNull(adobeCreatorCountry, "adobeCreatorCountry");
        set(IPTCDirectoryGenerated.ADOBE_CREATOR_COUNTRY, adobeCreatorCountry);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_CREATOR_COUNTRY}.
     *
     * @return  the current value of adobeCreatorCountry
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCreatorCountry()
      {
        return get(ADOBE_CREATOR_COUNTRY, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_PHONE}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorPhone"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorPhone     the new value of {@code ADOBE_CREATOR_PHONE}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorPhone (@Nonnull final String adobeCreatorPhone)
      {
        requireNonNull(adobeCreatorPhone, "adobeCreatorPhone");
        setAdobeCreatorPhone(Optional.of(adobeCreatorPhone));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_PHONE}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorPhone"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorPhone     the new value of {@code ADOBE_CREATOR_PHONE}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorPhone (@Nonnull final Optional<String> adobeCreatorPhone)
      {
        requireNonNull(adobeCreatorPhone, "adobeCreatorPhone");
        set(IPTCDirectoryGenerated.ADOBE_CREATOR_PHONE, adobeCreatorPhone);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_CREATOR_PHONE}.
     *
     * @return  the current value of adobeCreatorPhone
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCreatorPhone()
      {
        return get(ADOBE_CREATOR_PHONE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_EMAIL}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorEmail"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorEmail     the new value of {@code ADOBE_CREATOR_EMAIL}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorEmail (@Nonnull final String adobeCreatorEmail)
      {
        requireNonNull(adobeCreatorEmail, "adobeCreatorEmail");
        setAdobeCreatorEmail(Optional.of(adobeCreatorEmail));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_EMAIL}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorEmail"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorEmail     the new value of {@code ADOBE_CREATOR_EMAIL}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorEmail (@Nonnull final Optional<String> adobeCreatorEmail)
      {
        requireNonNull(adobeCreatorEmail, "adobeCreatorEmail");
        set(IPTCDirectoryGenerated.ADOBE_CREATOR_EMAIL, adobeCreatorEmail);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_CREATOR_EMAIL}.
     *
     * @return  the current value of adobeCreatorEmail
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCreatorEmail()
      {
        return get(ADOBE_CREATOR_EMAIL, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_WEBSITE}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorWebsite"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorWebsite     the new value of {@code ADOBE_CREATOR_WEBSITE}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorWebsite (@Nonnull final String adobeCreatorWebsite)
      {
        requireNonNull(adobeCreatorWebsite, "adobeCreatorWebsite");
        setAdobeCreatorWebsite(Optional.of(adobeCreatorWebsite));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_CREATOR_WEBSITE}. If the value is changed, property change events will be fired
     * for {@code "adobeCreatorWebsite"} and {@code "latestModificationTime}.
     *
     * @param   adobeCreatorWebsite     the new value of {@code ADOBE_CREATOR_WEBSITE}
     *
     ******************************************************************************************************************/
    public void setAdobeCreatorWebsite (@Nonnull final Optional<String> adobeCreatorWebsite)
      {
        requireNonNull(adobeCreatorWebsite, "adobeCreatorWebsite");
        set(IPTCDirectoryGenerated.ADOBE_CREATOR_WEBSITE, adobeCreatorWebsite);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_CREATOR_WEBSITE}.
     *
     * @return  the current value of adobeCreatorWebsite
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCreatorWebsite()
      {
        return get(ADOBE_CREATOR_WEBSITE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_IPTC_SUBJECT_CODE}. If the value is changed, property change events will be fired
     * for {@code "adobeIPTCSubjectCode"} and {@code "latestModificationTime}.
     *
     * @param   adobeIPTCSubjectCode     the new value of {@code ADOBE_IPTC_SUBJECT_CODE}
     *
     ******************************************************************************************************************/
    public void setAdobeIPTCSubjectCode (@Nonnull final String adobeIPTCSubjectCode)
      {
        requireNonNull(adobeIPTCSubjectCode, "adobeIPTCSubjectCode");
        setAdobeIPTCSubjectCode(Optional.of(adobeIPTCSubjectCode));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_IPTC_SUBJECT_CODE}. If the value is changed, property change events will be fired
     * for {@code "adobeIPTCSubjectCode"} and {@code "latestModificationTime}.
     *
     * @param   adobeIPTCSubjectCode     the new value of {@code ADOBE_IPTC_SUBJECT_CODE}
     *
     ******************************************************************************************************************/
    public void setAdobeIPTCSubjectCode (@Nonnull final Optional<String> adobeIPTCSubjectCode)
      {
        requireNonNull(adobeIPTCSubjectCode, "adobeIPTCSubjectCode");
        set(IPTCDirectoryGenerated.ADOBE_IPTC_SUBJECT_CODE, adobeIPTCSubjectCode);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_IPTC_SUBJECT_CODE}.
     *
     * @return  the current value of adobeIPTCSubjectCode
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeIPTCSubjectCode()
      {
        return get(ADOBE_IPTC_SUBJECT_CODE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_INTELLECTUAL_GENRE}. If the value is changed, property change events will be fired
     * for {@code "adobeIntellectualGenre"} and {@code "latestModificationTime}.
     *
     * @param   adobeIntellectualGenre     the new value of {@code ADOBE_INTELLECTUAL_GENRE}
     *
     ******************************************************************************************************************/
    public void setAdobeIntellectualGenre (@Nonnull final String adobeIntellectualGenre)
      {
        requireNonNull(adobeIntellectualGenre, "adobeIntellectualGenre");
        setAdobeIntellectualGenre(Optional.of(adobeIntellectualGenre));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_INTELLECTUAL_GENRE}. If the value is changed, property change events will be fired
     * for {@code "adobeIntellectualGenre"} and {@code "latestModificationTime}.
     *
     * @param   adobeIntellectualGenre     the new value of {@code ADOBE_INTELLECTUAL_GENRE}
     *
     ******************************************************************************************************************/
    public void setAdobeIntellectualGenre (@Nonnull final Optional<String> adobeIntellectualGenre)
      {
        requireNonNull(adobeIntellectualGenre, "adobeIntellectualGenre");
        set(IPTCDirectoryGenerated.ADOBE_INTELLECTUAL_GENRE, adobeIntellectualGenre);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_INTELLECTUAL_GENRE}.
     *
     * @return  the current value of adobeIntellectualGenre
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeIntellectualGenre()
      {
        return get(ADOBE_INTELLECTUAL_GENRE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_SCENE}. If the value is changed, property change events will be fired
     * for {@code "adobeScene"} and {@code "latestModificationTime}.
     *
     * @param   adobeScene     the new value of {@code ADOBE_SCENE}
     *
     ******************************************************************************************************************/
    public void setAdobeScene (@Nonnull final String adobeScene)
      {
        requireNonNull(adobeScene, "adobeScene");
        setAdobeScene(Optional.of(adobeScene));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_SCENE}. If the value is changed, property change events will be fired
     * for {@code "adobeScene"} and {@code "latestModificationTime}.
     *
     * @param   adobeScene     the new value of {@code ADOBE_SCENE}
     *
     ******************************************************************************************************************/
    public void setAdobeScene (@Nonnull final Optional<String> adobeScene)
      {
        requireNonNull(adobeScene, "adobeScene");
        set(IPTCDirectoryGenerated.ADOBE_SCENE, adobeScene);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_SCENE}.
     *
     * @return  the current value of adobeScene
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeScene()
      {
        return get(ADOBE_SCENE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_LOCATION}. If the value is changed, property change events will be fired
     * for {@code "adobeLocation"} and {@code "latestModificationTime}.
     *
     * @param   adobeLocation     the new value of {@code ADOBE_LOCATION}
     *
     ******************************************************************************************************************/
    public void setAdobeLocation (@Nonnull final String adobeLocation)
      {
        requireNonNull(adobeLocation, "adobeLocation");
        setAdobeLocation(Optional.of(adobeLocation));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_LOCATION}. If the value is changed, property change events will be fired
     * for {@code "adobeLocation"} and {@code "latestModificationTime}.
     *
     * @param   adobeLocation     the new value of {@code ADOBE_LOCATION}
     *
     ******************************************************************************************************************/
    public void setAdobeLocation (@Nonnull final Optional<String> adobeLocation)
      {
        requireNonNull(adobeLocation, "adobeLocation");
        set(IPTCDirectoryGenerated.ADOBE_LOCATION, adobeLocation);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_LOCATION}.
     *
     * @return  the current value of adobeLocation
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeLocation()
      {
        return get(ADOBE_LOCATION, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_COUNTRY_ISO_CODE}. If the value is changed, property change events will be fired
     * for {@code "adobeCountryISOCode"} and {@code "latestModificationTime}.
     *
     * @param   adobeCountryISOCode     the new value of {@code ADOBE_COUNTRY_ISO_CODE}
     *
     ******************************************************************************************************************/
    public void setAdobeCountryISOCode (@Nonnull final String adobeCountryISOCode)
      {
        requireNonNull(adobeCountryISOCode, "adobeCountryISOCode");
        setAdobeCountryISOCode(Optional.of(adobeCountryISOCode));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_COUNTRY_ISO_CODE}. If the value is changed, property change events will be fired
     * for {@code "adobeCountryISOCode"} and {@code "latestModificationTime}.
     *
     * @param   adobeCountryISOCode     the new value of {@code ADOBE_COUNTRY_ISO_CODE}
     *
     ******************************************************************************************************************/
    public void setAdobeCountryISOCode (@Nonnull final Optional<String> adobeCountryISOCode)
      {
        requireNonNull(adobeCountryISOCode, "adobeCountryISOCode");
        set(IPTCDirectoryGenerated.ADOBE_COUNTRY_ISO_CODE, adobeCountryISOCode);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_COUNTRY_ISO_CODE}.
     *
     * @return  the current value of adobeCountryISOCode
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCountryISOCode()
      {
        return get(ADOBE_COUNTRY_ISO_CODE, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_COPYRIGHT_STATUS}. If the value is changed, property change events will be fired
     * for {@code "adobeCopyrightStatus"} and {@code "latestModificationTime}.
     *
     * @param   adobeCopyrightStatus     the new value of {@code ADOBE_COPYRIGHT_STATUS}
     *
     ******************************************************************************************************************/
    public void setAdobeCopyrightStatus (@Nonnull final String adobeCopyrightStatus)
      {
        requireNonNull(adobeCopyrightStatus, "adobeCopyrightStatus");
        setAdobeCopyrightStatus(Optional.of(adobeCopyrightStatus));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_COPYRIGHT_STATUS}. If the value is changed, property change events will be fired
     * for {@code "adobeCopyrightStatus"} and {@code "latestModificationTime}.
     *
     * @param   adobeCopyrightStatus     the new value of {@code ADOBE_COPYRIGHT_STATUS}
     *
     ******************************************************************************************************************/
    public void setAdobeCopyrightStatus (@Nonnull final Optional<String> adobeCopyrightStatus)
      {
        requireNonNull(adobeCopyrightStatus, "adobeCopyrightStatus");
        set(IPTCDirectoryGenerated.ADOBE_COPYRIGHT_STATUS, adobeCopyrightStatus);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_COPYRIGHT_STATUS}.
     *
     * @return  the current value of adobeCopyrightStatus
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCopyrightStatus()
      {
        return get(ADOBE_COPYRIGHT_STATUS, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_RIGHT_USAGE_TERMS}. If the value is changed, property change events will be fired
     * for {@code "adobeRightUsageTerms"} and {@code "latestModificationTime}.
     *
     * @param   adobeRightUsageTerms     the new value of {@code ADOBE_RIGHT_USAGE_TERMS}
     *
     ******************************************************************************************************************/
    public void setAdobeRightUsageTerms (@Nonnull final String adobeRightUsageTerms)
      {
        requireNonNull(adobeRightUsageTerms, "adobeRightUsageTerms");
        setAdobeRightUsageTerms(Optional.of(adobeRightUsageTerms));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_RIGHT_USAGE_TERMS}. If the value is changed, property change events will be fired
     * for {@code "adobeRightUsageTerms"} and {@code "latestModificationTime}.
     *
     * @param   adobeRightUsageTerms     the new value of {@code ADOBE_RIGHT_USAGE_TERMS}
     *
     ******************************************************************************************************************/
    public void setAdobeRightUsageTerms (@Nonnull final Optional<String> adobeRightUsageTerms)
      {
        requireNonNull(adobeRightUsageTerms, "adobeRightUsageTerms");
        set(IPTCDirectoryGenerated.ADOBE_RIGHT_USAGE_TERMS, adobeRightUsageTerms);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_RIGHT_USAGE_TERMS}.
     *
     * @return  the current value of adobeRightUsageTerms
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeRightUsageTerms()
      {
        return get(ADOBE_RIGHT_USAGE_TERMS, String.class);
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_COPYRIGHT_INFO_URL}. If the value is changed, property change events will be fired
     * for {@code "adobeCopyrightInfoURL"} and {@code "latestModificationTime}.
     *
     * @param   adobeCopyrightInfoURL     the new value of {@code ADOBE_COPYRIGHT_INFO_URL}
     *
     ******************************************************************************************************************/
    public void setAdobeCopyrightInfoURL (@Nonnull final String adobeCopyrightInfoURL)
      {
        requireNonNull(adobeCopyrightInfoURL, "adobeCopyrightInfoURL");
        setAdobeCopyrightInfoURL(Optional.of(adobeCopyrightInfoURL));
      }

    /*******************************************************************************************************************
     *
     * Sets the property {@code ADOBE_COPYRIGHT_INFO_URL}. If the value is changed, property change events will be fired
     * for {@code "adobeCopyrightInfoURL"} and {@code "latestModificationTime}.
     *
     * @param   adobeCopyrightInfoURL     the new value of {@code ADOBE_COPYRIGHT_INFO_URL}
     *
     ******************************************************************************************************************/
    public void setAdobeCopyrightInfoURL (@Nonnull final Optional<String> adobeCopyrightInfoURL)
      {
        requireNonNull(adobeCopyrightInfoURL, "adobeCopyrightInfoURL");
        set(IPTCDirectoryGenerated.ADOBE_COPYRIGHT_INFO_URL, adobeCopyrightInfoURL);
      }

    /*******************************************************************************************************************
     *
     * Gets the property {@code ADOBE_COPYRIGHT_INFO_URL}.
     *
     * @return  the current value of adobeCopyrightInfoURL
     *
     ******************************************************************************************************************/
    @Nonnull
    public Optional<String> getAdobeCopyrightInfoURL()
      {
        return get(ADOBE_COPYRIGHT_INFO_URL, String.class);
      }
  }
