/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.EditableImage;
import it.tidalwave.image.ImageUtils;
import it.tidalwave.image.java2d.Java2DUtils;
import it.tidalwave.image.op.AssignColorProfileOp;
import it.tidalwave.image.op.OperationImplementation;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class AssignColorProfileJ2DOp
extends OperationImplementation<AssignColorProfileOp, BufferedImage> {
    private static final Logger log = LoggerFactory.getLogger(AssignColorProfileJ2DOp.class);

    @Nonnull
    protected BufferedImage execute(@Nonnull AssignColorProfileOp operation, @Nonnull EditableImage image, @Nonnull BufferedImage bufferedImage) {
        ICC_Profile targetProfile = operation.getIccProfile();
        log.trace("assignColorProfile({})", (Object)ImageUtils.getICCProfileName((ICC_Profile)targetProfile));
        Java2DUtils.logImage((Logger)log, (String)">>>> source bufferedImage", (RenderedImage)bufferedImage);
        ICC_ColorSpace colorSpace = new ICC_ColorSpace(targetProfile);
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, false, false, 1, bufferedImage.getRaster().getDataBuffer().getDataType());
        BufferedImage result = new BufferedImage(colorModel, bufferedImage.getRaster(), false, Java2DUtils.getProperties((BufferedImage)bufferedImage));
        Java2DUtils.logImage((Logger)log, (String)">>>> assignColorProfile() returning ", (RenderedImage)bufferedImage);
        return result;
    }
}

