/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.java2d;

import it.tidalwave.image.Histogram;
import it.tidalwave.image.render.PreviewSettings;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistogramJava2D
extends Histogram {
    private static final Logger log = LoggerFactory.getLogger(HistogramJava2D.class);
    private RenderedImage renderedImage;
    private int[][] bandData;
    private int[] max;
    private int[] min;
    private int shift;

    HistogramJava2D(RenderedImage renderedImage) {
        super((Object)renderedImage);
        this.renderedImage = renderedImage;
        this.compute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getFrequencies(int band) {
        this.validateBand(band);
        HistogramJava2D histogramJava2D = this;
        synchronized (histogramJava2D) {
            if (this.bandData == null) {
                this.compute();
            }
        }
        return this.bandData[band];
    }

    public int getMin(int band) {
        this.validateBand(band);
        return this.min[band];
    }

    public int getMax(int band) {
        this.validateBand(band);
        return this.max[band];
    }

    private void compute() {
        log.info("compute()");
        this.bandCount = this.renderedImage.getSampleModel().getNumBands();
        this.bitsPerBand = this.renderedImage.getSampleModel().getSampleSize(0);
        this.shift = 0;
        if (this.bitsPerBand == 16) {
            this.shift = 8;
        }
        this.bandData = new int[this.bandCount][1 << this.bitsPerBand - this.shift];
        this.min = new int[this.bandCount];
        this.max = new int[this.bandCount];
        log.info(">>>> Allocated bandData[" + this.bandData.length + "][" + this.bandData[0].length + "]");
        this.genericCompute();
    }

    public Histogram getPreview(PreviewSettings previewSetting) {
        HistogramJava2D previewHistogram = new HistogramJava2D(null);
        previewHistogram.bandCount = this.bandCount;
        previewHistogram.bandData = new int[this.bandCount][];
        byte[][] lut8bit = previewSetting.getLookupTable8bit().getTable();
        short[][] lut16bit = previewSetting.getLookupTable16bit().getTable();
        for (int band = 0; band < this.bandCount; ++band) {
            int len = this.bandData[band].length;
            previewHistogram.bandData[band] = new int[len];
            for (int i = 0; i < len; ++i) {
                int dst = len <= 256 ? lut8bit[band][i] & 0xFF : lut16bit[band][i] & 0xFFFF;
                int[] nArray = previewHistogram.bandData[band];
                int n = dst;
                nArray[n] = nArray[n] + this.bandData[band][i];
            }
        }
        return previewHistogram;
    }

    private void genericCompute() {
        WritableRaster raster = ((BufferedImage)this.image).getRaster();
        int w = this.renderedImage.getWidth();
        int h = this.renderedImage.getHeight();
        boolean first = true;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                for (int b = 0; b < this.bandCount; ++b) {
                    int v = raster.getSample(x, y, b) >> this.shift;
                    int[] nArray = this.bandData[b];
                    int n = v;
                    nArray[n] = nArray[n] + 1;
                    if (first) {
                        this.min[b] = this.max[b] = v;
                        continue;
                    }
                    if (v < this.min[b]) {
                        this.min[b] = v;
                        continue;
                    }
                    if (v <= this.max[b]) continue;
                    this.max[b] = v;
                }
                first = false;
            }
        }
    }
}

