/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.op;

import it.tidalwave.image.ImageUtils;
import it.tidalwave.image.op.Operation;
import java.awt.color.ICC_Profile;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ConvertColorProfileOp
extends Operation {
    @Nonnull
    private final ICC_Profile iccProfile;
    @Nonnull
    private final RenderingIntent renderingIntent;

    public ConvertColorProfileOp(@Nonnull ICC_Profile iccProfile) {
        this(iccProfile, RenderingIntent.PERCEPTUAL);
    }

    @Nonnull
    public String toString() {
        return String.format("ConvertColorProfileOp(%s, %s)", new Object[]{ImageUtils.getICCProfileName((ICC_Profile)this.iccProfile), this.renderingIntent});
    }

    public ConvertColorProfileOp(@Nonnull ICC_Profile iccProfile, @Nonnull RenderingIntent renderingIntent) {
        if (iccProfile == null) {
            throw new NullPointerException("iccProfile is marked non-null but is null");
        }
        if (renderingIntent == null) {
            throw new NullPointerException("renderingIntent is marked non-null but is null");
        }
        this.iccProfile = iccProfile;
        this.renderingIntent = renderingIntent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvertColorProfileOp)) {
            return false;
        }
        ConvertColorProfileOp other = (ConvertColorProfileOp)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ICC_Profile this$iccProfile = this.getIccProfile();
        ICC_Profile other$iccProfile = other.getIccProfile();
        if (this$iccProfile == null ? other$iccProfile != null : !this$iccProfile.equals(other$iccProfile)) {
            return false;
        }
        RenderingIntent this$renderingIntent = this.getRenderingIntent();
        RenderingIntent other$renderingIntent = other.getRenderingIntent();
        return !(this$renderingIntent == null ? other$renderingIntent != null : !((Object)((Object)this$renderingIntent)).equals((Object)other$renderingIntent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConvertColorProfileOp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ICC_Profile $iccProfile = this.getIccProfile();
        result = result * 59 + ($iccProfile == null ? 43 : $iccProfile.hashCode());
        RenderingIntent $renderingIntent = this.getRenderingIntent();
        result = result * 59 + ($renderingIntent == null ? 43 : ((Object)((Object)$renderingIntent)).hashCode());
        return result;
    }

    @Nonnull
    public ICC_Profile getIccProfile() {
        return this.iccProfile;
    }

    @Nonnull
    public RenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    public static enum RenderingIntent {
        ABSOLUTE,
        RELATIVE_COLORIMETRIC,
        PERCEPTUAL,
        SATURATION;

    }
}

