/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.northernwind.frontend.ui.component.blog.htmltemplate;

import it.tidalwave.northernwind.core.model.RequestContext;
import it.tidalwave.northernwind.core.model.RequestLocaleManager;
import it.tidalwave.northernwind.core.model.ResourceProperties;
import it.tidalwave.northernwind.core.model.Site;
import it.tidalwave.northernwind.core.model.SiteNode;
import it.tidalwave.northernwind.core.model.spi.RequestHolder;
import it.tidalwave.northernwind.frontend.ui.component.Properties;
import it.tidalwave.northernwind.frontend.ui.component.blog.BlogView;
import it.tidalwave.northernwind.frontend.ui.component.blog.htmltemplate.HtmlTemplateBlogViewController;
import it.tidalwave.util.Id;
import it.tidalwave.util.Key;
import it.tidalwave.util.NotFoundException;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.mockito.Mockito;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class HtmlTemplateBlogViewControllerTest {
    private HtmlTemplateBlogViewController underTest;
    private BlogView view;
    private SiteNode node;
    private Site site;
    private RequestHolder requestHolder;
    private RequestContext requestContext;
    private RequestLocaleManager requestLocaleManager;

    @BeforeMethod
    public void setupFixture() {
        this.view = (BlogView)Mockito.mock(BlogView.class);
        this.node = (SiteNode)Mockito.mock(SiteNode.class);
        this.site = (Site)Mockito.mock(Site.class);
        this.requestHolder = (RequestHolder)Mockito.mock(RequestHolder.class);
        this.requestContext = (RequestContext)Mockito.mock(RequestContext.class);
        this.requestLocaleManager = (RequestLocaleManager)Mockito.mock(RequestLocaleManager.class);
        this.underTest = new HtmlTemplateBlogViewController(this.view, this.node, this.site, this.requestHolder, this.requestContext, this.requestLocaleManager);
    }

    @Test(dataProvider="mainTitleTestDataProvider")
    public void must_properly_render_the_main_title(@Nonnull String viewId, @Nonnull String title, @Nonnull String expectedRendering) throws Exception {
        this.mockNodeProperty(viewId, Properties.PROPERTY_TITLE, title);
        StringBuilder builder = new StringBuilder();
        this.underTest.renderMainTitle(builder);
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)CoreMatchers.is((Object)expectedRendering));
    }

    @Test(dataProvider="dateTestDataProvider")
    public void must_properly_render_the_date(@Nonnull String viewId, @Nonnull String localeCode, @CheckForNull String dateFormat, @Nonnull DateTime dateTime, @Nonnull String expectedRendering) throws Exception {
        Locale locale = new Locale(localeCode);
        Mockito.when((Object)this.requestLocaleManager.getLocales()).thenReturn(Arrays.asList(locale));
        Mockito.when((Object)this.requestLocaleManager.getDateTimeFormatter()).thenReturn((Object)DateTimeFormat.fullDateTime().withLocale(locale));
        this.mockNodeProperty(viewId, Properties.PROPERTY_DATE_FORMAT, dateFormat);
        StringBuilder builder = new StringBuilder();
        this.underTest.renderDate(builder, dateTime);
        MatcherAssert.assertThat((Object)builder.toString(), (Matcher)CoreMatchers.is((Object)expectedRendering));
    }

    private void mockNodeProperty(@Nonnull String viewId, @Nonnull Key<?> propertyKey, @CheckForNull String propertyValue) throws Exception {
        Id id = new Id((Object)viewId);
        Mockito.when((Object)this.view.getId()).thenReturn((Object)id);
        ResourceProperties properties = (ResourceProperties)Mockito.mock(ResourceProperties.class);
        Mockito.when((Object)this.node.getPropertyGroup((Id)Mockito.eq((Object)id))).thenReturn((Object)properties);
        if (propertyValue != null) {
            Mockito.when((Object)properties.getProperty((Key)Mockito.eq(propertyKey))).thenReturn((Object)propertyValue);
        } else {
            Mockito.when((Object)properties.getProperty((Key)Mockito.eq(propertyKey))).thenThrow(new Throwable[]{new NotFoundException()});
        }
    }

    @DataProvider(name="mainTitleTestDataProvider")
    private Object[][] mainTitleTestDataProvider() {
        return new Object[][]{{"id1", "title1", "<h2>title1</h2>\n"}, {"id2", "title 2", "<h2>title 2</h2>\n"}, {"id3", "", ""}, {"id4", "  ", ""}};
    }

    @DataProvider(name="dateTestDataProvider")
    private Object[][] dateTestDataProvider() {
        DateTime dateTime = new DateTime(1344353463985L);
        return new Object[][]{{"id1", "en", null, dateTime, "<span class='nw-publishDate'>Tuesday, August 7, 2012 5:31:03 PM CEST</span>\n"}, {"id2", "it", null, dateTime, "<span class='nw-publishDate'>marted\u00ec 7 agosto 2012 17.31.03 CEST</span>\n"}, {"id3", "en", "EEEEEEEEEE, MMMMMM d, yyyy", dateTime, "<span class='nw-publishDate'>Tuesday, August 7, 2012</span>\n"}, {"id4", "it", "EEEEEEEEEE, MMMMMM d, yyyy", dateTime, "<span class='nw-publishDate'>marted\u00ec, agosto 7, 2012</span>\n"}, {"id5", "en", "S-", dateTime, "<span class='nw-publishDate'>8/7/12</span>\n"}, {"id6", "it", "S-", dateTime, "<span class='nw-publishDate'>07/08/12</span>\n"}, {"id5", "en", "M-", dateTime, "<span class='nw-publishDate'>Aug 7, 2012</span>\n"}, {"id6", "it", "M-", dateTime, "<span class='nw-publishDate'>7-ago-2012</span>\n"}, {"id5", "en", "L-", dateTime, "<span class='nw-publishDate'>August 7, 2012</span>\n"}, {"id6", "it", "L-", dateTime, "<span class='nw-publishDate'>7 agosto 2012</span>\n"}, {"id5", "en", "F-", dateTime, "<span class='nw-publishDate'>Tuesday, August 7, 2012</span>\n"}, {"id6", "it", "F-", dateTime, "<span class='nw-publishDate'>marted\u00ec 7 agosto 2012</span>\n"}};
    }
}

