/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.northernwind.frontend.ui.component.gallery.htmltemplate;

import it.tidalwave.northernwind.core.model.HttpStatusException;
import it.tidalwave.northernwind.core.model.RequestLocaleManager;
import it.tidalwave.northernwind.core.model.ResourceProperties;
import it.tidalwave.northernwind.core.model.Site;
import it.tidalwave.northernwind.core.model.SiteNode;
import it.tidalwave.northernwind.core.model.spi.RequestHolder;
import it.tidalwave.northernwind.frontend.ui.component.Properties;
import it.tidalwave.northernwind.frontend.ui.component.gallery.DefaultGalleryViewController;
import it.tidalwave.northernwind.frontend.ui.component.gallery.GalleryView;
import it.tidalwave.northernwind.frontend.ui.component.gallery.GalleryViewController;
import it.tidalwave.northernwind.frontend.ui.component.gallery.htmltemplate.bluette.BluetteGalleryAdapter;
import it.tidalwave.northernwind.frontend.ui.component.gallery.spi.GalleryAdapterContext;
import it.tidalwave.northernwind.frontend.ui.component.htmltemplate.TextHolder;
import it.tidalwave.northernwind.frontend.ui.component.nodecontainer.NodeContainerView;
import it.tidalwave.util.Id;
import it.tidalwave.util.NotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;

@Configurable
public class HtmlTemplateGalleryViewController
extends DefaultGalleryViewController {
    private static final Logger log;
    @Nonnull
    private final GalleryView view;
    @Nonnull
    private final SiteNode siteNode;
    @Nonnull
    private final RequestHolder requestHolder;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public HtmlTemplateGalleryViewController(final @Nonnull GalleryView view, final @Nonnull SiteNode siteNode, final @Nonnull Site site, @Nonnull RequestHolder requestHolder, @Nonnull RequestLocaleManager requestLocaleManager) throws IOException {
        super((NodeContainerView)view, siteNode, site, requestLocaleManager);
        GalleryView galleryView = view;
        SiteNode siteNode2 = siteNode;
        Site site2 = site;
        RequestHolder requestHolder2 = requestHolder;
        RequestLocaleManager requestLocaleManager2 = requestLocaleManager;
        Object[] objectArray = new Object[]{galleryView, siteNode2, site2, requestHolder2, requestLocaleManager2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        this.view = view;
        this.siteNode = siteNode;
        this.requestHolder = requestHolder;
        GalleryAdapterContext context = new GalleryAdapterContext(){

            public void addAttribute(@Nonnull String name, @Nonnull String value) {
                ((TextHolder)view).addAttribute(name, value);
            }

            @Nonnull
            public Site getSite() {
                return site;
            }

            @Nonnull
            public SiteNode getSiteNode() {
                return siteNode;
            }

            @Nonnull
            public GalleryView getView() {
                return view;
            }
        };
        this.galleryAdapter = new BluetteGalleryAdapter(context);
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    @PostConstruct
    void initializeHtmlTemplateGalleryViewController() throws HttpStatusException, IOException {
        String param = this.getParam().replaceAll("^/", "").replaceAll("/$", "");
        log.info(">>>> pathParams: *{}*", (Object)param);
        TextHolder textHolder = (TextHolder)this.view;
        String siteNodeTitle = (String)this.siteNode.getProperties().getProperty(Properties.PROPERTY_TITLE, (Object)"");
        if ("".equals(param)) {
            this.galleryAdapter.renderGallery(this.view, this.items);
            textHolder.addAttribute("title", siteNodeTitle);
        } else if ("images.xml".equals(param)) {
            this.galleryAdapter.renderCatalog(this.view, this.items);
        } else if ("lightbox".equals(param)) {
            this.galleryAdapter.renderLightboxFallback(this.view, this.items);
            textHolder.addAttribute("title", siteNodeTitle);
        } else {
            Id id = new Id((Object)param);
            GalleryViewController.Item item = (GalleryViewController.Item)this.itemMapById.get(id);
            if (item == null) {
                log.warn("Gallery item not found: {}, available: {}", (Object)id, this.itemMapById.keySet());
                throw new HttpStatusException(404);
            }
            this.galleryAdapter.renderFallback(this.view, item, this.items);
            textHolder.addAttribute("title", item.getDescription());
        }
    }

    @Nonnull
    private String getParam() {
        try {
            return this.requestHolder.get().getParameter("_escaped_fragment_");
        }
        catch (NotFoundException ex) {
            return this.requestHolder.get().getPathParams(this.siteNode);
        }
    }

    @Nonnull
    protected String computeInlinedScriptsSection() {
        return super.computeInlinedScriptsSection() + "\n" + this.galleryAdapter.getInlinedScript();
    }

    @Nonnull
    protected ResourceProperties getViewProperties() {
        return super.getViewProperties().merged(this.galleryAdapter.getExtraViewProperties(this.view.getId()));
    }

    static {
        HtmlTemplateGalleryViewController.ajc$preClinit();
        log = LoggerFactory.getLogger(HtmlTemplateGalleryViewController.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HtmlTemplateGalleryViewController.java", HtmlTemplateGalleryViewController.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "it.tidalwave.northernwind.frontend.ui.component.gallery.htmltemplate.HtmlTemplateGalleryViewController", "it.tidalwave.northernwind.frontend.ui.component.gallery.GalleryView:it.tidalwave.northernwind.core.model.SiteNode:it.tidalwave.northernwind.core.model.Site:it.tidalwave.northernwind.core.model.spi.RequestHolder:it.tidalwave.northernwind.core.model.RequestLocaleManager", "view:siteNode:site:requestHolder:requestLocaleManager", "java.io.IOException"), 81);
    }
}

