/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.northernwind.frontend.ui.component.blog.htmltemplate;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.tidalwave.northernwind.core.model.Content;
import it.tidalwave.northernwind.core.model.RequestContext;
import it.tidalwave.northernwind.core.model.RequestLocaleManager;
import it.tidalwave.northernwind.core.model.ResourceProperties;
import it.tidalwave.northernwind.core.model.Site;
import it.tidalwave.northernwind.core.model.SiteNode;
import it.tidalwave.northernwind.core.model.spi.RequestHolder;
import it.tidalwave.northernwind.frontend.ui.component.Properties;
import it.tidalwave.northernwind.frontend.ui.component.blog.BlogView;
import it.tidalwave.northernwind.frontend.ui.component.blog.DefaultBlogViewController;
import it.tidalwave.northernwind.frontend.ui.component.blog.htmltemplate.HtmlTemplateBlogView;
import it.tidalwave.northernwind.frontend.ui.component.htmltemplate.HtmlHolder;
import it.tidalwave.util.Key;
import it.tidalwave.util.NotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;

@Configurable
public class HtmlTemplateBlogViewController
extends DefaultBlogViewController {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log;
    private static final Key<String> PROP_ADD_TITLE;
    private static final Key<String> PROP_ADD_URL;
    private static final Key<String> PROP_ADD_ID;
    @Nonnull
    private final SiteNode siteNode;
    @Nonnull
    private final Site site;
    @Nonnull
    private final RequestLocaleManager requestLocaleManager;
    private boolean referencesRendered;
    private final List<String> htmlParts;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public HtmlTemplateBlogViewController(@Nonnull BlogView view, @Nonnull SiteNode siteNode, @Nonnull Site site, @Nonnull RequestHolder requestHolder, @Nonnull RequestContext requestContext, @Nonnull RequestLocaleManager requestLocaleManager) {
        super(view, siteNode, site, requestHolder, requestContext);
        BlogView blogView = view;
        SiteNode siteNode2 = siteNode;
        Site site2 = site;
        RequestHolder requestHolder2 = requestHolder;
        RequestContext requestContext2 = requestContext;
        RequestLocaleManager requestLocaleManager2 = requestLocaleManager;
        Object[] objectArray = new Object[]{blogView, siteNode2, site2, requestHolder2, requestContext2, requestLocaleManager2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        this.htmlParts = new ArrayList<String>();
        this.siteNode = siteNode;
        this.site = site;
        this.requestLocaleManager = requestLocaleManager;
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    protected void addFullPost(@Nonnull Content post) throws IOException, NotFoundException {
        log.debug("addFullPost()");
        this.addPost(post, true);
    }

    protected void addLeadInPost(@Nonnull Content post) throws IOException, NotFoundException {
        log.debug("addLeadInPost()");
        this.addPost(post, false);
    }

    protected void render() {
        StringBuilder htmlBuilder = new StringBuilder();
        this.renderMainTitle(htmlBuilder);
        for (String html : this.htmlParts) {
            htmlBuilder.append(html);
        }
        if (this.referencesRendered) {
            htmlBuilder.append("</ul>\n");
        }
        ((HtmlTemplateBlogView)this.view).addComponent(new HtmlHolder(htmlBuilder.toString()));
    }

    protected void addReference(@Nonnull Content post) throws IOException, NotFoundException {
        log.debug("addReference()");
        StringBuilder htmlBuilder = new StringBuilder();
        if (!this.referencesRendered) {
            htmlBuilder.append("<ul>\n");
            this.referencesRendered = true;
        }
        this.renderReferenceLink(htmlBuilder, post);
        this.htmlParts.add(htmlBuilder.toString());
    }

    private void addPost(@Nonnull Content post, boolean addBody) throws IOException, NotFoundException {
        log.debug("addPost({}, {})", (Object)post, (Object)addBody);
        ResourceProperties properties = post.getProperties();
        StringBuilder htmlBuilder = new StringBuilder();
        DateTime blogDateTime = properties.getDateTimeProperty((Collection)DefaultBlogViewController.DATE_KEYS, DefaultBlogViewController.TIME0);
        String idPrefix = "nw-" + this.view.getId() + "-blogpost-" + blogDateTime.toDate().getTime();
        htmlBuilder.append(String.format("<div id='%s' class='nw-blog-post'>%n", idPrefix));
        htmlBuilder.append(String.format("<h3>%s</h3>%n", properties.getProperty(Properties.PROPERTY_TITLE)));
        htmlBuilder.append("<div class='nw-blog-post-meta'>");
        this.renderDate(htmlBuilder, blogDateTime);
        this.renderCategory(htmlBuilder, post);
        this.renderTags(htmlBuilder, post);
        this.renderPermalink(htmlBuilder, post);
        htmlBuilder.append("</div>");
        if (addBody) {
            htmlBuilder.append(String.format("<div class='nw-blog-post-content'>%s</div>%n", properties.getProperty(Properties.PROPERTY_FULL_TEXT)));
            try {
                this.requestContext.setDynamicNodeProperty(PROP_ADD_ID, properties.getProperty(Properties.PROPERTY_ID));
            }
            catch (NotFoundException | IOException e) {
                log.debug("Can't set dynamic property " + PROP_ADD_ID, e);
            }
            this.requestContext.setDynamicNodeProperty(PROP_ADD_TITLE, (Object)this.computeTitle(post));
        }
        htmlBuilder.append(String.format("</div>%n", new Object[0]));
        this.htmlParts.add(htmlBuilder.toString());
    }

    protected void addTagCloud(Collection<DefaultBlogViewController.TagAndCount> tagsAndCount) throws IOException, NotFoundException {
        log.debug("addTagCloud({})", tagsAndCount);
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<div class='tagCloud'>");
        for (DefaultBlogViewController.TagAndCount tagAndCount : tagsAndCount) {
            String tag = tagAndCount.tag;
            String link = this.createTagLink(tag);
            htmlBuilder.append(String.format("<a href=\"%s\" class=\"tagCloudItem rank%s\" rel=\"%d\">%s</a>%n", link, tagAndCount.rank, tagAndCount.count, tag));
        }
        htmlBuilder.append(String.format("</div>%n", new Object[0]));
        this.htmlParts.add(htmlBuilder.toString());
    }

    @Nonnull
    private String computeTitle(@Nonnull Content post) {
        ResourceProperties properties = post.getProperties();
        StringBuilder buffer = new StringBuilder();
        String separator = "";
        try {
            buffer.append((String)this.siteNode.getPropertyGroup(this.view.getId()).getProperty(Properties.PROPERTY_TITLE));
            separator = " - ";
        }
        catch (NotFoundException | IOException throwable) {
            // empty catch block
        }
        try {
            String t = (String)properties.getProperty(Properties.PROPERTY_TITLE);
            buffer.append(separator).append(t);
        }
        catch (NotFoundException | IOException throwable) {
            // empty catch block
        }
        return buffer.toString();
    }

    void renderMainTitle(@Nonnull StringBuilder htmlBuilder) {
        try {
            String title = (String)this.siteNode.getPropertyGroup(this.view.getId()).getProperty(Properties.PROPERTY_TITLE);
            if (!title.trim().equals("")) {
                htmlBuilder.append(String.format("<h2>%s</h2>%n", title));
            }
        }
        catch (NotFoundException | IOException throwable) {
            // empty catch block
        }
    }

    void renderDate(@Nonnull StringBuilder htmlBuilder, @Nonnull DateTime blogDateTime) {
        htmlBuilder.append(String.format("<span class='nw-publishDate'>%s</span>%n", this.getDateTimeFormatter().print((ReadableInstant)blogDateTime)));
    }

    private void renderPermalink(@Nonnull StringBuilder htmlBuilder, @Nonnull Content post) throws IOException {
        try {
            String link = this.site.createLink(this.siteNode.getRelativeUri().appendedWith(post.getExposedUri()));
            htmlBuilder.append(String.format("&nbsp;- <a href='%s'>Permalink</a>%n", link));
            this.requestContext.setDynamicNodeProperty(PROP_ADD_URL, (Object)link);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void renderReferenceLink(@Nonnull StringBuilder htmlBuilder, @Nonnull Content post) throws IOException {
        try {
            String link = this.site.createLink(this.siteNode.getRelativeUri().appendedWith(post.getExposedUri()));
            String title = (String)post.getProperties().getProperty(Properties.PROPERTY_TITLE);
            htmlBuilder.append(String.format("<li><a href='%s'>%s</a></li>%n", link, title));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void renderCategory(@Nonnull StringBuilder htmlBuilder, @Nonnull Content post) throws IOException {
        try {
            htmlBuilder.append(String.format("&nbsp;- <span class='nw-blog-post-category'>Filed under \"%s\"</span>", post.getProperties().getProperty(PROPERTY_CATEGORY)));
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void renderTags(@Nonnull StringBuilder htmlBuilder, @Nonnull Content post) throws IOException {
        try {
            List<String> tags = Arrays.asList(((String)post.getProperties().getProperty(Properties.PROPERTY_TAGS)).split(","));
            Collections.sort(tags);
            StringBuilder buffer = new StringBuilder();
            String separator = "";
            for (String tag : tags) {
                String link = this.createTagLink(tag);
                buffer.append(separator).append(String.format("%n<a class='nw-tag' href='%s'>%s</a>", link, tag));
                separator = ", ";
            }
            htmlBuilder.append(String.format("&nbsp;- <span class='nw-blog-post-tags'>Tagged as %s</span>", buffer.toString()));
        }
        catch (NotFoundException | IOException throwable) {
            // empty catch block
        }
    }

    @Nonnull
    private String createTagLink(String tag) throws UnsupportedEncodingException {
        String tagLink = "tag/" + URLEncoder.encode(tag, "UTF-8");
        String link = this.site.createLink(this.siteNode.getRelativeUri().appendedWith(tagLink));
        if (!link.endsWith("/")) {
            link = link + "/";
        }
        return link;
    }

    @Nonnull
    private DateTimeFormatter getDateTimeFormatter() {
        try {
            String pattern = (String)this.siteNode.getPropertyGroup(this.view.getId()).getProperty(Properties.PROPERTY_DATE_FORMAT);
            return (pattern.length() == 2 ? DateTimeFormat.forStyle((String)pattern) : DateTimeFormat.forPattern((String)pattern)).withLocale((Locale)this.requestLocaleManager.getLocales().get(0));
        }
        catch (NotFoundException | IOException throwable) {
            return this.requestLocaleManager.getDateTimeFormatter();
        }
    }

    static {
        HtmlTemplateBlogViewController.ajc$preClinit();
        log = LoggerFactory.getLogger(HtmlTemplateBlogViewController.class);
        PROP_ADD_TITLE = new Key("@title");
        PROP_ADD_URL = new Key("@url");
        PROP_ADD_ID = new Key("@id");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("HtmlTemplateBlogViewController.java", HtmlTemplateBlogViewController.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "it.tidalwave.northernwind.frontend.ui.component.blog.htmltemplate.HtmlTemplateBlogViewController", "it.tidalwave.northernwind.frontend.ui.component.blog.BlogView:it.tidalwave.northernwind.core.model.SiteNode:it.tidalwave.northernwind.core.model.Site:it.tidalwave.northernwind.core.model.spi.RequestHolder:it.tidalwave.northernwind.core.model.RequestContext:it.tidalwave.northernwind.core.model.RequestLocaleManager", "view:siteNode:site:requestHolder:requestContext:requestLocaleManager", ""), 83);
    }
}

