/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.northernwind.frontend.ui.component.gallery.htmltemplate.bluette;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import it.tidalwave.northernwind.core.model.HttpStatusException;
import it.tidalwave.northernwind.core.model.ResourcePath;
import it.tidalwave.northernwind.core.model.ResourceProperties;
import it.tidalwave.northernwind.core.model.Site;
import it.tidalwave.northernwind.core.model.SiteNode;
import it.tidalwave.northernwind.core.model.SiteProvider;
import it.tidalwave.northernwind.frontend.ui.component.gallery.GalleryView;
import it.tidalwave.northernwind.frontend.ui.component.gallery.GalleryViewController;
import it.tidalwave.northernwind.frontend.ui.component.gallery.spi.GalleryAdapterContext;
import it.tidalwave.northernwind.frontend.ui.component.gallery.spi.GalleryAdapterSupport;
import it.tidalwave.northernwind.frontend.ui.component.htmltemplate.TextHolder;
import it.tidalwave.util.Id;
import it.tidalwave.util.Key;
import it.tidalwave.util.NotFoundException;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.stringtemplate.v4.ST;

@Configurable
public class BluetteGalleryAdapter
extends GalleryAdapterSupport {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log;
    private static final Key<String> PROPERTY_COPYRIGHT;
    @Nonnull
    private final GalleryAdapterContext context;
    @Inject
    private Provider<SiteProvider> siteProvider;
    private final String galleryTemplate;
    private final String fallbackTemplate;
    private final String lightboxFallbackTemplate;
    private String copyright;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public BluetteGalleryAdapter(@Nonnull GalleryAdapterContext context) throws IOException {
        GalleryAdapterContext galleryAdapterContext = context;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)galleryAdapterContext);
        this.copyright = "";
        this.context = context;
        this.galleryTemplate = this.loadTemplate(context, "bluette");
        this.fallbackTemplate = this.loadTemplate(context, "bluetteFallback");
        this.lightboxFallbackTemplate = this.loadTemplate(context, "bluetteLightboxFallback");
        ResourceProperties bluetteConfiguration = context.getSiteNode().getPropertyGroup(new Id((Object)"bluetteConfiguration"));
        this.copyright = (String)bluetteConfiguration.getProperty(PROPERTY_COPYRIGHT, (Object)"");
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    public void renderGallery(@Nonnull GalleryView view, @Nonnull List<GalleryViewController.Item> items) {
        GalleryViewController.Item item = items.get(0);
        int itemCount = items.size();
        int index = items.indexOf(item);
        Site site = ((SiteProvider)this.siteProvider.get()).getSite();
        ResourcePath baseUrl = this.context.getSiteNode().getRelativeUri().prependedWith(site.getContextPath());
        String previousUrl = site.createLink(baseUrl.appendedWith(items.get((index - 1 + itemCount) % itemCount).getId().stringValue()));
        String nextUrl = site.createLink(baseUrl.appendedWith(items.get((index + 1) % itemCount).getId().stringValue()));
        String lightboxUrl = site.createLink(baseUrl.appendedWith("lightbox"));
        ST t = new ST(this.galleryTemplate, '$', '$').add("caption", (Object)item.getDescription()).add("previous", (Object)previousUrl).add("next", (Object)nextUrl).add("lightbox", (Object)lightboxUrl).add("home", (Object)"/blog").add("copyright", (Object)this.copyright);
        this.context.addAttribute("content", t.render());
    }

    @Nonnull
    public String getInlinedScript() {
        StringBuilder builder = new StringBuilder();
        try {
            SiteNode siteNode = this.context.getSiteNode();
            String link = ((SiteProvider)this.siteProvider.get()).getSite().createLink(siteNode.getRelativeUri().appendedWith("images.xml"));
            builder.append("<script type=\"text/javascript\">\n//<![CDATA[\n");
            builder.append(String.format("var bluetteCatalogUrl = \"%s\";%n", link));
            ResourceProperties bluetteConfiguration = siteNode.getPropertyGroup(new Id((Object)"bluetteConfiguration"));
            for (Key key : bluetteConfiguration.getKeys()) {
                if (!key.stringValue().startsWith("bluette") && !key.stringValue().equals("logging")) continue;
                Object value = bluetteConfiguration.getProperty(key);
                builder.append(String.format("var %s = %s;%n", key.stringValue(), value));
            }
            builder.append("//]]>\n</script>\n");
        }
        catch (NotFoundException | IOException throwable) {
            // empty catch block
        }
        return builder.toString();
    }

    public void renderCatalog(@Nonnull GalleryView view, @Nonnull List<GalleryViewController.Item> items) throws HttpStatusException {
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        builder.append("<gallery>\n");
        for (GalleryViewController.Item item : items) {
            builder.append(String.format("    <stillImage id=\"%s\" title=\"%s\" />%n", item.getId(), item.getDescription()));
        }
        builder.append("</gallery>\n");
        TextHolder textHolder = (TextHolder)view;
        textHolder.setTemplate("$content$\n");
        textHolder.setContent(builder.toString());
        textHolder.setMimeType("text/xml");
    }

    public void renderFallback(@Nonnull GalleryView view, @Nonnull GalleryViewController.Item item, @Nonnull List<GalleryViewController.Item> items) {
        TextHolder textHolder = (TextHolder)view;
        int itemCount = items.size();
        int index = items.indexOf(item);
        Site site = ((SiteProvider)this.siteProvider.get()).getSite();
        ResourcePath baseUrl = this.context.getSiteNode().getRelativeUri().prependedWith(site.getContextPath());
        String redirectUrl = site.createLink(baseUrl.appendedWith("#!").appendedWith(item.getId().stringValue())).replaceAll("/$", "");
        String previousUrl = site.createLink(baseUrl.appendedWith(items.get((index - 1 + itemCount) % itemCount).getId().stringValue()));
        String nextUrl = site.createLink(baseUrl.appendedWith(items.get((index + 1) % itemCount).getId().stringValue()));
        String lightboxUrl = site.createLink(baseUrl.appendedWith("lightbox"));
        String redirectScript = "<script type=\"text/javascript\">\n//<![CDATA[\nwindow.location.replace('" + redirectUrl + "');\n" + "//]]>\n" + "</script>\n";
        ST t = new ST(this.fallbackTemplate, '$', '$').add("caption", (Object)item.getDescription()).add("previous", (Object)previousUrl).add("next", (Object)nextUrl).add("lightbox", (Object)lightboxUrl).add("home", (Object)"/blog").add("imageUrl", (Object)("/media/stillimages/800/" + item.getId().stringValue() + ".jpg")).add("copyright", (Object)this.copyright);
        textHolder.addAttribute("content", t.render());
        textHolder.addAttribute("description", item.getDescription());
        textHolder.addAttribute("inlinedScripts", redirectScript);
        textHolder.addAttribute("scripts", "");
    }

    public void renderLightboxFallback(@Nonnull GalleryView view, @Nonnull List<GalleryViewController.Item> items) {
        Site site = ((SiteProvider)this.siteProvider.get()).getSite();
        ResourcePath baseUrl = this.context.getSiteNode().getRelativeUri().prependedWith(site.getContextPath());
        StringBuilder builder = new StringBuilder();
        for (GalleryViewController.Item item : items) {
            String id = item.getId().stringValue();
            String link = site.createLink(baseUrl.appendedWith(id));
            builder.append(String.format("<a href=\"%s\"><img src=\"/media/stillimages/100/%s.jpg\"/></a>%n", link, id));
        }
        String redirectUrl = site.createLink(baseUrl.appendedWith("#!").appendedWith("lightbox")).replaceAll("/$", "");
        String redirectScript = "<script type=\"text/javascript\">\n//<![CDATA[\nwindow.location.replace('" + redirectUrl + "');\n" + "//]]>\n" + "</script>\n";
        TextHolder textHolder = (TextHolder)view;
        ST t = new ST(this.lightboxFallbackTemplate, '$', '$').add("content", (Object)builder.toString()).add("copyright", (Object)this.copyright);
        textHolder.addAttribute("content", t.render());
        textHolder.addAttribute("inlinedScripts", redirectScript);
        textHolder.addAttribute("scripts", "");
    }

    static {
        BluetteGalleryAdapter.ajc$preClinit();
        log = LoggerFactory.getLogger(BluetteGalleryAdapter.class);
        PROPERTY_COPYRIGHT = new Key("copyright");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BluetteGalleryAdapter.java", BluetteGalleryAdapter.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "it.tidalwave.northernwind.frontend.ui.component.gallery.htmltemplate.bluette.BluetteGalleryAdapter", "it.tidalwave.northernwind.frontend.ui.component.gallery.spi.GalleryAdapterContext", "context", "java.io.IOException"), 76);
    }
}

