/*
 * Decompiled with CFR 0.152.
 */
package kim.sesame.framework.cache.redis.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import kim.sesame.framework.cache.annotation.QueryCache;
import kim.sesame.framework.cache.annotation.ResultType;
import kim.sesame.framework.cache.redis.config.QueryCacheProperties;
import kim.sesame.framework.cache.redis.server.CacheServer;
import kim.sesame.framework.utils.StringUtil;
import kim.sesame.framework.web.context.SpringContextUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class QueryCacheAop {
    private static final Log log = LogFactory.getLog(QueryCacheAop.class);
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    QueryCacheProperties queryCache;

    @Around(value="@annotation(kim.sesame.framework.cache.annotation.QueryCache)")
    public Object aroundMethod(ProceedingJoinPoint pjd) throws Throwable {
        Object result = null;
        log.debug((Object)"");
        MethodSignature sign = (MethodSignature)pjd.getSignature();
        Method method = sign.getMethod();
        QueryCache ann = method.getAnnotation(QueryCache.class);
        Object[] params = pjd.getArgs();
        String classPath = pjd.getSignature().getDeclaringTypeName();
        String methodName = pjd.getSignature().getName();
        String cacheKey = QueryCacheAop.getCacheKey(ann.key(), ann.keyPrefix(), classPath, methodName, params);
        log.debug((Object)("\u7f13\u5b58 : key = " + cacheKey));
        int time = 0;
        TimeUnit timeUnit = null;
        if (ann.invalidTime() == 0) {
            time = this.queryCache.getInvalidTime();
            timeUnit = TimeUnit.MINUTES;
        } else {
            time = ann.invalidTime();
            timeUnit = ann.timeUnit();
        }
        String cacheResult = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
        if (StringUtil.isEmpty((Object)cacheResult)) {
            log.debug((Object)MessageFormat.format("\u7f13\u5b58\u4e0d\u5b58\u5728,\u8d70\u6570\u636e\u5e93\u67e5\u8be2 ,\u5b58\u50a8\u65f6\u95f4 : {0} , \u5355\u4f4d : {1} ", new Object[]{time, timeUnit}));
            result = pjd.proceed();
            String json = "";
            json = ann.isWriteNullValue() ? JSON.toJSONString((Object)result, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}) : JSON.toJSONString((Object)result);
            this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)json, (long)time, timeUnit);
        } else if (ann.resultType() == ResultType.Object) {
            result = JSON.parseObject((String)cacheResult, (Class)ann.resultClazz());
        } else if (ann.resultType() == ResultType.List) {
            result = JSONArray.parseArray((String)cacheResult, (Class)ann.resultClazz());
        }
        log.debug(result);
        log.debug((Object)"");
        return result;
    }

    private static String getCacheKey(String key, String prefix, String classPath, String methodName, Object ... params) {
        StringBuffer sb = new StringBuffer();
        if (StringUtil.isNotEmpty((Object)key)) {
            sb.append(key);
        } else {
            if (StringUtil.isNotEmpty((Object)prefix)) {
                sb.append(prefix).append("_");
            }
            sb.append(classPath).append(".").append(methodName);
        }
        if (params != null && params.length > 0) {
            sb.append("_");
            for (Object s : params) {
                if (s == null) continue;
                sb.append(s.toString()).append("#");
            }
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static void invalid(String key, String prefix, String classPath, String methodName, Object[] params) {
        String cachekey = QueryCacheAop.getCacheKey(key, prefix, classPath, methodName, params);
        CacheServer cacheServer = (CacheServer)SpringContextUtil.getBean(CacheServer.class);
        cacheServer.invalid(cachekey);
    }
}

