/*
 * Decompiled with CFR 0.152.
 */
package kim.sesame.framework.cache.redis.server;

import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kim.sesame.framework.utils.GsonUtil;
import kim.sesame.framework.utils.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.core.StringRedisTemplate;

public class AutoRefreshCache<T>
implements InitializingBean {
    private static final Log log = LogFactory.getLog(AutoRefreshCache.class);
    protected StringRedisTemplate stringRedisTemplate;
    protected int refreshTime;
    protected Class clazz = Object.class;
    protected volatile boolean state = false;
    protected boolean openCache = true;

    protected List<T> dataLoading() {
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.openCache) {
            return;
        }
        Thread t = new Thread(() -> {
            while (true) {
                this.refresh();
                try {
                    TimeUnit.SECONDS.sleep(this.refreshTime);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        if (Thread.currentThread().getName().equals("main")) {
            t.setDaemon(true);
        }
        t.start();
    }

    public void refresh() {
        String key = this.getKey();
        log.debug((Object)"-----------  \u81ea\u52a8\u5237\u65b0\u7f13\u5b58\u6570\u636e  start  ----------------------------------------");
        log.debug((Object)MessageFormat.format("\u5b58\u50a8\u65f6\u95f4 : {0} {1}, key : {2}", new Object[]{this.refreshTime, TimeUnit.MINUTES, key}));
        List<T> list = this.dataLoading();
        String json = GsonUtil.getGson().toJson(list);
        this.state = false;
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)json, (long)this.refreshTime, TimeUnit.MINUTES);
        this.state = true;
        log.debug((Object)"-----------  \u81ea\u52a8\u5237\u65b0\u7f13\u5b58\u6570\u636e  end  ----------------------------------------");
    }

    public List<T> getData() {
        if (!this.openCache) {
            return null;
        }
        int count = 0;
        while (!this.state) {
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (++count < 5) continue;
            return null;
        }
        String cacheResult = (String)this.stringRedisTemplate.opsForValue().get((Object)this.getKey());
        if (StringUtil.isNotEmpty((Object)cacheResult)) {
            return GsonUtil.fromJsonList((String)cacheResult, (Class)this.clazz);
        }
        return null;
    }

    protected String getKey() {
        return this.getClass().toString().replace("class ", "");
    }
}

