/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import kr.jclab.javautils.sipc.ProcessSipcHost;
import kr.jclab.javautils.sipc.channel.ClientContext;
import kr.jclab.javautils.sipc.channel.stdio.StdioChannelHost;
import kr.jclab.javautils.sipc.crypto.CryptoException;
import kr.jclab.javautils.sipc.crypto.DefaultEphemeralKeyAlgorithmsFactory;
import kr.jclab.javautils.sipc.crypto.EphemeralKeyAlgorithmFactory;

public class ProcessStdioSipcHost
extends ProcessSipcHost {
    private final Thread ioThread = new Thread(() -> {
        InputStream stdoutStream = this.process.getInputStream();
        InputStream stderrStream = this.process.getErrorStream();
        byte[] buffer = new byte[2048];
        try {
            boolean tick = false;
            while (true) {
                int readLength;
                if (!this.process.isAlive()) {
                    // empty if block
                }
                boolean processed = false;
                if (stdoutStream.available() > 0) {
                    processed = true;
                    readLength = stdoutStream.read(buffer);
                    this.clientContext.feedData(buffer, readLength);
                }
                if (stderrStream.available() > 0) {
                    processed = true;
                    readLength = stderrStream.read(buffer);
                    System.err.println(new String(buffer, 0, readLength));
                }
                if (!processed) {
                    if (tick) {
                        Thread.yield();
                    } else {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                tick = !tick;
            }
        }
        catch (IOException e) {
            this.feedError(e);
            return;
        }
    });
    private final StdioClientContext clientContext = new StdioClientContext();

    private ProcessStdioSipcHost(EphemeralKeyAlgorithmFactory keyPairGenerator, Executor executor) throws CryptoException {
        super(StdioChannelHost.getInstance(), keyPairGenerator, executor);
        this.channel.attachClientContext(this.clientContext);
    }

    @Override
    public void attachProcess(Process process) {
        super.attachProcess(process);
        this.ioThread.start();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private EphemeralKeyAlgorithmFactory keyPairGenerator = null;
        private Executor executor = null;

        public Builder keyPairGenerator(EphemeralKeyAlgorithmFactory keyPairGenerator) {
            this.keyPairGenerator = keyPairGenerator;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public ProcessStdioSipcHost build() throws CryptoException {
            if (this.keyPairGenerator == null) {
                this.keyPairGenerator = DefaultEphemeralKeyAlgorithmsFactory.getInstance();
            }
            return new ProcessStdioSipcHost(this.keyPairGenerator, this.executor);
        }
    }

    private class StdioClientContext
    extends ClientContext {
        public StdioClientContext() {
            this.recvSetFrameHandlers(ProcessStdioSipcHost.this.channel);
        }

        public void feedData(byte[] data, int length) throws IOException {
            this.receivingBuffer.put(data, 0, length);
            this.recvAfterReadRaw();
        }

        @Override
        protected void recvDecideRoute(String channelId) {
        }

        @Override
        protected void sendRaw(byte[] data) throws IOException {
            ProcessStdioSipcHost.this.process.getOutputStream().write(data);
        }
    }
}

