/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc.bson;

import java.nio.ByteBuffer;
import kr.jclab.javautils.sipc.bson.entity.ConnectInfo;
import kr.jclab.javautils.sipc.bson.entity.TcpConnectInfo;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonWriter;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.Conventions;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

public class SipcBsonHelper {
    private final BsonDocumentCodec codec = new BsonDocumentCodec(CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider(), new ValueCodecProvider(), PojoCodecProvider.builder().conventions(Conventions.DEFAULT_CONVENTIONS).register(new Class[]{ConnectInfo.class}).register(new Class[]{TcpConnectInfo.class}).build()}));

    public static SipcBsonHelper getInstance() {
        return LazyHolder.INSTANCE;
    }

    public byte[] encode(Object entity) {
        BsonDocument document = BsonDocumentWrapper.asBsonDocument((Object)entity, (CodecRegistry)this.codec.getCodecRegistry());
        BasicOutputBuffer output = new BasicOutputBuffer();
        this.codec.encode((BsonWriter)new BsonBinaryWriter((BsonOutput)output), document, EncoderContext.builder().build());
        return output.toByteArray();
    }

    public ConnectInfo decodeConnectInfo(byte[] encoded) {
        BsonBinaryReader reader = new BsonBinaryReader(ByteBuffer.wrap(encoded));
        BsonDocument document = this.codec.decode((BsonReader)reader, DecoderContext.builder().build());
        BsonString channelType = document.getString((Object)"channel_type");
        if (TcpConnectInfo.CHANNEL_TYPES.contains(channelType.getValue())) {
            return (ConnectInfo)this.codec.getCodecRegistry().get(TcpConnectInfo.class).decode(document.asBsonReader(), DecoderContext.builder().build());
        }
        return (ConnectInfo)this.codec.getCodecRegistry().get(ConnectInfo.class).decode(document.asBsonReader(), DecoderContext.builder().build());
    }

    public static class LazyHolder {
        public static SipcBsonHelper INSTANCE = new SipcBsonHelper();
    }
}

