/*
 * Decompiled with CFR 0.152.
 */
package kr.jclab.javautils.sipc.bson.entity;

import java.util.Arrays;
import org.bson.codecs.pojo.annotations.BsonCreator;
import org.bson.codecs.pojo.annotations.BsonProperty;

public class ConnectInfo {
    @BsonProperty(value="channel_id")
    private final String channelId;
    @BsonProperty(value="channel_type")
    private final String channelType;
    @BsonProperty(value="algo")
    private final String algo;
    @BsonProperty(value="public_key")
    private final byte[] publicKey;

    @BsonCreator
    public ConnectInfo(@BsonProperty(value="channel_id") String channelId, @BsonProperty(value="channel_type") String channelType, @BsonProperty(value="algo") String algo, @BsonProperty(value="public_key") byte[] publicKey) {
        this.channelId = channelId;
        this.channelType = channelType;
        this.algo = algo;
        this.publicKey = publicKey;
    }

    public static Builder basicBuilder() {
        return new Builder();
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getAlgo() {
        return this.algo;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public String toString() {
        return "ConnectInfo(channelId=" + this.getChannelId() + ", channelType=" + this.getChannelType() + ", algo=" + this.getAlgo() + ", publicKey=" + Arrays.toString(this.getPublicKey()) + ")";
    }

    public static class Builder {
        private String channelId;
        private String channelType;
        private String algo;
        private byte[] publicKey;

        Builder() {
        }

        public Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        public Builder algo(String algo) {
            this.algo = algo;
            return this;
        }

        public Builder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public ConnectInfo build() {
            return new ConnectInfo(this.channelId, this.channelType, this.algo, this.publicKey);
        }

        public String toString() {
            return "ConnectInfo.Builder(channelId=" + this.channelId + ", channelType=" + this.channelType + ", algo=" + this.algo + ", publicKey=" + Arrays.toString(this.publicKey) + ")";
        }
    }
}

